/*
 * Decompiled with CFR 0.152.
 */
package main.walksy.lib.core.config.serialization;

import com.google.gson.JsonElement;
import main.walksy.lib.core.config.local.Option;
import main.walksy.lib.core.config.serialization.SerializableOption;
import main.walksy.lib.core.manager.WalksyLibConfigManager;

public class OptionConverter {
    public static SerializableOption fromOption(Option<?> opt) {
        SerializableOption s = new SerializableOption();
        s.name = opt.getName();
        s.type = opt.getType().getSimpleName().toLowerCase();
        s.value = WalksyLibConfigManager.GSON.toJsonTree(opt.getValue(), opt.getType());
        s.min = WalksyLibConfigManager.GSON.toJsonTree(opt.getMin());
        s.max = WalksyLibConfigManager.GSON.toJsonTree(opt.getMax());
        s.increment = WalksyLibConfigManager.GSON.toJsonTree(opt.getIncrement());
        return s;
    }

    public static void setOptionValue(Option<?> option, JsonElement valueElement) {
        Class<?> type = option.getType();
        try {
            Object value = WalksyLibConfigManager.GSON.fromJson(valueElement, type);
            if (value != null) {
                option.setValue(value);
            }
        }
        catch (Exception e) {
            System.err.println("Failed to deserialize value for option " + option.getName() + " to type " + type.getSimpleName() + ": " + e.getMessage());
        }
    }
}

