/*
 * Decompiled with CFR 0.152.
 */
package main.walksy.lib.core.config.serialization.adapters;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import main.walksy.lib.core.config.local.options.type.WalksyLibColor;

public class ColorTypeAdapter
extends TypeAdapter<WalksyLibColor> {
    public void write(JsonWriter out, WalksyLibColor color) throws IOException {
        if (color == null) {
            out.nullValue();
            return;
        }
        out.beginObject();
        out.name("r").value((long)color.getRed());
        out.name("g").value((long)color.getGreen());
        out.name("b").value((long)color.getBlue());
        out.name("a").value((long)color.getAlpha());
        out.name("value").value((long)color.getRGB());
        out.name("hue").value(color.getHue());
        out.name("saturation").value(color.getSaturation());
        out.name("brightness").value(color.getBrightness());
        out.name("rainbow").value(color.isRainbow());
        out.name("rainbowSpeed").value((long)color.getRainbowSpeed());
        out.name("pulse").value(color.isPulse());
        out.name("pulseSpeed").value((long)color.getPulseSpeed());
        out.endObject();
    }

    public WalksyLibColor read(JsonReader in) throws IOException {
        int r = 0;
        int g = 0;
        int b = 0;
        int a = 255;
        int value = 0;
        float hue = 0.0f;
        float saturation = 0.0f;
        float brightness = 0.0f;
        boolean rainbow = false;
        boolean pulse = false;
        int rainbowSpeed = 5;
        int pulseSpeed = 5;
        in.beginObject();
        block28: while (in.hasNext()) {
            switch (in.nextName()) {
                case "r": {
                    r = in.nextInt();
                    continue block28;
                }
                case "g": {
                    g = in.nextInt();
                    continue block28;
                }
                case "b": {
                    b = in.nextInt();
                    continue block28;
                }
                case "a": {
                    a = in.nextInt();
                    continue block28;
                }
                case "value": {
                    value = in.nextInt();
                    continue block28;
                }
                case "hue": {
                    hue = (float)in.nextDouble();
                    continue block28;
                }
                case "saturation": {
                    saturation = (float)in.nextDouble();
                    continue block28;
                }
                case "brightness": {
                    brightness = (float)in.nextDouble();
                    continue block28;
                }
                case "rainbow": {
                    rainbow = in.nextBoolean();
                    continue block28;
                }
                case "rainbowSpeed": {
                    rainbowSpeed = in.nextInt();
                    continue block28;
                }
                case "pulse": {
                    pulse = in.nextBoolean();
                    continue block28;
                }
                case "pulseSpeed": {
                    pulseSpeed = in.nextInt();
                    continue block28;
                }
            }
            in.skipValue();
        }
        in.endObject();
        WalksyLibColor color = new WalksyLibColor(r, g, b, a);
        color.setHue(hue);
        color.setSaturation(saturation);
        color.setBrightness(brightness);
        color.setRainbow(rainbow);
        color.setRainbowSpeed(rainbowSpeed);
        color.setPulse(pulse);
        color.setPulseSpeed(pulseSpeed);
        return color;
    }
}

