/*
 * Decompiled with CFR 0.152.
 */
package main.walksy.lib.core.config.serialization.adapters;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import main.walksy.lib.core.config.local.options.type.PixelGrid;

public class PixelGridAdapter
implements JsonSerializer<PixelGrid>,
JsonDeserializer<PixelGrid> {
    public JsonElement serialize(PixelGrid grid, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject obj = new JsonObject();
        obj.addProperty("width", (Number)grid.getWidth());
        obj.addProperty("height", (Number)grid.getHeight());
        JsonArray rows = new JsonArray();
        for (boolean[] row : grid.getPixels()) {
            JsonArray jsonRow = new JsonArray();
            for (boolean pixel : row) {
                jsonRow.add(Boolean.valueOf(pixel));
            }
            rows.add((JsonElement)jsonRow);
        }
        obj.add("pixels", (JsonElement)rows);
        return obj;
    }

    public PixelGrid deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        JsonObject obj = jsonElement.getAsJsonObject();
        int width = obj.get("width").getAsInt();
        int height = obj.get("height").getAsInt();
        JsonArray rows = obj.getAsJsonArray("pixels");
        boolean[][] pixels = new boolean[height][width];
        for (int y = 0; y < rows.size(); ++y) {
            JsonArray row = rows.get(y).getAsJsonArray();
            for (int x = 0; x < row.size(); ++x) {
                pixels[y][x] = row.get(x).getAsBoolean();
            }
        }
        return new PixelGrid(width, height, pixels);
    }
}

