/*
 * Decompiled with CFR 0.152.
 */
package main.walksy.lib.core.config.serialization.adapters;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import main.walksy.lib.core.config.local.options.type.PixelGrid;
import main.walksy.lib.core.config.local.options.type.PixelGridAnimation;

public class PixelGridAnimationAdapter
implements JsonSerializer<PixelGridAnimation>,
JsonDeserializer<PixelGridAnimation> {
    public JsonElement serialize(PixelGridAnimation src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject obj = new JsonObject();
        JsonArray frames = new JsonArray();
        for (PixelGrid frame : src.getFrames()) {
            frames.add(context.serialize((Object)frame));
        }
        obj.add("frames", (JsonElement)frames);
        obj.addProperty("animationSpeed", (Number)src.getAnimationSpeed());
        obj.addProperty("size", (Number)Float.valueOf(src.getSize()));
        JsonObject pos = new JsonObject();
        pos.addProperty("x", (Number)src.getOffsetX());
        pos.addProperty("y", (Number)src.getOffsetY());
        obj.add("position", (JsonElement)pos);
        return obj;
    }

    public PixelGridAnimation deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject obj = json.getAsJsonObject();
        JsonArray frameArray = obj.getAsJsonArray("frames");
        ArrayList<PixelGrid> frames = new ArrayList<PixelGrid>();
        for (JsonElement elem : frameArray) {
            frames.add((PixelGrid)context.deserialize(elem, PixelGrid.class));
        }
        PixelGridAnimation animation = new PixelGridAnimation(frames);
        if (obj.has("animationSpeed")) {
            animation.setAnimationSpeed(obj.get("animationSpeed").getAsInt());
        }
        if (obj.has("size")) {
            animation.setSize(obj.get("size").getAsFloat());
        }
        if (obj.has("position")) {
            JsonObject posObj = obj.getAsJsonObject("position");
            animation.setOffset(posObj.get("x").getAsDouble(), posObj.get("y").getAsDouble());
        }
        return animation;
    }
}

