/*
 * Decompiled with CFR 0.152.
 */
package main.walksy.lib.core.gui.impl;

import java.awt.Color;
import main.walksy.lib.core.config.local.Option;
import main.walksy.lib.core.config.local.options.type.PixelGrid;
import main.walksy.lib.core.config.local.options.type.PixelGridAnimation;
import main.walksy.lib.core.gui.impl.BaseScreen;
import main.walksy.lib.core.renderer.Renderer2D;
import net.minecraft.class_1921;
import net.minecraft.class_241;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_437;

public class HudEditorScreen
extends BaseScreen {
    private static final class_2960 CROSSHAIR_TEXTURE = class_2960.method_60656((String)"hud/crosshair");
    private final Option<?> hudOption;
    private boolean dragging = false;
    private double dragOffsetX = 0.0;
    private double dragOffsetY = 0.0;

    public HudEditorScreen(class_437 parent, Option<?> option) {
        super("HudEditor", parent);
        this.hudOption = option;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_25300(this.field_22793, "Currently Editing: " + this.hudOption.getName(), this.field_22789 / 2, 10, -1);
        context.method_25300(this.field_22793, "(ESC to leave)", this.field_22789 / 2, 20, Color.GRAY.getRGB());
        Object obj = this.hudOption.getValue();
        if (obj instanceof PixelGridAnimation) {
            PixelGridAnimation pixelGridAnimation = (PixelGridAnimation)obj;
            class_241 pos = pixelGridAnimation.getAbsolutePosition();
            float x = pos.field_1343;
            float y = pos.field_1342;
            if (this.field_22787.field_1687 == null) {
                context.method_25294(0, 0, this.field_22789, this.field_22790, Color.BLACK.getRGB());
                context.method_52706(class_1921::method_62280, CROSSHAIR_TEXTURE, (context.method_51421() - 15) / 2, (context.method_51443() - 15) / 2, 15, 15);
            }
            pixelGridAnimation.render(context, false);
            if (!this.dragging) {
                context.method_51448().method_22903();
                float size = pixelGridAnimation.getSize();
                context.method_51448().method_22905(size, size, size);
                Renderer2D.renderGridOutline(context, pixelGridAnimation.getCurrentFrame(), Math.round(x / size), Math.round(y / size), 1, 0);
                context.method_51448().method_22909();
            }
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        Object obj = this.hudOption.getValue();
        if (!(obj instanceof PixelGridAnimation)) {
            return super.method_25402(mouseX, mouseY, button);
        }
        PixelGridAnimation pixelGridAnimation = (PixelGridAnimation)obj;
        PixelGrid frame = pixelGridAnimation.getCurrentFrame();
        int frameW = frame == null ? 0 : frame.getWidth();
        int frameH = frame == null ? 0 : frame.getHeight();
        float size = pixelGridAnimation.getSize();
        int renderedW = Math.round((float)frameW * size);
        int renderedH = Math.round((float)frameH * size);
        int baseX = (this.field_22787.method_22683().method_4486() - renderedW) / 2;
        int baseY = (this.field_22787.method_22683().method_4502() - renderedH) / 2;
        double rawX = (double)baseX + pixelGridAnimation.getOffsetX();
        double rawY = (double)baseY + pixelGridAnimation.getOffsetY();
        if (mouseX >= rawX && mouseX <= rawX + (double)renderedW && mouseY >= rawY && mouseY <= rawY + (double)renderedH) {
            this.dragging = true;
            this.dragOffsetX = mouseX - rawX;
            this.dragOffsetY = mouseY - rawY;
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dx, double dy) {
        Object obj;
        if (!this.dragging || !((obj = this.hudOption.getValue()) instanceof PixelGridAnimation)) {
            return super.method_25403(mouseX, mouseY, button, dx, dy);
        }
        PixelGridAnimation pixelGridAnimation = (PixelGridAnimation)obj;
        PixelGrid frame = pixelGridAnimation.getCurrentFrame();
        int frameW = frame == null ? 0 : frame.getWidth();
        int frameH = frame == null ? 0 : frame.getHeight();
        float size = pixelGridAnimation.getSize();
        int renderedW = Math.round((float)frameW * size);
        int renderedH = Math.round((float)frameH * size);
        int baseX = (this.field_22787.method_22683().method_4486() - renderedW) / 2;
        int baseY = (this.field_22787.method_22683().method_4502() - renderedH) / 2;
        double newTopLeftX = mouseX - this.dragOffsetX;
        double newTopLeftY = mouseY - this.dragOffsetY;
        double offsetX = newTopLeftX - (double)baseX;
        double offsetY = newTopLeftY - (double)baseY;
        offsetX = (double)Math.round(offsetX * 2.0) / 2.0;
        offsetY = (double)Math.round(offsetY * 2.0) / 2.0;
        pixelGridAnimation.setOffset(offsetX, offsetY);
        return true;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (!this.dragging) {
            return super.method_25406(mouseX, mouseY, button);
        }
        this.dragging = false;
        Object obj = this.hudOption.getValue();
        if (!(obj instanceof PixelGridAnimation)) {
            return super.method_25406(mouseX, mouseY, button);
        }
        PixelGridAnimation pixelGridAnimation = (PixelGridAnimation)obj;
        PixelGrid frame = pixelGridAnimation.getCurrentFrame();
        int frameW = frame == null ? 0 : frame.getWidth();
        int frameH = frame == null ? 0 : frame.getHeight();
        float size = pixelGridAnimation.getSize();
        int renderedW = Math.round((float)frameW * size);
        int renderedH = Math.round((float)frameH * size);
        int baseX = (this.field_22787.method_22683().method_4486() - renderedW) / 2;
        int baseY = (this.field_22787.method_22683().method_4502() - renderedH) / 2;
        double newTopLeftX = mouseX - this.dragOffsetX;
        double newTopLeftY = mouseY - this.dragOffsetY;
        double offsetX = newTopLeftX - (double)baseX;
        double offsetY = newTopLeftY - (double)baseY;
        offsetX = (double)Math.round(offsetX * 2.0) / 2.0;
        offsetY = (double)Math.round(offsetY * 2.0) / 2.0;
        pixelGridAnimation.setOffset(offsetX, offsetY);
        this.hudOption.setValue(pixelGridAnimation);
        return true;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        Object obj = this.hudOption.getValue();
        if (obj instanceof PixelGridAnimation) {
            PixelGridAnimation pixelGridAnimation = (PixelGridAnimation)obj;
            double moveAmount = class_437.method_25442() ? 2.5 : 0.5;
            switch (keyCode) {
                case 265: {
                    pixelGridAnimation.addOffset(0.0, -moveAmount);
                    break;
                }
                case 264: {
                    pixelGridAnimation.addOffset(0.0, moveAmount);
                    break;
                }
                case 263: {
                    pixelGridAnimation.addOffset(-moveAmount, 0.0);
                    break;
                }
                case 262: {
                    pixelGridAnimation.addOffset(moveAmount, 0.0);
                    break;
                }
                default: {
                    return super.method_25404(keyCode, scanCode, modifiers);
                }
            }
            this.hudOption.setValue(pixelGridAnimation);
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    @Override
    public void method_25419() {
        Object obj = this.hudOption.getValue();
        if (obj instanceof PixelGridAnimation) {
            PixelGridAnimation pixelGridAnimation = (PixelGridAnimation)obj;
            this.hudOption.setValue(pixelGridAnimation);
        }
        super.method_25419();
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
    }
}

