/*
 * Decompiled with CFR 0.152.
 */
package main.walksy.lib.core.gui.impl;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import main.walksy.lib.core.config.impl.LocalConfig;
import main.walksy.lib.core.config.local.Category;
import main.walksy.lib.core.config.local.Option;
import main.walksy.lib.core.config.local.OptionDescription;
import main.walksy.lib.core.config.local.options.groups.OptionGroup;
import main.walksy.lib.core.gui.impl.APIScreen;
import main.walksy.lib.core.gui.impl.BaseScreen;
import main.walksy.lib.core.gui.popup.PopUp;
import main.walksy.lib.core.gui.popup.impl.WarningPopUp;
import main.walksy.lib.core.gui.utils.CategoryTab;
import main.walksy.lib.core.gui.utils.TabLocation;
import main.walksy.lib.core.gui.widgets.ButtonWidget;
import main.walksy.lib.core.gui.widgets.OpenableWidget;
import main.walksy.lib.core.gui.widgets.OptionGroupWidget;
import main.walksy.lib.core.gui.widgets.OptionWidget;
import main.walksy.lib.core.gui.widgets.PixelGridAnimationWidget;
import main.walksy.lib.core.gui.widgets.ScrollableTabWidget;
import main.walksy.lib.core.gui.widgets.SearchBarWidget;
import main.walksy.lib.core.gui.widgets.SpriteOptionWidget;
import main.walksy.lib.core.gui.widgets.StringListOptionWidget;
import main.walksy.lib.core.manager.WalksyLibConfigManager;
import main.walksy.lib.core.mixin.ScreenAccessor;
import main.walksy.lib.core.renderer.Renderer2D;
import main.walksy.lib.core.utils.Animation;
import main.walksy.lib.core.utils.MainColors;
import main.walksy.lib.core.utils.ScreenGlobals;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_7919;
import net.minecraft.class_8030;
import net.minecraft.class_8087;
import net.minecraft.class_8088;

public class WalksyLibConfigScreen
extends BaseScreen {
    private final class_8088 tabManager = new class_8088(x$0 -> {
        class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
    }, x$0 -> this.method_37066((class_364)x$0));
    private final List<OptionGroupWidget> allGroupWidgets = new ArrayList<OptionGroupWidget>();
    private final List<OptionWidget> allOptionWidgets = new ArrayList<OptionWidget>();
    private final List<CategoryTab> allTabs = new ArrayList<CategoryTab>();
    public final Animation scrollAnim = new Animation(0.0f, 0.5f);
    private final WalksyLibConfigManager configManager;
    private ScrollableTabWidget tabWidget;
    private ButtonWidget backButton;
    private ButtonWidget allModsButton;
    private ButtonWidget saveButton;
    private ButtonWidget resetButton;
    private ButtonWidget undoButton;
    private SearchBarWidget searchBar;
    private Option<?> focusedOption;
    public PopUp popUp = null;
    private int maxScroll = 0;
    public boolean scroll = true;

    public WalksyLibConfigScreen(class_437 parent, LocalConfig config) {
        super(config.name() + " Config Screen", parent);
        this.configManager = new WalksyLibConfigManager(config);
        this.focusedOption = null;
    }

    @Override
    public void method_25419() {
        if (this.popUp != null && !this.popUp.canClose()) {
            return;
        }
        if (this.shouldUndoOptions() && this.popUp == null) {
            this.popUp = new WarningPopUp(this, "You have unsaved changes!", "Are you sure you want to leave without saving?", () -> {
                this.undo();
                super.method_25419();
            }, () -> this.popUp.close());
            return;
        }
        if (this.popUp != null) {
            this.popUp.close();
            return;
        }
        super.method_25419();
        this.configManager.cleanCache();
        this.save(false);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.initButtons();
        this.initSearchBar();
        this.initTabs();
        this.method_48640();
        this.defineOptions();
        this.setOptionPrevs();
    }

    private void initButtons() {
        this.backButton = new ButtonWidget(8, 5, 50, 16, true, "Back", this::method_25419);
        this.allModsButton = new ButtonWidget(this.field_22789 - 65, 5, 57, 16, true, "WalksyLib", () -> this.field_22787.method_1507((class_437)new APIScreen(this)));
        this.saveButton = new ButtonWidget(this.field_22789 - 58, this.field_22790 - 21, 50, 16, true, "Save", () -> this.save(true));
        this.resetButton = new ButtonWidget(this.field_22789 - 58 - 55, this.field_22790 - 21, 50, 16, true, "Reset", this::resetOptions);
        this.undoButton = new ButtonWidget(this.field_22789 - 58 - 110, this.field_22790 - 21, 50, 16, true, "Undo", this::undo);
        this.method_37063((class_364)this.backButton);
        this.method_37063((class_364)this.allModsButton);
        this.method_37063((class_364)this.saveButton);
        this.method_37063((class_364)this.resetButton);
        this.method_37063((class_364)this.undoButton);
    }

    private void initSearchBar() {
        this.searchBar = new SearchBarWidget(class_2561.method_30163((String)"SearchBar"), this, 6, this.field_22790 - 21, 150, 16, this::search);
        this.method_37063((class_364)this.searchBar);
    }

    private void initTabs() {
        ArrayList<CategoryTab> tabList = new ArrayList<CategoryTab>();
        for (Category category : this.configManager.get().categories()) {
            ArrayList<OptionGroupWidget> groupWidgets = new ArrayList<OptionGroupWidget>();
            int yOffset = 60;
            for (OptionGroup group : category.optionGroups()) {
                int groupH = ScreenGlobals.OPTION_HEIGHT;
                int optionHeight = ScreenGlobals.OPTION_HEIGHT;
                int groupHeight = groupH;
                ScreenGlobals.OPTION_PANEL_STARTX = (int)((double)this.field_22789 * 0.75);
                ScreenGlobals.OPTION_PANEL_STARTY = 61;
                ScreenGlobals.OPTION_PANEL_ENDX = this.field_22789;
                ScreenGlobals.OPTION_PANEL_ENDY = this.field_22790 - 120;
                ScreenGlobals.OPTION_WIDTH = ScreenGlobals.OPTION_PANEL_STARTX - 30 - 22;
                OptionGroupWidget groupWidget = new OptionGroupWidget((this.field_22789 - (ScreenGlobals.OPTION_PANEL_ENDX - ScreenGlobals.OPTION_PANEL_STARTX)) / 2, yOffset, 150, groupH, group, this);
                if (group.isExpanded()) {
                    int childY = yOffset + groupH;
                    List<OptionWidget> children = groupWidget.getChildren();
                    int childCount = children.size();
                    for (int i = 0; i < childCount; ++i) {
                        OptionWidget child = children.get(i);
                        child.method_48229(child.method_46426(), childY);
                        childY += optionHeight;
                        groupHeight += optionHeight;
                        if (i >= childCount - 1) continue;
                        childY += ScreenGlobals.OPTION_GROUP_SEPARATION;
                        groupHeight += ScreenGlobals.OPTION_GROUP_SEPARATION;
                    }
                }
                groupWidget.method_53533(groupHeight);
                groupWidgets.add(groupWidget);
                this.allGroupWidgets.add(groupWidget);
                this.allOptionWidgets.addAll(groupWidget.getChildren());
                yOffset += groupHeight + 10;
            }
            CategoryTab tab = new CategoryTab(category, groupWidgets);
            tabList.add(tab);
            this.allTabs.add(tab);
        }
        this.tabWidget = new ScrollableTabWidget(0, 27, this.field_22789, 24, tabList, this.tabManager, TabLocation.TOP, this);
        this.method_37063((class_364)this.tabWidget);
        this.tabWidget.selectTab(0, true);
    }

    public void layoutGroupWidgets() {
        class_8087 class_80872 = this.tabManager.method_48614();
        if (!(class_80872 instanceof CategoryTab)) {
            return;
        }
        CategoryTab categoryTab = (CategoryTab)class_80872;
        List<OptionGroupWidget> widgets = categoryTab.getOptionGroupWidgets();
        int contentYOffset = 60;
        for (OptionGroupWidget group : widgets) {
            if (!group.field_22764) continue;
            int groupHeight = ScreenGlobals.OPTION_HEIGHT;
            if (group.getGroup().isExpanded()) {
                List<OptionWidget> children = group.getChildren();
                for (int i = 0; i < children.size(); ++i) {
                    OptionWidget child = children.get(i);
                    if (!child.isVisible()) continue;
                    int childHeight = ScreenGlobals.OPTION_HEIGHT;
                    if (child instanceof OpenableWidget) {
                        OpenableWidget oW = (OpenableWidget)child;
                        childHeight = (int)oW.getCurrentHeight();
                    } else if (child instanceof StringListOptionWidget) {
                        StringListOptionWidget slw = (StringListOptionWidget)child;
                        childHeight += slw.ADDITIONAL_HEIGHT;
                    }
                    groupHeight += childHeight;
                    boolean hasNextVisible = false;
                    for (int j = i + 1; j < children.size(); ++j) {
                        if (!children.get(j).isVisible()) continue;
                        hasNextVisible = true;
                        break;
                    }
                    if (!hasNextVisible) continue;
                    groupHeight += ScreenGlobals.OPTION_GROUP_SEPARATION;
                }
            }
            group.method_53533(groupHeight);
            contentYOffset += groupHeight + 10;
        }
        int viewHeight = this.field_22790 - 120;
        this.maxScroll = Math.max(0, contentYOffset - 10 * widgets.size() - viewHeight);
        if (this.scrollAnim.getTargetValue() > (float)this.maxScroll) {
            this.scrollAnim.setTargetValue(Math.max(0, this.maxScroll));
        }
        int yOffset = (int)(60.0f - this.scrollAnim.getCurrentValue());
        for (OptionGroupWidget group : widgets) {
            if (!group.field_22764) continue;
            group.method_48229((this.field_22789 - 150) / 2, yOffset);
            if (group.getGroup().isExpanded()) {
                int childY = yOffset + ScreenGlobals.OPTION_HEIGHT;
                List<OptionWidget> children = group.getChildren();
                for (int i = 0; i < children.size(); ++i) {
                    OptionWidget child = children.get(i);
                    if (!child.isVisible()) continue;
                    int childHeight = ScreenGlobals.OPTION_HEIGHT;
                    if (child instanceof OpenableWidget) {
                        OpenableWidget oW = (OpenableWidget)child;
                        childHeight = (int)oW.getCurrentHeight();
                    } else if (child instanceof StringListOptionWidget) {
                        StringListOptionWidget slw = (StringListOptionWidget)child;
                        childHeight += slw.ADDITIONAL_HEIGHT;
                    }
                    child.method_48229(child.method_46426(), childY);
                    child.method_53533(childHeight);
                    int size = ScreenGlobals.OPTION_HEIGHT;
                    child.onWidgetUpdate(child.method_46426() + child.method_25368() - size + 22, childY);
                    childY += childHeight;
                    boolean hasNextVisible = false;
                    for (int j = i + 1; j < children.size(); ++j) {
                        if (!children.get(j).isVisible()) continue;
                        hasNextVisible = true;
                        break;
                    }
                    if (!hasNextVisible) continue;
                    childY += ScreenGlobals.OPTION_GROUP_SEPARATION;
                }
            }
            yOffset += group.method_25364() + 10;
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.renderBackgroundLayer(context, delta);
        this.renderBlurEffect();
        super.method_25394(context, this.popUp == null ? mouseX : 0, this.popUp == null ? mouseY : 0, delta);
        this.render(context);
        this.scrollAnim.update(delta, this::layoutGroupWidgets);
        if (this.isConfigEmpty()) {
            context.method_25300(this.method_64506(), "No Available Options...", this.field_22789 / 2, this.field_22790 / 2, -1);
        }
        if (this.popUp != null) {
            Renderer2D.startPopUpRender(context, 1, this.field_22789, this.field_22790);
            this.popUp.render(context, mouseX, mouseY, delta);
            Renderer2D.endPopUpRender(context);
        }
    }

    private void render(class_332 context) {
        context.method_25292(0, this.field_22789, 25, MainColors.OUTLINE_BLACK.getRGB());
        context.method_25292(0, this.field_22789, 26, MainColors.OUTLINE_WHITE.getRGB());
        context.method_25292(0, this.field_22789, this.field_22790 - 28, MainColors.OUTLINE_BLACK.getRGB());
        context.method_25292(0, this.field_22789, this.field_22790 - 27, MainColors.OUTLINE_WHITE.getRGB());
        String string = this.configManager.get().name();
        int n = this.field_22789 / 2;
        Objects.requireNonNull(this.field_22793);
        context.method_25300(this.field_22793, string, n, 12 - 9 / 2, -1);
        ScreenGlobals.OPTION_PANEL_STARTX = (int)((double)this.field_22789 * 0.75);
        ScreenGlobals.OPTION_PANEL_STARTY = 61;
        ScreenGlobals.OPTION_PANEL_ENDX = this.field_22789;
        ScreenGlobals.OPTION_PANEL_ENDY = this.field_22790 - 120;
        this.saveButton.setEnabled(this.shouldUndoOptions());
        this.saveButton.method_47400(!this.saveButton.field_22763 ? class_7919.method_47407((class_2561)class_2561.method_30163((String)"No changes have occurred")) : null);
        this.resetButton.setEnabled(this.shouldResetOptions());
        this.undoButton.setEnabled(this.shouldUndoOptions());
        if (!this.isConfigEmpty()) {
            this.renderOptionPanel(context, this.focusedOption);
        }
    }

    private void renderOptionPanel(class_332 context, Option<?> option) {
        block7: {
            int lineY;
            int endX;
            int startX;
            block8: {
                startX = ScreenGlobals.OPTION_PANEL_STARTX;
                int startY = ScreenGlobals.OPTION_PANEL_STARTY;
                endX = ScreenGlobals.OPTION_PANEL_ENDX;
                int endY = ScreenGlobals.OPTION_PANEL_ENDY;
                Renderer2D.fillRoundedRect(context, startX, startY, endX, endY, 2, new Color(0, 0, 0, 100).getRGB());
                Renderer2D.fillRoundedRectOutline(context, startX, startY - 1, endX, endY, 2, 1, MainColors.OUTLINE_WHITE.getRGB());
                Renderer2D.fillRoundedRectOutline(context, startX - 1, startY - 2, endX, endY + 2, 2, 1, MainColors.OUTLINE_BLACK.getRGB());
                if (option == null) break block7;
                String optionName = option.getName();
                int maxTextWidth = endX - startX - 20;
                List nameLines = this.field_22793.method_1728((class_5348)class_2561.method_30163((String)optionName), maxTextWidth);
                int lineSpacing = 2;
                int n = nameLines.size();
                Objects.requireNonNull(this.field_22793);
                int totalNameHeight = n * 9 + (nameLines.size() - 1) * lineSpacing;
                int centerY = 66;
                int nameStartY = centerY - totalNameHeight / 2 + 4;
                int z = nameLines.size() > 1 ? 4 : 0;
                for (int i = 0; i < nameLines.size(); ++i) {
                    Objects.requireNonNull(this.field_22793);
                    int lineY2 = nameStartY + i * (9 + lineSpacing);
                    context.method_35719(this.field_22793, (class_5481)nameLines.get(i), (startX + endX) / 2, lineY2 + z, -1);
                }
                lineY = nameStartY + totalNameHeight + 4;
                context.method_25292(startX + 1, endX, lineY, MainColors.OUTLINE_WHITE.getRGB());
                OptionDescription desc = option.getDescription();
                if (desc == null) break block8;
                switch (desc.getType()) {
                    case TEXT: {
                        String description = desc.getStringSupplier().get();
                        int descStartY = lineY + 8;
                        int maxWidth = endX - startX - 10;
                        List lines = this.field_22793.method_1728((class_5348)class_2561.method_30163((String)description), maxWidth);
                        for (class_5481 line : lines) {
                            int lineWidth = this.field_22793.method_30880(line);
                            int descStartX = startX + (endX - startX - lineWidth) / 2;
                            context.method_35720(this.field_22793, line, descStartX, descStartY, new Color(182, 182, 182).getRGB());
                            Objects.requireNonNull(this.field_22793);
                            descStartY += 9 + 2;
                        }
                        break block7;
                    }
                    case RENDER: {
                        context.method_44379(startX, startY, startX + endX, startY + endY);
                        desc.getRenderConsumer().accept(context, new OptionDescription.OptionPanel(startX, startY, endX, endY));
                        context.method_44380();
                    }
                }
                break block7;
            }
            context.method_25300(this.field_22793, "No Description", (startX + endX) / 2, lineY + 8, -1);
        }
        if (this.popUp != null) {
            this.popUp.layout(this.popUp.width, this.popUp.height);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.popUp != null) {
            this.popUp.onClick(mouseX, mouseY, button);
        } else if (!this.tabWidget.isHoveringOverAnyTab(mouseX, mouseY)) {
            if (!this.searchBar.method_49606()) {
                this.searchBar.method_25365(false);
            }
            ((ScreenAccessor)((Object)this)).getDrawables().forEach(w -> {
                if (w instanceof OptionGroupWidget) {
                    OptionGroupWidget optionGroupWidget = (OptionGroupWidget)((Object)w);
                    optionGroupWidget.onMouseClick(mouseX, mouseY, button);
                } else if (w instanceof OptionWidget) {
                    OptionWidget optionWidget = (OptionWidget)((Object)w);
                    if (optionWidget.isVisible() && optionWidget.isInScissor(0, 49, this.field_22789, this.field_22790 - 28) && optionWidget.isAvailable()) {
                        optionWidget.onMouseClick(mouseX, mouseY, button);
                    }
                    if (optionWidget.resetButton.field_22763) {
                        optionWidget.resetButton.method_25348(mouseX, mouseY);
                    }
                }
            });
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.popUp != null) {
            this.popUp.onMouseRelease(mouseX, mouseY, button);
        }
        ((ScreenAccessor)((Object)this)).getDrawables().forEach(w -> {
            if (w instanceof OptionGroupWidget) {
                OptionGroupWidget optionGroupWidget = (OptionGroupWidget)((Object)w);
            } else if (w instanceof OptionWidget) {
                OptionWidget optionWidget = (OptionWidget)((Object)w);
                optionWidget.onMouseRelease(mouseX, mouseY, button);
            }
        });
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.popUp == null) {
            ((ScreenAccessor)((Object)this)).getDrawables().forEach(w -> {
                OptionWidget optionWidget;
                if (w instanceof OptionGroupWidget) {
                    OptionGroupWidget optionGroupWidget = (OptionGroupWidget)((Object)w);
                } else if (w instanceof OptionWidget && (optionWidget = (OptionWidget)((Object)w)).isAvailable()) {
                    optionWidget.onMouseDrag(mouseX, mouseY, button, deltaX, deltaY);
                }
            });
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public void method_16014(double mouseX, double mouseY) {
        if (this.popUp == null) {
            ((ScreenAccessor)((Object)this)).getDrawables().forEach(w -> {
                OptionWidget optionWidget;
                if (w instanceof OptionGroupWidget) {
                    OptionGroupWidget optionGroupWidget = (OptionGroupWidget)((Object)w);
                } else if (w instanceof OptionWidget && (optionWidget = (OptionWidget)((Object)w)).isAvailable()) {
                    optionWidget.onMouseMove(mouseX, mouseY);
                }
            });
        }
        super.method_16014(mouseX, mouseY);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.popUp == null && this.scroll) {
            float newTarget = this.scrollAnim.getTargetValue() - (float)(verticalAmount * 20.0);
            newTarget = Math.max(0.0f, Math.min(newTarget, (float)this.maxScroll));
            this.scrollAnim.setTargetValue(newTarget);
        } else if (this.popUp == null) {
            ((ScreenAccessor)((Object)this)).getDrawables().forEach(w -> {
                OptionWidget optionWidget;
                if (w instanceof OptionWidget && (optionWidget = (OptionWidget)((Object)w)).isAvailable()) {
                    optionWidget.onMouseScroll(mouseX, mouseY, verticalAmount);
                }
            });
        } else {
            this.popUp.onScroll(mouseX, mouseY, verticalAmount);
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.popUp == null) {
            ((ScreenAccessor)((Object)this)).getDrawables().forEach(w -> {
                OptionWidget optionWidget;
                if (w instanceof OptionGroupWidget) {
                    OptionGroupWidget optionGroupWidget = (OptionGroupWidget)((Object)w);
                } else if (w instanceof OptionWidget && (optionWidget = (OptionWidget)((Object)w)).isAvailable()) {
                    optionWidget.onKeyPress(keyCode, scanCode, modifiers);
                }
            });
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int modifiers) {
        if (this.popUp == null) {
            ((ScreenAccessor)((Object)this)).getDrawables().forEach(w -> {
                OptionWidget optionWidget;
                if (w instanceof OptionGroupWidget) {
                    OptionGroupWidget optionGroupWidget = (OptionGroupWidget)((Object)w);
                } else if (w instanceof OptionWidget && (optionWidget = (OptionWidget)((Object)w)).isAvailable()) {
                    optionWidget.onCharTyped(chr, modifiers);
                }
            });
        }
        return super.method_25400(chr, modifiers);
    }

    protected void method_48640() {
        if (this.tabWidget != null) {
            this.tabWidget.method_25358(this.field_22789);
            this.tabWidget.method_48229(0, 27);
            int i = this.tabWidget.method_48202().method_49619();
            class_8030 screenRect = new class_8030(0, i, this.field_22789, this.field_22790 - 36 - i);
            this.tabManager.method_48616(screenRect);
            this.layoutGroupWidgets();
        }
        this.backButton.method_48229(8, 5);
        this.allModsButton.method_48229(this.field_22789 - 65, 5);
        this.saveButton.method_48229(this.field_22789 - 58, this.field_22790 - 21);
        this.resetButton.method_48229(this.field_22789 - 58 - 55, this.field_22790 - 21);
        this.undoButton.method_48229(this.field_22789 - 58 - 110, this.field_22790 - 21);
        this.searchBar.method_48229(6, this.field_22790 - 21);
        ScreenGlobals.OPTION_PANEL_STARTX = (int)((double)this.field_22789 * 0.75);
        ScreenGlobals.OPTION_PANEL_STARTY = 61;
        ScreenGlobals.OPTION_PANEL_ENDX = this.field_22789;
        ScreenGlobals.OPTION_PANEL_ENDY = this.field_22790 - 120;
        ScreenGlobals.OPTION_WIDTH = ScreenGlobals.OPTION_PANEL_STARTX - 30 - 22;
        for (OptionWidget widget : this.allOptionWidgets) {
            widget.method_25358(ScreenGlobals.OPTION_WIDTH);
            int size = ScreenGlobals.OPTION_HEIGHT;
            widget.onWidgetUpdate(widget.method_25368() - size + 15 + 22, widget.method_46427());
            if (widget instanceof OpenableWidget) {
                OpenableWidget openableWidget = (OpenableWidget)widget;
                if (openableWidget.open) {
                    openableWidget.method_53533(openableWidget.OPEN_HEIGHT);
                    continue;
                }
            }
            if (widget instanceof StringListOptionWidget) {
                StringListOptionWidget stringListOptionWidget = (StringListOptionWidget)widget;
                stringListOptionWidget.method_53533(ScreenGlobals.OPTION_HEIGHT + stringListOptionWidget.ADDITIONAL_HEIGHT);
                continue;
            }
            widget.method_53533(ScreenGlobals.OPTION_HEIGHT);
        }
    }

    @Override
    public void method_25393() {
        super.method_25393();
        for (OptionWidget widget : this.allOptionWidgets) {
            widget.tick();
        }
    }

    protected void method_57734() {
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
    }

    public void showWidgetsForCategory(Category category) {
        CategoryTab selected = (CategoryTab)this.tabManager.method_48614();
        if (selected == null || !selected.getCategory().name().equalsIgnoreCase(category.name())) {
            return;
        }
        this.tabWidget.updateVisibleWidgetsForTab(selected);
        this.scrollAnim.setTargetValue(0.0f);
    }

    private boolean isConfigEmpty() {
        return this.configManager.get().categories().isEmpty();
    }

    public void setFocusedOption(Option<?> option) {
        if (option != this.focusedOption) {
            this.focusedOption = option;
        }
    }

    public void search(String query) {
        this.allOptionWidgets.forEach(w -> w.updateSearchQuery(query));
        this.allGroupWidgets.forEach(w -> w.updateSearchQuery(query));
        for (OptionGroupWidget group : this.allGroupWidgets) {
            group.field_22764 = group.getChildren().stream().anyMatch(optionWidget -> optionWidget.getOption().searched());
            if (!group.searched(false)) continue;
            group.field_22764 = true;
            group.getGroup().setExpanded(true);
            group.getChildren().forEach(w -> w.updateSearchQuery(""));
        }
        String queryLower = query.toLowerCase();
        List<CategoryTab> filtered = this.allTabs.stream().filter(tab -> {
            boolean categoryMatches = tab.getCategory().name().toLowerCase().contains(queryLower);
            boolean optionMatches = tab.getCategory().optionGroups().stream().flatMap(group -> group.getOptions().stream()).anyMatch(Option::searched);
            return categoryMatches || optionMatches;
        }).toList();
        this.tabWidget.setTabs(filtered);
        if (this.tabWidget.tabSize() != this.allTabs.size()) {
            this.tabWidget.selectTab(0, true);
        }
        this.layoutGroupWidgets();
    }

    public void onChangesMade(Option<?> option) {
    }

    public void save(boolean runSave) {
        this.setOptionPrevs();
        this.configManager.get().save();
        if (runSave) {
            this.configManager.get().runSave();
        }
        this.defineOptions();
    }

    public void setOptionPrevs() {
        this.configManager.get().categories().forEach(category -> category.optionGroups().forEach(optionGroup -> optionGroup.getOptions().forEach(option -> option.setPrev(this.configManager.get()))));
    }

    private boolean shouldResetOptions() {
        for (Category category : this.configManager.get().categories()) {
            for (OptionGroup group : category.optionGroups()) {
                for (Option<?> option : group.getOptions()) {
                    if (!option.hasChanged()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean shouldUndoOptions() {
        for (Category category : this.configManager.get().categories()) {
            for (OptionGroup group : category.optionGroups()) {
                for (Option<?> option : group.getOptions()) {
                    if (option.screenInstanceCheck()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void undo() {
        this.configManager.get().categories().forEach(category -> category.optionGroups().forEach(optionGroup -> optionGroup.getOptions().forEach(Option::undo)));
        for (OptionWidget widget : this.allOptionWidgets) {
            widget.onThirdPartyChange(widget.getOption().screenInstanceValue);
            if (!(widget instanceof PixelGridAnimationWidget)) continue;
            PixelGridAnimationWidget widget1 = (PixelGridAnimationWidget)widget;
            widget1.reset();
        }
        this.setOptionPrevs();
    }

    public void resetOptions() {
        this.configManager.get().categories().forEach(category -> category.optionGroups().forEach(optionGroup -> optionGroup.getOptions().forEach(Option::reset)));
        for (OptionWidget widget : this.allOptionWidgets) {
            widget.onThirdPartyChange(widget.getOption().getDefaultValue());
            if (widget instanceof PixelGridAnimationWidget) {
                PixelGridAnimationWidget widget1 = (PixelGridAnimationWidget)widget;
                widget1.reset();
                continue;
            }
            if (widget instanceof StringListOptionWidget) {
                StringListOptionWidget widget1 = (StringListOptionWidget)widget;
                widget1.setHeight();
                continue;
            }
            if (!(widget instanceof SpriteOptionWidget)) continue;
            SpriteOptionWidget widget1 = (SpriteOptionWidget)widget;
            widget1.reCalc();
        }
        this.setOptionPrevs();
    }

    private void defineOptions() {
        for (Category category : this.configManager.get().categories()) {
            for (OptionGroup group : category.optionGroups()) {
                for (Option<?> option : group.getOptions()) {
                    option.setScreenInstance();
                }
            }
        }
    }

    public WalksyLibConfigManager getConfigManager() {
        return this.configManager;
    }
}

