/*
 * Decompiled with CFR 0.152.
 */
package main.walksy.lib.core.gui.popup;

import java.awt.Color;
import main.walksy.lib.core.gui.impl.WalksyLibConfigScreen;
import main.walksy.lib.core.renderer.Renderer2D;
import main.walksy.lib.core.utils.MainColors;
import net.minecraft.class_332;

public abstract class PopUp {
    protected final String subText;
    protected WalksyLibConfigScreen parent;
    private final int DEFAULT_WIDTH = 300;
    private final int DEFAULT_HEIGHT = 100;
    public boolean visible;
    public int x;
    public int y;
    public int width;
    public int height;
    protected boolean canClose = true;
    protected boolean loaded = false;

    public PopUp(WalksyLibConfigScreen parent, String subText) {
        this.parent = parent;
        this.subText = subText;
        this.visible = false;
        this.layout(300, 100);
        this.loaded = true;
    }

    public PopUp(WalksyLibConfigScreen parent, String subText, int width, int height) {
        this.parent = parent;
        this.subText = subText;
        this.layout(width, height);
        this.loaded = true;
    }

    public void render(class_332 context, double mouseX, double mouseY, float delta) {
        Renderer2D.fillRoundedRectOutline(context, this.parent.field_22789 / 2 - this.width / 2, this.parent.field_22790 / 2 - this.height / 2, this.width, this.height, 2, 1, MainColors.OUTLINE_BLACK.getRGB());
        Renderer2D.fillRoundedRectOutline(context, this.parent.field_22789 / 2 - this.width / 2 + 1, this.parent.field_22790 / 2 - this.height / 2 + 1, this.width - 2, this.height - 2, 2, 1, MainColors.OUTLINE_WHITE.getRGB());
        Renderer2D.fillRoundedRect(context, this.parent.field_22789 / 2 - this.width / 2 + 2, this.parent.field_22790 / 2 - this.height / 2 + 2, this.width - 4, this.height - 4, 2, Color.BLACK.getRGB());
    }

    public abstract void onClick(double var1, double var3, int var5);

    public void onScroll(double mouseX, double mouseY, double verticalAmount) {
    }

    public void onMouseRelease(double mouseX, double mouseY, int button) {
    }

    public void layout(int requestedWidth, int requestedHeight) {
        int maxWidth = (int)((double)this.parent.field_22789 * 0.98);
        int maxHeight = (int)((double)this.parent.field_22790 * 0.98);
        this.width = Math.min(requestedWidth, maxWidth);
        this.height = Math.min(requestedHeight, maxHeight);
        this.x = this.parent.field_22789 / 2 - this.width / 2;
        this.y = this.parent.field_22790 / 2 - this.height / 2;
    }

    public void close() {
        this.parent.popUp = null;
        this.onClose();
    }

    protected abstract void onClose();

    public boolean canClose() {
        return this.canClose;
    }

    public void setParentScreen(WalksyLibConfigScreen screen) {
        this.parent = screen;
    }
}

