/*
 * Decompiled with CFR 0.152.
 */
package main.walksy.lib.core.gui.popup.impl;

import java.awt.Color;
import java.awt.Point;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import main.walksy.lib.core.config.local.options.type.PixelGrid;
import main.walksy.lib.core.gui.impl.WalksyLibConfigScreen;
import main.walksy.lib.core.gui.popup.PopUp;
import main.walksy.lib.core.gui.widgets.ButtonWidget;
import main.walksy.lib.core.utils.Clipboard;
import main.walksy.lib.core.utils.MainColors;
import main.walksy.lib.core.utils.Scroller;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class GridEditorPopUp
extends PopUp {
    private final PixelGrid currentGrid;
    private final ButtonWidget undoButton;
    private final ButtonWidget undoAllButton;
    private final ButtonWidget doneButton;
    private final ButtonWidget clearButton;
    private final ButtonWidget copyButton;
    private final ButtonWidget pasteButton;
    private boolean isMouseDown = false;
    private boolean drawState = true;
    private final Set<Point> modifiedCells = new HashSet<Point>();
    private final Deque<UndoAction> undoStack = new LinkedList<UndoAction>();
    private final Map<Point, Boolean> fullBackup = new HashMap<Point, Boolean>();
    private final Scroller scroller;
    private final int index;

    public GridEditorPopUp(WalksyLibConfigScreen screen, PixelGrid grid, Consumer<PixelGrid> onDone, int currentIndex) {
        super(screen, "Grid Editor", 280, 320);
        this.currentGrid = grid.copy();
        this.index = currentIndex;
        this.scroller = new Scroller(0.0, 2.0);
        this.undoButton = new ButtonWidget(this.x + 5, this.y + this.height - 21, 40, 16, false, "Undo", null);
        this.undoAllButton = new ButtonWidget(this.x + 50, this.y + this.height - 21, 60, 16, false, "Undo All", null);
        this.doneButton = new ButtonWidget(this.x + this.width - 51, this.y + this.height - 21, 40, 16, false, "Done", () -> {
            if (onDone != null) {
                onDone.accept(this.currentGrid);
            }
            screen.popUp.close();
        });
        this.clearButton = new ButtonWidget(this.x + 115, this.y + this.height - 21, 40, 16, false, "Clear", () -> {
            for (int py = 0; py < this.currentGrid.getHeight(); ++py) {
                for (int px = 0; px < this.currentGrid.getWidth(); ++px) {
                    boolean previous = this.currentGrid.getPixel(px, py);
                    this.undoStack.push(new UndoAction(new Point(px, py), previous));
                    this.currentGrid.setPixel(px, py, false);
                }
            }
            this.modifiedCells.clear();
        });
        this.copyButton = new ButtonWidget(this.x + this.width - 44, this.y + 5, 18, 12, false, "C", () -> {
            Clipboard.grid = this.currentGrid.copy();
        });
        this.pasteButton = new ButtonWidget(this.x + this.width - 22, this.y + 5, 18, 12, false, "P", () -> {
            PixelGrid clipboard = Clipboard.grid;
            if (clipboard != null && clipboard.getWidth() == this.currentGrid.getWidth() && clipboard.getHeight() == this.currentGrid.getHeight()) {
                for (int py = 0; py < clipboard.getHeight(); ++py) {
                    for (int px = 0; px < clipboard.getWidth(); ++px) {
                        boolean newVal;
                        boolean previous = this.currentGrid.getPixel(px, py);
                        if (previous == (newVal = clipboard.getPixel(px, py))) continue;
                        this.undoStack.push(new UndoAction(new Point(px, py), previous));
                        this.currentGrid.setPixel(px, py, newVal);
                    }
                }
                this.modifiedCells.clear();
            }
        });
        for (int y = 0; y < grid.getHeight(); ++y) {
            for (int x = 0; x < grid.getWidth(); ++x) {
                this.fullBackup.put(new Point(x, y), grid.getPixel(x, y));
            }
        }
    }

    @Override
    public void render(class_332 context, double mouseX, double mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        context.method_25300(class_310.method_1551().field_1772, "Editing Frame: " + this.index, this.parent.field_22789 / 2, this.y + 8, -1);
        context.method_44379(this.x, this.y + 20, this.x + this.width, this.y + this.height - 25);
        if (this.renderGridOutline(context, this.currentGrid, this.x + 6, (int)((double)(this.y + 21) - this.scroller.getValue()), 16, 2, MainColors.OUTLINE_WHITE.getRGB(), true, mouseX, mouseY)) {
            this.scroller.active = false;
        }
        context.method_44380();
        this.handleDrag(mouseX, mouseY);
        context.method_25292(this.x + 2, this.x + this.width - 3, this.y + this.height - 25, MainColors.OUTLINE_WHITE.getRGB());
        this.doneButton.method_25394(context, (int)mouseX, (int)mouseY, delta);
        this.undoButton.method_25394(context, (int)mouseX, (int)mouseY, delta);
        this.undoAllButton.method_25394(context, (int)mouseX, (int)mouseY, delta);
        this.clearButton.method_25394(context, (int)mouseX, (int)mouseY, delta);
        this.copyButton.method_25394(context, (int)mouseX, (int)mouseY, delta);
        this.pasteButton.method_25394(context, (int)mouseX, (int)mouseY, delta);
        this.pasteButton.setEnabled(Clipboard.grid != null);
    }

    @Override
    public void onClick(double mouseX, double mouseY, int button) {
        if (this.copyButton.method_49606()) {
            this.copyButton.method_25348(mouseX, mouseY);
            return;
        }
        if (this.pasteButton.method_49606()) {
            this.pasteButton.method_25348(mouseX, mouseY);
            return;
        }
        if (this.undoButton.method_49606()) {
            if (!this.undoStack.isEmpty()) {
                UndoAction action = this.undoStack.pop();
                this.currentGrid.setPixel(action.point.x, action.point.y, action.previousState);
            }
            return;
        }
        if (this.undoAllButton.method_49606()) {
            for (Map.Entry<Point, Boolean> entry : this.fullBackup.entrySet()) {
                this.currentGrid.setPixel(entry.getKey().x, entry.getKey().y, entry.getValue());
            }
            this.undoStack.clear();
            return;
        }
        this.doneButton.method_25348(mouseX, mouseY);
        this.clearButton.method_25348(mouseX, mouseY);
        int pixelSize = 16;
        int gapSize = 2;
        for (int py = 0; py < this.currentGrid.getHeight(); ++py) {
            for (int px = 0; px < this.currentGrid.getWidth(); ++px) {
                int cellX = this.x + 6 + px * (pixelSize + gapSize);
                int cellY = (int)((double)(this.y + 21) - this.scroller.getValue() + (double)(py * (pixelSize + gapSize)));
                if (!(mouseX >= (double)cellX) || !(mouseX < (double)(cellX + pixelSize)) || !(mouseY >= (double)cellY) || !(mouseY < (double)(cellY + pixelSize)) || this.doneButton.method_49606() || this.clearButton.method_49606() || this.undoButton.method_49606() || this.undoAllButton.method_49606()) continue;
                boolean current = this.currentGrid.getPixel(px, py);
                this.drawState = !current;
                this.undoStack.push(new UndoAction(new Point(px, py), current));
                this.currentGrid.setPixel(px, py, this.drawState);
                this.modifiedCells.clear();
                this.modifiedCells.add(new Point(px, py));
                this.isMouseDown = true;
                return;
            }
        }
    }

    @Override
    public void onMouseRelease(double mouseX, double mouseY, int button) {
        this.isMouseDown = false;
        this.modifiedCells.clear();
    }

    @Override
    public void onScroll(double mouseX, double mouseY, double verticalAmount) {
        super.onScroll(mouseX, mouseY, verticalAmount);
        this.scroller.onScroll(verticalAmount);
        this.scroller.setBounds(0.0, 74.0);
    }

    @Override
    public boolean canClose() {
        return false;
    }

    @Override
    protected void onClose() {
    }

    @Override
    public void layout(int width, int height) {
        super.layout(width, height);
        if (this.loaded) {
            this.undoButton.method_48229(this.x + 5, this.y + height - 21);
            this.undoAllButton.method_48229(this.x + 50, this.y + height - 21);
            this.doneButton.method_48229(this.x + width - 51, this.y + height - 21);
            this.clearButton.method_48229(this.x + 115, this.y + height - 21);
            this.copyButton.method_48229(this.x + width - 44, this.y + 5);
            this.pasteButton.method_48229(this.x + width - 22, this.y + 5);
        }
    }

    private void handleDrag(double mouseX, double mouseY) {
        if (!this.isMouseDown) {
            return;
        }
        int pixelSize = 16;
        int gapSize = 2;
        for (int py = 0; py < this.currentGrid.getHeight(); ++py) {
            for (int px = 0; px < this.currentGrid.getWidth(); ++px) {
                int cellX = this.x + 6 + px * (pixelSize + gapSize);
                int cellY = (int)((double)(this.y + 21) - this.scroller.getValue() + (double)(py * (pixelSize + gapSize)));
                if (!(mouseX >= (double)cellX) || !(mouseX < (double)(cellX + pixelSize)) || !(mouseY >= (double)cellY) || !(mouseY < (double)(cellY + pixelSize))) continue;
                Point point = new Point(px, py);
                if (this.modifiedCells.contains(point)) {
                    return;
                }
                boolean previous = this.currentGrid.getPixel(px, py);
                this.currentGrid.setPixel(px, py, this.drawState);
                this.undoStack.push(new UndoAction(point, previous));
                this.modifiedCells.add(point);
                return;
            }
        }
    }

    private boolean renderGridOutline(class_332 context, PixelGrid grid, int x1, int y1, int pixelSize, int gapSize, int outlineColor, boolean markCenter, double mouseX, double mouseY) {
        int py;
        int px;
        boolean rtrn = true;
        if (markCenter) {
            int centerX = grid.getWidth() / 2;
            int centerY = grid.getHeight() / 2;
            px = x1 + centerX * (pixelSize + gapSize);
            py = y1 + centerY * (pixelSize + gapSize);
            int centerColor = new Color(255, 100, 100, 100).getRGB();
            context.method_25294(px + 1, py + 1, px + pixelSize - 1, py + pixelSize - 1, centerColor);
        }
        for (int y = 0; y < grid.getHeight(); ++y) {
            for (int x = 0; x < grid.getWidth(); ++x) {
                boolean on;
                px = x1 + x * (pixelSize + gapSize);
                py = y1 + y * (pixelSize + gapSize);
                if (!context.method_58135(px, py)) {
                    rtrn = false;
                }
                int fillColor = (on = grid.getPixel(x, y)) ? Color.WHITE.getRGB() : new Color(0, 0, 0, 0).getRGB();
                context.method_25294(px + 1, py + 1, px + pixelSize - 1, py + pixelSize - 1, fillColor);
                boolean hovered = mouseX >= (double)px && mouseX < (double)(px + pixelSize) && mouseY >= (double)py && mouseY < (double)(py + pixelSize);
                int actualOutlineColor = hovered ? MainColors.OUTLINE_WHITE_HOVERED.getRGB() : outlineColor;
                context.method_25294(px + 1, py, px + pixelSize - 1, py + 1, actualOutlineColor);
                context.method_25294(px + 1, py + pixelSize - 1, px + pixelSize - 1, py + pixelSize, actualOutlineColor);
                context.method_25294(px, py, px + 1, py + pixelSize, actualOutlineColor);
                context.method_25294(px + pixelSize - 1, py, px + pixelSize, py + pixelSize, actualOutlineColor);
            }
        }
        return rtrn;
    }

    private record UndoAction(Point point, boolean previousState) {
    }
}

