/*
 * Decompiled with CFR 0.152.
 */
package main.walksy.lib.core.gui.popup.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.function.Consumer;
import main.walksy.lib.core.callback.WindowDropCallback;
import main.walksy.lib.core.gui.impl.WalksyLibConfigScreen;
import main.walksy.lib.core.gui.popup.PopUp;
import main.walksy.lib.core.gui.widgets.ButtonWidget;
import main.walksy.lib.core.manager.WalksyLibConfigManager;
import main.walksy.lib.core.utils.MainColors;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class TextureDropPopUp
extends PopUp {
    private final ButtonWidget doneButton;
    private class_2960 selectedTexture;
    private String fileName;

    public TextureDropPopUp(WalksyLibConfigScreen parent, String subText, Consumer<Pass> onDone) {
        super(parent, subText, 280, 320);
        this.doneButton = new ButtonWidget(this.x + this.width - 51, this.y + this.height - 21, 40, 16, false, "Done", () -> {
            if (this.selectedTexture != null && onDone != null) {
                onDone.accept(new Pass(this.selectedTexture, this.fileName));
            }
            parent.popUp.close();
        });
        WindowDropCallback.register(class_310.method_1551().method_22683().method_4490(), this::onFileDropped);
    }

    @Override
    public void render(class_332 context, double mouseX, double mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        context.method_25300(this.parent.method_64506(), this.subText, this.x + this.width / 2, this.y + 10, -1);
        context.method_25292(this.x + 2, this.x + this.width - 3, this.y + 23, MainColors.OUTLINE_WHITE.getRGB());
        if (this.selectedTexture != null) {
            class_1011 image;
            class_1060 textureManager = class_310.method_1551().method_1531();
            class_1043 nativeTexture = (class_1043)textureManager.method_4619(this.selectedTexture);
            if (nativeTexture != null && (image = nativeTexture.method_4525()) != null) {
                int imgW = image.method_4307();
                int imgH = image.method_4323();
                int maxWidth = this.width - 40;
                int maxHeight = this.height - 100;
                float scale = Math.min((float)maxWidth / (float)imgW, (float)maxHeight / (float)imgH);
                int scaledWidth = Math.round((float)imgW * scale);
                int scaledHeight = Math.round((float)imgH * scale);
                int drawX = this.x + this.width / 2 - scaledWidth / 2;
                int drawY = this.y + this.height / 2 - scaledHeight / 2;
                context.method_25290(class_1921::method_62277, this.selectedTexture, drawX, drawY, 0.0f, 0.0f, scaledWidth, scaledHeight, scaledWidth, scaledHeight);
            }
        } else {
            context.method_25300(this.parent.method_64506(), "Drop a .png image file", this.x + this.width / 2, this.y + this.height / 2, 0xAAAAAA);
        }
        this.doneButton.method_25394(context, (int)mouseX, (int)mouseY, delta);
    }

    @Override
    public void onClick(double mouseX, double mouseY, int button) {
        this.doneButton.method_25348(mouseX, mouseY);
    }

    private void onFileDropped(String filePath) {
        String name;
        File file = new File(filePath);
        if (!file.exists() || !file.isFile()) {
            return;
        }
        String trueName = name = file.getName();
        if (!name.toLowerCase().endsWith(".png")) {
            return;
        }
        try {
            int dotIndex = name.lastIndexOf(46);
            if (dotIndex > 0) {
                name = name.substring(0, dotIndex);
            }
            name = name.toLowerCase().replaceAll("[^a-z0-9._-]", "_");
            try (FileInputStream stream = new FileInputStream(file);){
                class_1011 image = class_1011.method_4309((InputStream)stream);
                class_1043 texture = new class_1043(image);
                String dynamicId = "dropped/" + name;
                class_2960 textureId = class_2960.method_60655((String)"walksylib", (String)dynamicId);
                class_310.method_1551().method_1531().method_4616(textureId, (class_1044)texture);
                Path destDir = WalksyLibConfigManager.getCachedImageDir();
                Path destPath = destDir.resolve(trueName);
                Files.copy(file.toPath(), destPath, StandardCopyOption.REPLACE_EXISTING);
                this.selectedTexture = textureId;
                this.fileName = trueName;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void layout(int requestedWidth, int requestedHeight) {
        super.layout(requestedWidth, requestedHeight);
        if (this.doneButton != null) {
            this.doneButton.method_48229(this.x + this.width - 51, this.y + this.height - 21);
        }
    }

    @Override
    protected void onClose() {
        WindowDropCallback.unregister(class_310.method_1551().method_22683().method_4490());
    }

    public record Pass(class_2960 identifier, String fileName) {
    }
}

