/*
 * Decompiled with CFR 0.152.
 */
package main.walksy.lib.core.gui.widgets;

import java.awt.Color;
import main.walksy.lib.core.config.local.Option;
import main.walksy.lib.core.config.local.options.BooleanOption;
import main.walksy.lib.core.config.local.options.groups.OptionGroup;
import main.walksy.lib.core.gui.impl.WalksyLibConfigScreen;
import main.walksy.lib.core.gui.popup.impl.WarningPopUp;
import main.walksy.lib.core.gui.widgets.OptionWidget;
import main.walksy.lib.core.renderer.Renderer2D;
import main.walksy.lib.core.utils.Animation;
import main.walksy.lib.core.utils.MainColors;
import main.walksy.lib.core.utils.ScreenGlobals;
import net.minecraft.class_1144;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;

public class BooleanWidget
extends OptionWidget {
    private final Option<Boolean> option;
    private final WarningPopUp warningPopUp;
    private final Animation toggleAnim;
    private int onX;
    private int offX;

    public BooleanWidget(OptionGroup parent, WalksyLibConfigScreen screen, int x, int y, int width, int height, Option<Boolean> option, BooleanOption.Warning warning) {
        super(parent, screen, option, x, y, width, height, option.getName());
        this.option = option;
        this.onX = width - 6;
        this.offX = width - 15;
        float initialPos = option.getValue() != false ? (float)this.onX : (float)this.offX;
        this.toggleAnim = new Animation(initialPos, 0.5f);
        this.warningPopUp = warning != null ? new WarningPopUp(screen, warning.title, warning.message, () -> {
            option.setValue((Boolean)option.getValue() == false);
            this.onChange();
            if (warning.onYes != null) {
                warning.onYes.run();
            }
            this.screen.popUp.close();
        }, () -> {
            if (warning.onNo != null) {
                warning.onNo.run();
            }
            this.screen.popUp.close();
        }) : null;
    }

    @Override
    public void draw(class_332 context, int mouseX, int mouseY, float delta) {
        if (ScreenGlobals.DEBUG) {
            this.renderDebug(context);
        }
        Renderer2D.fillRoundedRect(context, this.method_25368() - 16, this.method_46427() + 3, 25.0f, this.method_25364() - 6, 2, new Color(255, 255, 255, 20).getRGB());
        Renderer2D.fillRoundedRectOutline(context, this.method_25368() - 16, this.method_46427() + 3, 25, this.method_25364() - 6, 2, 1, MainColors.OUTLINE_BLACK.getRGB());
        this.toggleAnim.update(delta);
        int color = this.option.getValue() != false ? Color.WHITE.getRGB() : MainColors.OUTLINE_WHITE.getRGB();
        float animX = this.toggleAnim.getCurrentValue();
        Renderer2D.fillRoundedRect(context, animX, this.method_46427() + 4, 14.0f, this.method_25364() - 8, 2, color);
    }

    @Override
    public void onMouseClick(double mouseX, double mouseY, int button) {
        if (this.method_49606() && button == 0) {
            class_339.method_62888((class_1144)class_310.method_1551().method_1483());
            if (this.warningPopUp != null && !this.warningPopUp.visible && !this.option.getValue().booleanValue()) {
                this.screen.popUp = this.warningPopUp;
                return;
            }
            this.option.setValue(this.option.getValue() == false);
            this.onChange();
        }
    }

    @Override
    public void onWidgetUpdate() {
        this.onX = this.field_22758 - 6;
        this.offX = this.field_22758 - 15;
        float initialPos = this.option.getValue() != false ? (float)this.onX : (float)this.offX;
        this.toggleAnim.jumpTo(initialPos);
    }

    @Override
    public void method_25354(class_1144 soundManager) {
    }

    private void renderDebug(class_332 context) {
        context.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.method_25368(), this.method_46427() + this.method_25364(), new Color(255, 255, 255, 150).getRGB());
    }

    @Override
    public void onChange() {
        super.onChange();
        this.toggleAnim.setTargetValue(this.option.getValue() != false ? (float)this.onX : (float)this.offX);
    }

    @Override
    public <V> void onThirdPartyChange(V value) {
        super.onThirdPartyChange(value);
        this.toggleAnim.setTargetValue(this.option.getValue() != false ? (float)this.onX : (float)this.offX);
    }
}

