/*
 * Decompiled with CFR 0.152.
 */
package main.walksy.lib.core.gui.widgets;

import java.awt.Color;
import java.awt.Point;
import main.walksy.lib.core.config.local.Option;
import main.walksy.lib.core.config.local.options.groups.OptionGroup;
import main.walksy.lib.core.config.local.options.type.WalksyLibColor;
import main.walksy.lib.core.gui.impl.WalksyLibConfigScreen;
import main.walksy.lib.core.gui.widgets.ButtonWidget;
import main.walksy.lib.core.gui.widgets.OpenableWidget;
import main.walksy.lib.core.gui.widgets.sub.SliderSubWidget;
import main.walksy.lib.core.gui.widgets.sub.adaptor.IntSliderAdapter;
import main.walksy.lib.core.renderer.Renderer2D;
import main.walksy.lib.core.utils.Animation;
import main.walksy.lib.core.utils.MainColors;
import main.walksy.lib.core.utils.ScreenGlobals;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;

public class ColorWidget
extends OpenableWidget {
    private final Option<WalksyLibColor> option;
    public int COLOR_PICKER_STARTX;
    private final class_2960 TRANSPARENT_BACKGROUND = class_2960.method_60655((String)"walksylib", (String)"gui/widget/transparent.png");
    private final class_2960 RAINBOW_ICON = class_2960.method_60655((String)"walksylib", (String)"gui/widget/rainbow.png");
    private final class_2960 PULSE_ICON = class_2960.method_60655((String)"walksylib", (String)"gui/widget/pulse.png");
    private final ButtonWidget chromaButton;
    private final ButtonWidget pulseButton;
    private final SliderSubWidget<Integer> chromaSpeedSlider;
    private final SliderSubWidget<Integer> pulseSpeedSlider;
    private final Animation satThumbXAnim = new Animation(0.0f, 0.5f);
    private final Animation satThumbYAnim = new Animation(0.0f, 0.5f);
    private final Animation hueThumbYAnim = new Animation(0.0f, 0.5f);
    private final Animation opacityThumbYAnim = new Animation(0.0f, 0.5f);
    private DragTarget activeDrag = DragTarget.NONE;

    public ColorWidget(OptionGroup parent, WalksyLibConfigScreen screen, int x, int y, int width, int height, Option<WalksyLibColor> option) {
        super(parent, screen, option, x, y, width, height, option.getName(), ScreenGlobals.OPTION_HEIGHT * 5);
        this.option = option;
        WalksyLibColor initial = option.getValue();
        float[] hsb = WalksyLibColor.RGBtoHSB(initial.getRed(), initial.getGreen(), initial.getBlue(), null);
        option.getValue().setHue(hsb[0]);
        option.getValue().setSaturation(hsb[1]);
        option.getValue().setBrightness(hsb[2]);
        option.getValue().setAlpha(initial.getAlpha());
        this.COLOR_PICKER_STARTX = (this.method_46426() + this.method_25368()) / 2;
        this.chromaButton = new ButtonWidget(x + 5, y + 19 + 10, 17, 17, false, this.RAINBOW_ICON, () -> this.option.getValue().setRainbow(!this.option.getValue().isRainbow()), -3, -3);
        this.pulseButton = new ButtonWidget(x + 5, y + 45 + 10, 17, 17, false, this.PULSE_ICON, () -> this.option.getValue().setPulse(!this.option.getValue().isPulse()), -3, -3);
        this.chromaSpeedSlider = new SliderSubWidget<Integer>(x + 28, y + 23 + 10, this.COLOR_PICKER_STARTX - 32 - 60, ScreenGlobals.OPTION_HEIGHT - 12, new IntSliderAdapter(1, 20, this.option.getValue().getRainbowSpeed()), this.option.getValue().getRainbowSpeed(), rainbowSpeed -> {
            this.option.getValue().setRainbowSpeed((int)rainbowSpeed);
            this.updateThumbTargets(false);
        }, true);
        this.pulseSpeedSlider = new SliderSubWidget<Integer>(x + 28, y + 49 + 10, this.COLOR_PICKER_STARTX - 32 - 60, ScreenGlobals.OPTION_HEIGHT - 12, new IntSliderAdapter(1, 20, this.option.getValue().getPulseSpeed()), this.option.getValue().getPulseSpeed(), pulseSpeed -> {
            this.option.getValue().setPulseSpeed((int)pulseSpeed);
            this.updateThumbTargets(false);
        }, true);
    }

    @Override
    public void draw(class_332 context, int mouseX, int mouseY, float delta) {
        super.draw(context, mouseX, mouseY, delta);
        this.pulseSpeedSlider.setOnChange(this.option.getValue()::setPulseSpeed);
        this.chromaSpeedSlider.setOnChange(this.option.getValue()::setRainbowSpeed);
        this.COLOR_PICKER_STARTX = (this.method_46426() + this.method_25368()) / 2;
        int baseHeight = ScreenGlobals.OPTION_HEIGHT;
        this.satThumbXAnim.update(delta);
        this.satThumbYAnim.update(delta);
        this.hueThumbYAnim.update(delta);
        this.opacityThumbYAnim.update(delta);
        Renderer2D.drawRoundedTexture(context, class_1921::method_62277, this.TRANSPARENT_BACKGROUND, this.method_25368() - 15, this.method_46427() + 4, 23, baseHeight - 8, 2, 4, 4);
        Renderer2D.fillRoundedRectOutline(context, this.method_25368() - 16, this.method_46427() + 3, 25, baseHeight - 6, 2, 1, MainColors.OUTLINE_BLACK.getRGB());
        Renderer2D.fillRoundedRect(context, this.method_25368() - 15, this.method_46427() + 4, 23.0f, baseHeight - 8, 2, this.option.getValue().getRGB());
        context.method_25303(class_310.method_1551().field_1772, String.format("#%02X%02X%02X%02X", this.option.getValue().getRed(), this.option.getValue().getGreen(), this.option.getValue().getBlue(), this.option.getValue().getAlpha()), this.method_46426() + this.method_25368() - 98, this.getTextYCentered() + 1, Color.LIGHT_GRAY.getRGB());
        if (this.fullyClosed()) {
            context.method_25301(this.method_46426() + this.method_25368() - 38, this.method_46427(), this.method_46427() + ScreenGlobals.OPTION_HEIGHT - 1, this.method_49606() ? MainColors.OUTLINE_WHITE_HOVERED.getRGB() : MainColors.OUTLINE_WHITE.getRGB());
        } else if (this.getCurrentHeight() > 34.0f) {
            this.drawHueSlider(context);
            this.drawSaturationBox(context);
            this.drawOpacitySlider(context);
            this.chromaButton.overrideHover = this.option.getValue().isRainbow();
            this.pulseButton.overrideHover = this.option.getValue().isPulse();
            this.chromaButton.method_25394(context, mouseX, mouseY, delta);
            this.pulseButton.method_25394(context, mouseX, mouseY, delta);
            this.chromaSpeedSlider.render(context, mouseX, mouseY, delta);
            this.pulseSpeedSlider.render(context, mouseX, mouseY, delta);
            context.method_25303(class_310.method_1551().field_1772, "Rainbow Speed", this.method_46426() + 32, this.method_46427() + 23, Color.LIGHT_GRAY.getRGB());
            context.method_25303(class_310.method_1551().field_1772, "Pulse Speed", this.method_46426() + 32, this.method_46427() + 49, Color.LIGHT_GRAY.getRGB());
        }
    }

    public void drawSatThumb(class_332 context, int x, int y) {
        Renderer2D.fillRoundedRectOutline(context, x, y, 6, 6, 1, 1, Color.BLACK.getRGB());
        Renderer2D.fillRoundedRectOutline(context, x + 1, y + 1, 4, 4, 1, 1, MainColors.OUTLINE_WHITE.getRGB());
    }

    public void drawSliderThumb(class_332 context, int x, int y) {
        Renderer2D.fillRoundedRectOutline(context, x, y, 9, 3, 1, 1, Color.BLACK.getRGB());
    }

    public void drawOpacitySlider(class_332 context) {
        int opacityHeight = this.method_25364() - 30 + 8;
        Renderer2D.fillRoundedRectOutline(context, this.COLOR_PICKER_STARTX - 34, this.method_46427() + 19, 15, opacityHeight, 2, 1, MainColors.OUTLINE_BLACK.getRGB());
        Renderer2D.fillRoundedRectOutline(context, this.COLOR_PICKER_STARTX - 33, this.method_46427() + 20, 13, opacityHeight - 2, 2, 1, this.isHoveringOpacitySlider(this.mouseX, this.mouseY) ? MainColors.OUTLINE_WHITE_HOVERED.getRGB() : MainColors.OUTLINE_WHITE.getRGB());
        Renderer2D.drawRoundedTexture(context, class_1921::method_62277, this.TRANSPARENT_BACKGROUND, this.COLOR_PICKER_STARTX - 32, this.method_46427() + 21, 11, opacityHeight - 4, 2, 4, 4);
        WalksyLibColor color = new WalksyLibColor(this.option.getValue().getRed(), this.option.getValue().getGreen(), this.option.getValue().getBlue(), 255);
        WalksyLibColor colorG = new WalksyLibColor(this.option.getValue().getRed(), this.option.getValue().getGreen(), this.option.getValue().getBlue(), 0);
        Renderer2D.fillRoundedRectGradient(context, this.COLOR_PICKER_STARTX - 32, this.method_46427() + 21, 11, opacityHeight - 4, 2, color.getRGB(), colorG.getRGB());
        int opacitySliderX = this.COLOR_PICKER_STARTX - 34;
        this.drawSliderThumb(context, opacitySliderX + 3, (int)this.opacityThumbYAnim.getCurrentValue() + 1);
    }

    public void drawHueSlider(class_332 context) {
        int hueHeight = this.method_25364() - 30 + 8;
        Renderer2D.fillRoundedRectOutline(context, this.COLOR_PICKER_STARTX - 17, this.method_46427() + 19, 15, hueHeight, 2, 1, MainColors.OUTLINE_BLACK.getRGB());
        Renderer2D.fillRoundedRectOutline(context, this.COLOR_PICKER_STARTX - 16, this.method_46427() + 20, 13, hueHeight - 2, 2, 1, this.isHoveringHueSlider(this.mouseX, this.mouseY) ? MainColors.OUTLINE_WHITE_HOVERED.getRGB() : MainColors.OUTLINE_WHITE.getRGB());
        Renderer2D.drawRoundedHueSlider(context, this.COLOR_PICKER_STARTX - 15, this.method_46427() + 21, 11, hueHeight - 4, 2);
        int hueSliderX = this.COLOR_PICKER_STARTX - 17;
        this.drawSliderThumb(context, hueSliderX + 3, (int)this.hueThumbYAnim.getCurrentValue() + 1);
    }

    public void drawSaturationBox(class_332 context) {
        Renderer2D.fillRoundedRectOutline(context, this.COLOR_PICKER_STARTX, this.method_46427() + 19, this.method_25368() - this.COLOR_PICKER_STARTX + 9, this.method_25364() - 28 + 6, 2, 1, MainColors.OUTLINE_BLACK.getRGB());
        Renderer2D.fillRoundedRectOutline(context, this.COLOR_PICKER_STARTX + 1, this.method_46427() + 20, this.method_25368() - this.COLOR_PICKER_STARTX + 7, this.method_25364() - 28 + 6 - 2, 2, 1, this.isHoveringSaturationValueBox(this.mouseX, this.mouseY) ? MainColors.OUTLINE_WHITE_HOVERED.getRGB() : MainColors.OUTLINE_WHITE.getRGB());
        Renderer2D.drawHueSaturationValueBox(context, this.COLOR_PICKER_STARTX + 2, this.method_46427() + 21, this.method_25368() - this.COLOR_PICKER_STARTX + 5, this.method_25364() - 28 + 6 - 4, 2, this.option.getValue().getHue());
        this.drawSatThumb(context, (int)this.satThumbXAnim.getCurrentValue() + 1, (int)this.satThumbYAnim.getCurrentValue());
    }

    public boolean isHoveringHueSlider(double mouseX, double mouseY) {
        int x = this.COLOR_PICKER_STARTX - 17;
        int y = this.method_46427() + 19;
        int width = 15;
        int height = this.method_25364() - 30 + 8;
        return mouseX >= (double)x && mouseX < (double)(x + width) && mouseY >= (double)y && mouseY < (double)(y + height);
    }

    public boolean isHoveringSaturationValueBox(double mouseX, double mouseY) {
        int x = this.COLOR_PICKER_STARTX;
        int y = this.method_46427() + 19;
        int width = this.method_25368() - this.COLOR_PICKER_STARTX + 9;
        int height = this.method_25364() - 28 + 6;
        return mouseX >= (double)x && mouseX < (double)(x + width) && mouseY >= (double)y && mouseY < (double)(y + height);
    }

    public boolean isHoveringOpacitySlider(double mouseX, double mouseY) {
        int x = this.COLOR_PICKER_STARTX - 34;
        int y = this.method_46427() + 19;
        int width = 15;
        int height = this.method_25364() - 30 + 8;
        return mouseX >= (double)x && mouseX < (double)(x + width) && mouseY >= (double)y && mouseY < (double)(y + height);
    }

    public boolean isHoveringRainbowButton(double mouseX, double mouseY) {
        int x = this.COLOR_PICKER_STARTX - 54;
        int y = this.method_46427() + 19;
        int width = 18;
        int height = this.method_25364() - 85 + 3;
        return mouseX >= (double)x && mouseX < (double)(x + width) && mouseY >= (double)y && mouseY < (double)(y + height);
    }

    @Override
    public void onMouseClick(double mouseX, double mouseY, int button) {
        super.onMouseClick(mouseX, mouseY, button);
        this.chromaSpeedSlider.onClick((int)mouseX, (int)mouseY, button);
        this.pulseSpeedSlider.onClick((int)mouseX, (int)mouseY, button);
        this.chromaButton.method_25348(mouseX, mouseY);
        this.pulseButton.method_25348(mouseX, mouseY);
        if (button != 0) {
            return;
        }
        if (this.open) {
            if (this.isHoveringHueSlider(mouseX, mouseY)) {
                this.activeDrag = DragTarget.HUE_SLIDER;
                this.handleHueSliderClick(mouseY);
                this.onChange();
                return;
            }
            if (this.isHoveringSaturationValueBox(mouseX, mouseY)) {
                this.activeDrag = DragTarget.SATURATION_VALUE_BOX;
                this.handleSatValBoxClick(mouseX, mouseY);
                this.onChange();
                return;
            }
            if (this.isHoveringOpacitySlider(mouseX, mouseY)) {
                this.activeDrag = DragTarget.OPACITY_SLIDER;
                this.handleOpacitySliderClick(mouseY);
                this.onChange();
                return;
            }
        }
    }

    @Override
    protected void onOpen(boolean prev) {
    }

    @Override
    public boolean method_49606() {
        return this.mouseX >= this.method_46426() && this.mouseX < this.method_46426() + this.method_25368() - 6 && this.mouseY >= this.method_46427() && this.mouseY < this.method_46427() + ScreenGlobals.OPTION_HEIGHT && this.isVisible() && this.isAvailable();
    }

    @Override
    public void onMouseRelease(double mouseX, double mouseY, int button) {
        if (button != 0) {
            return;
        }
        this.activeDrag = DragTarget.NONE;
    }

    @Override
    public void onMouseDrag(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        this.chromaSpeedSlider.onDrag((int)mouseX);
        this.pulseSpeedSlider.onDrag((int)mouseX);
        if (button != 0) {
            return;
        }
        switch (this.activeDrag.ordinal()) {
            case 1: {
                this.handleHueSliderDrag(mouseY);
                break;
            }
            case 2: {
                this.handleSatValBoxDrag(mouseX, mouseY);
                break;
            }
            case 3: {
                this.handleOpacitySliderDrag(mouseY);
                break;
            }
        }
        this.onChange();
    }

    @Override
    public void onChange() {
        super.onChange();
        this.updateThumbTargets(false);
    }

    public void method_25357(double mouseX, double mouseY) {
        this.chromaSpeedSlider.release();
        this.pulseSpeedSlider.release();
    }

    @Override
    public void onWidgetUpdate() {
        this.chromaSpeedSlider.setPos(new Point(this.method_46426() + 28, this.method_46427() + 23 + 10));
        this.pulseSpeedSlider.setPos(new Point(this.method_46426() + 28, this.method_46427() + 49 + 10));
        this.chromaButton.method_46421(this.method_46426() + 5);
        this.chromaButton.method_46419(this.method_46427() + 29);
        this.pulseButton.method_46421(this.method_46426() + 5);
        this.pulseButton.method_46419(this.method_46427() + 55);
        int width = (this.method_46426() + this.method_25368()) / 2 - 32 - 60;
        this.chromaSpeedSlider.setWidth(width);
        this.pulseSpeedSlider.setWidth(width);
        this.updateThumbTargets(true);
    }

    @Override
    public <V> void onThirdPartyChange(V value) {
        super.onThirdPartyChange(value);
        this.pulseSpeedSlider.setValue(this.option.getValue().getPulseSpeed());
        this.chromaSpeedSlider.setValue(this.option.getValue().getRainbowSpeed());
    }

    private void updateThumbTargets(boolean jump) {
        int hueSliderY = this.method_46427() + 21;
        int hueSliderHeight = this.method_25364() - 30 + 8 - 4;
        int rawHueThumbY = hueSliderY + (int)((1.0f - this.option.getValue().getHue()) * (float)hueSliderHeight) - 2;
        int targetHueY = Math.max(hueSliderY - 1, Math.min(rawHueThumbY - 1, hueSliderY + hueSliderHeight - 2));
        int opacitySliderY = this.method_46427() + 21;
        int opacitySliderHeight = this.method_25364() - 30 + 8 - 4;
        int rawOpacityThumbY = opacitySliderY + (int)((1.0f - (float)this.option.getValue().getAlpha() / 255.0f) * (float)opacitySliderHeight) - 2;
        int targetOpacityY = Math.max(opacitySliderY - 1, Math.min(rawOpacityThumbY - 1, opacitySliderY + opacitySliderHeight - 2));
        int boxX = this.COLOR_PICKER_STARTX;
        int boxY = this.method_46427() + 21;
        int boxWidth = this.method_25368() - this.COLOR_PICKER_STARTX + 9;
        int boxHeight = this.method_25364() - 28 + 6 - 4;
        int rawThumbX = boxX + (int)(this.option.getValue().getSaturation() * (float)boxWidth) + 3;
        int rawThumbY = boxY + (int)((1.0f - this.option.getValue().getBrightness()) * (float)boxHeight) + 1;
        if (jump) {
            this.hueThumbYAnim.jumpTo(targetHueY);
            this.satThumbXAnim.jumpTo(Math.max(boxX + 1, Math.min(rawThumbX - 6, boxX + boxWidth - 8)));
            this.satThumbYAnim.jumpTo(Math.max(boxY, Math.min(rawThumbY - 4, boxY + boxHeight - 6)));
            this.opacityThumbYAnim.jumpTo(targetOpacityY);
        } else {
            this.hueThumbYAnim.setTargetValue(targetHueY);
            this.satThumbXAnim.setTargetValue(Math.max(boxX + 1, Math.min(rawThumbX - 6, boxX + boxWidth - 8)));
            this.satThumbYAnim.setTargetValue(Math.max(boxY, Math.min(rawThumbY - 4, boxY + boxHeight - 6)));
            this.opacityThumbYAnim.setTargetValue(targetOpacityY);
        }
    }

    private void handleHueSliderClick(double mouseY) {
        float newHue = 1.0f - (float)((mouseY - (double)(this.method_46427() + 20)) / (double)(this.method_25364() - 30 + 6));
        this.option.getValue().setHue(class_3532.method_15363((float)newHue, (float)0.0f, (float)1.0f));
        this.updateColor();
    }

    private void handleHueSliderDrag(double mouseY) {
        this.handleHueSliderClick(mouseY);
    }

    private void handleSatValBoxClick(double mouseX, double mouseY) {
        int boxX = this.COLOR_PICKER_STARTX;
        int boxY = this.method_46427() + 20;
        int boxWidth = this.method_25368() - this.COLOR_PICKER_STARTX + 9;
        int boxHeight = this.method_25364() - 29 + 6;
        float newSaturation = (float)((mouseX - (double)boxX) / (double)boxWidth);
        float newBrightness = 1.0f - (float)((mouseY - (double)boxY) / (double)boxHeight);
        if (mouseX < (double)boxX) {
            this.option.getValue().setSaturation(0.0f);
        } else if (mouseX > (double)(boxX + boxWidth)) {
            this.option.getValue().setSaturation(1.0f);
        } else {
            this.option.getValue().setSaturation(class_3532.method_15363((float)newSaturation, (float)0.0f, (float)1.0f));
        }
        if (mouseY < (double)boxY) {
            this.option.getValue().setBrightness(1.0f);
        } else if (mouseY > (double)(boxY + boxHeight)) {
            this.option.getValue().setBrightness(0.0f);
        } else {
            this.option.getValue().setBrightness(class_3532.method_15363((float)newBrightness, (float)0.0f, (float)1.0f));
        }
        this.updateColor();
    }

    private void handleSatValBoxDrag(double mouseX, double mouseY) {
        this.handleSatValBoxClick(mouseX, mouseY);
    }

    private void handleOpacitySliderClick(double mouseY) {
        int sliderY = this.method_46427() + 20;
        int sliderHeight = this.method_25364() - 30 + 6;
        float newOpacity = 1.0f - (float)((mouseY - (double)sliderY) / (double)sliderHeight);
        this.option.getValue().setAlpha((int)(class_3532.method_15363((float)newOpacity, (float)0.0f, (float)1.0f) * 255.0f));
        this.updateColor();
    }

    private void handleOpacitySliderDrag(double mouseY) {
        this.handleOpacitySliderClick(mouseY);
    }

    private void updateColor() {
        int rgb = WalksyLibColor.HSBtoRGB(this.option.getValue().getHue(), this.option.getValue().getSaturation(), this.option.getValue().getBrightness());
        WalksyLibColor updated = new WalksyLibColor(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, this.option.getValue().getAlpha());
        updated.setAdditions(this.option.getValue().getAdditions());
        this.option.setValue(updated);
    }

    private static enum DragTarget {
        NONE,
        HUE_SLIDER,
        SATURATION_VALUE_BOX,
        OPACITY_SLIDER;

    }
}

