/*
 * Decompiled with CFR 0.152.
 */
package main.walksy.lib.core.gui.widgets;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import main.walksy.lib.core.gui.widgets.AbstractWidget;
import main.walksy.lib.core.renderer.Renderer2D;
import main.walksy.lib.core.utils.MainColors;
import main.walksy.lib.core.utils.MarqueeUtil;
import main.walksy.lib.core.utils.Scroller;
import main.walksy.lib.core.utils.log.InternalLog;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_6382;

public class LogWidget
extends AbstractWidget {
    private final class_437 parent;
    private final List<InternalLog> logLines = new ArrayList<InternalLog>();
    private final Scroller scroller = new Scroller(0.0, 12.0);

    public LogWidget(String name, class_437 parent, int x, int y, int width, int height) {
        super(x, y, width, height, class_2561.method_30163((String)name));
        this.parent = parent;
    }

    public void clearLogs() {
        this.logLines.clear();
    }

    public void addLog(InternalLog line) {
        this.logLines.add(line);
        int visibleRows = (this.field_22759 - 20) / 12;
        int totalRows = this.logLines.size();
        int scrollMax = Math.max(0, (totalRows - visibleRows) * 12);
        this.scroller.setBounds(0.0, scrollMax);
    }

    protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        int offset = 10;
        Renderer2D.fillRoundedRect(context, this.method_46426(), this.method_46427() + offset, this.field_22758, this.field_22759, 2, new Color(0, 0, 0, 100).getRGB());
        Renderer2D.fillRoundedRectOutline(context, this.method_46426(), this.method_46427() + offset, this.field_22758, this.field_22759, 2, 1, MainColors.OUTLINE_BLACK.getRGB());
        Renderer2D.fillRoundedRectOutline(context, this.method_46426() + 1, this.method_46427() + 1 + offset, this.field_22758 - 2, this.field_22759 - 2, 2, 1, MainColors.OUTLINE_WHITE.getRGB());
        this.field_22762 = mouseX >= this.method_46426() && mouseX <= this.method_46426() + this.field_22758 && mouseY >= this.method_46427() + offset && mouseY <= this.method_46427() + this.field_22759;
        context.method_44379(this.method_46426(), this.method_46427() + offset + 2, this.method_46426() + this.field_22758, this.method_46427() + this.field_22759 + 5);
        if (!this.logLines.isEmpty()) {
            class_327 textRenderer = class_310.method_1551().field_1772;
            int rowHeight = 12;
            int yTop = this.method_46427() + offset + 5;
            for (int i = 0; i < this.logLines.size(); ++i) {
                int y = yTop + i * rowHeight - (int)this.scroller.getValue();
                if (y + rowHeight < this.method_46427() + offset || y > this.method_46427() + this.field_22759) continue;
                InternalLog.ToolTip logToolTip = this.logLines.get(i).getToolTip();
                int c = Color.LIGHT_GRAY.getRGB();
                if (logToolTip != null) {
                    c = logToolTip.color();
                    this.method_47400(this.isHoveredLog(mouseX, mouseY) ? logToolTip.tooltip() : null);
                } else {
                    this.method_47400(null);
                }
                String entry = MarqueeUtil.get(this.logLines.get(i).getText(), this.field_22758 - 10, 10);
                context.method_51433(textRenderer, entry, this.method_46426() + 6, y, c, false);
            }
        }
        context.method_44380();
        context.method_27534(class_310.method_1551().field_1772, this.method_25369(), this.parent.field_22789 / 2, this.method_46427() - 4, -1);
    }

    private boolean isHoveredLog(double mouseX, double mouseY) {
        if (this.logLines.isEmpty()) {
            return false;
        }
        int rowHeight = 12;
        int offset = 10;
        int yTop = this.method_46427() + offset + 5;
        if (mouseX < (double)this.method_46426() || mouseX > (double)(this.method_46426() + this.field_22758) || mouseY < (double)(this.method_46427() + offset) || mouseY > (double)(this.method_46427() + this.field_22759)) {
            return false;
        }
        int index = (int)((mouseY - (double)yTop + this.scroller.getValue()) / (double)rowHeight);
        return index >= 0 && index < this.logLines.size();
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.method_49606()) {
            this.scroller.onScroll(verticalAmount);
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    protected void method_47399(class_6382 builder) {
    }
}

