/*
 * Decompiled with CFR 0.152.
 */
package main.walksy.lib.core.gui.widgets;

import main.walksy.lib.core.config.local.Option;
import main.walksy.lib.core.config.local.options.groups.OptionGroup;
import main.walksy.lib.core.gui.impl.WalksyLibConfigScreen;
import main.walksy.lib.core.gui.widgets.OptionWidget;
import main.walksy.lib.core.renderer.Renderer2D;
import main.walksy.lib.core.utils.Animation;
import main.walksy.lib.core.utils.MainColors;
import main.walksy.lib.core.utils.ScreenGlobals;
import net.minecraft.class_1144;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;

public abstract class OpenableWidget
extends OptionWidget {
    public boolean open = false;
    public int OPEN_HEIGHT;
    private final Animation heightAnim;

    public OpenableWidget(OptionGroup parent, WalksyLibConfigScreen screen, Option<?> option, int x, int y, int width, int height, String name, int openedHeight) {
        super(parent, screen, option, x, y, width, height, name);
        this.OPEN_HEIGHT = openedHeight;
        this.heightAnim = new Animation(height, 0.5f);
    }

    @Override
    protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        float currentAnimated;
        this.heightAnim.update(delta);
        if (!this.heightAnim.isAnimating()) {
            this.method_53533(ScreenGlobals.OPTION_HEIGHT);
        }
        if (Math.abs((currentAnimated = this.heightAnim.getCurrentValue()) - (float)this.field_22759) >= 1.0f) {
            int animHeight = Math.round(currentAnimated);
            this.method_53533(animHeight);
            this.update();
        }
        context.method_44379(0, 49, this.screen.field_22789, this.screen.field_22790 - 28);
        if (this.isVisible()) {
            Renderer2D.renderMiniArrow(context, this.method_46426() - 8, this.getTextYCentered() + (this.open ? 4 : 5), 1.0f, this.open ? Renderer2D.ArrowDirection.DOWN : Renderer2D.ArrowDirection.RIGHT, this.method_49606() ? MainColors.OUTLINE_WHITE_HOVERED.getRGB() : MainColors.OUTLINE_WHITE.getRGB());
        }
        context.method_44380();
        super.method_48579(context, mouseX, mouseY, delta);
    }

    @Override
    public void draw(class_332 context, int mouseX, int mouseY, float delta) {
    }

    @Override
    public void onMouseClick(double mouseX, double mouseY, int button) {
        if (this.method_49606() && button == 0) {
            this.toggleOpen();
        }
    }

    public float getCurrentHeight() {
        return this.heightAnim.getCurrentValue();
    }

    private void toggleOpen() {
        boolean prev = this.open;
        this.open = !this.open;
        float target = this.open ? (float)this.OPEN_HEIGHT : (float)ScreenGlobals.OPTION_HEIGHT;
        this.heightAnim.setTargetValue(target);
        class_339.method_62888((class_1144)class_310.method_1551().method_1483());
        this.onOpen(prev);
    }

    public boolean fullyClosed() {
        return !this.open && Math.round(this.heightAnim.getCurrentValue()) == ScreenGlobals.OPTION_HEIGHT;
    }

    protected abstract void onOpen(boolean var1);

    @Override
    public void onWidgetUpdate() {
    }
}

