/*
 * Decompiled with CFR 0.152.
 */
package main.walksy.lib.core.gui.widgets;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import main.walksy.lib.core.config.local.Option;
import main.walksy.lib.core.config.local.options.groups.OptionGroup;
import main.walksy.lib.core.gui.impl.WalksyLibConfigScreen;
import main.walksy.lib.core.gui.widgets.AbstractWidget;
import main.walksy.lib.core.gui.widgets.OptionWidget;
import main.walksy.lib.core.renderer.Renderer2D;
import main.walksy.lib.core.utils.ScreenGlobals;
import main.walksy.lib.core.utils.SearchUtils;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_6382;

public class OptionGroupWidget
extends AbstractWidget {
    private final OptionGroup group;
    private final List<OptionWidget> children = new ArrayList<OptionWidget>();
    private final WalksyLibConfigScreen parent;
    private String searchQuery = "";
    public boolean isHovered;

    public OptionGroupWidget(int x, int y, int width, int height, OptionGroup group, WalksyLibConfigScreen parent) {
        super(x, y, width, height, class_2561.method_30163((String)group.getName()));
        this.parent = parent;
        this.group = group;
        this.isHovered = false;
        int yOff = y + 20;
        for (Option<?> option : group.getOptions()) {
            OptionWidget optionWidget = option.createWidget(group, parent, 15, yOff, ScreenGlobals.OPTION_WIDTH, ScreenGlobals.OPTION_HEIGHT);
            this.children.add(optionWidget);
            yOff += 30;
        }
    }

    protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_44379(0, 49, this.parent.field_22789, this.parent.field_22790 - 28);
        class_310 client = class_310.method_1551();
        class_327 textRenderer = client.field_1772;
        String text = this.group.getName();
        int textWidth = textRenderer.method_1727(text);
        Objects.requireNonNull(textRenderer);
        int fontHeight = 9;
        int centerX = this.method_46426() + textWidth / 2;
        int hoverPadding = 58;
        int hoverHeight = fontHeight + 4;
        boolean bl = this.isHovered = context.method_58135(mouseX, mouseY) && mouseY >= this.method_46427() - 2 && mouseY < this.method_46427() - 2 + hoverHeight && mouseX >= centerX - (textWidth / 2 + hoverPadding) && mouseX < centerX + (textWidth / 2 + hoverPadding);
        int bgColor = this.group.isExpanded() ? -1 : (this.isHovered ? -2434342 : -5592406);
        int midY = this.method_46427() + fontHeight / 2;
        int textCenterX = this.method_46426();
        int textStartX = textCenterX - textWidth / 2;
        int textEndX = textCenterX + textWidth / 2;
        context.method_25292(textStartX - 50, textStartX - 8, midY - 1, bgColor);
        context.method_25292(textStartX - 50, textStartX - 8, midY, bgColor);
        Renderer2D.renderMiniArrow(context, textStartX - 50 - 5, midY - (this.group.isExpanded() ? 1 : 0), 1.0f, this.group.isExpanded() ? Renderer2D.ArrowDirection.DOWN : Renderer2D.ArrowDirection.RIGHT, bgColor);
        context.method_25292(textEndX + 5, textEndX + 50, midY - 1, bgColor);
        context.method_25292(textEndX + 5, textEndX + 50, midY, bgColor);
        Renderer2D.renderMiniArrow(context, textEndX + 50 + 6, midY - (this.group.isExpanded() ? 1 : 0), 1.0f, this.group.isExpanded() ? Renderer2D.ArrowDirection.DOWN : Renderer2D.ArrowDirection.LEFT, bgColor);
        if (ScreenGlobals.DEBUG) {
            this.renderDebug(context, centerX - (textWidth / 2 + hoverPadding), this.method_46427() - 2, centerX + (textWidth / 2 + hoverPadding), this.method_46427() - 2 + hoverHeight);
        }
        context.method_25303(textRenderer, text, this.method_46426() - textWidth / 2, this.method_46427(), bgColor);
        context.method_44380();
    }

    private void renderDebug(class_332 context, int x1, int y1, int x2, int y2) {
        context.method_25294(x1, y1, x2, y2, -1426063361);
    }

    public void onMouseClick(double mouseX, double mouseY, int button) {
        if (this.isHovered && button == 0) {
            this.group.toggleExpanded();
            this.parent.layoutGroupWidgets();
            this.updateVisibility();
        }
    }

    public void updateVisibility() {
        boolean expanded = this.group.isExpanded();
        for (OptionWidget child : this.children) {
            child.field_22764 = expanded;
        }
    }

    protected void method_47399(class_6382 builder) {
    }

    public boolean searched(boolean shouldLevenshtein) {
        if (this.searchQuery.isEmpty()) {
            return true;
        }
        String[] queryWords = this.searchQuery.toLowerCase().trim().split("\\s+");
        String[] nameWords = this.group.getName().toLowerCase().trim().split("\\s+");
        block0: for (String qWord : queryWords) {
            for (String nameWord : nameWords) {
                if (nameWord.contains(qWord) || nameWord.startsWith(qWord) || shouldLevenshtein && SearchUtils.levenshteinDistance(nameWord, qWord) <= 2) continue block0;
            }
            return false;
        }
        return true;
    }

    public void updateSearchQuery(String query) {
        this.searchQuery = query;
    }

    public List<OptionWidget> getChildren() {
        return this.children;
    }

    public OptionGroup getGroup() {
        return this.group;
    }
}

