/*
 * Decompiled with CFR 0.152.
 */
package main.walksy.lib.core.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import main.walksy.lib.core.config.local.Option;
import main.walksy.lib.core.config.local.options.groups.OptionGroup;
import main.walksy.lib.core.gui.impl.WalksyLibConfigScreen;
import main.walksy.lib.core.gui.widgets.AbstractWidget;
import main.walksy.lib.core.gui.widgets.ButtonWidget;
import main.walksy.lib.core.renderer.Renderer2D;
import main.walksy.lib.core.utils.MainColors;
import main.walksy.lib.core.utils.ScreenGlobals;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_6382;

public abstract class OptionWidget
extends AbstractWidget {
    private final OptionGroup parent;
    private final Option<?> option;
    private boolean isHovered;
    public WalksyLibConfigScreen screen;
    public ButtonWidget resetButton;
    public boolean changesMade;
    public int mouseX;
    public int mouseY;

    public OptionWidget(OptionGroup parent, WalksyLibConfigScreen screen, Option<?> option, int x, int y, int width, int height, String name) {
        super(x, y, width, height, class_2561.method_30163((String)name));
        this.method_48229(x, y);
        this.parent = parent;
        this.option = option;
        this.screen = screen;
        this.changesMade = false;
        this.isHovered = false;
        int size = ScreenGlobals.OPTION_HEIGHT;
        this.resetButton = new ButtonWidget(this.method_46426() + this.method_25368() - size + 15, this.method_46427(), size, size, false, class_2960.method_60655((String)"walksylib", (String)"gui/widget/reset.png"), this::handleResetButtonClick, -1, 0);
        this.resetButton.setEnabled(option.hasChanged());
    }

    protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        if (!this.isVisible()) {
            return;
        }
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        boolean bl = this.isHovered = mouseX >= this.method_46426() && mouseX < this.method_46426() + this.method_25368() && mouseY >= this.method_46427() && mouseY < this.method_46427() + this.method_25364();
        if (this.isHovered) {
            this.screen.setFocusedOption(this.option);
        }
        int scissorX1 = 0;
        int scissorY1 = 49;
        int scissorX2 = this.screen.field_22789;
        int scissorY2 = this.screen.field_22790 - 28;
        if (this.method_46426() + this.method_25368() < scissorX1 || this.method_46426() > scissorX2 || this.method_46427() + this.method_25364() < scissorY1 || this.method_46427() > scissorY2) {
            return;
        }
        context.method_44379(scissorX1, scissorY1, scissorX2, scissorY2);
        if (!this.isAvailable()) {
            RenderSystem.setShaderColor((float)0.3f, (float)0.3f, (float)0.3f, (float)1.0f);
            if (this.field_22762) {
                this.screen.method_47415(class_2561.method_30163((String)this.option.getAvailabilityHelper()));
            }
        }
        this.renderBase(context);
        this.resetButton.setEnabled(this.option.hasChanged() && this.isAvailable());
        this.resetButton.method_25394(context, mouseX, mouseY, delta);
        context.method_44379(this.method_46426(), this.method_46427(), this.method_46426() + this.method_25368(), this.method_46427() + this.method_25364() - 1);
        this.draw(context, this.isAvailable() ? mouseX : 0, this.isAvailable() ? mouseY : 0, delta);
        context.method_44380();
        this.drawOutsideScissor(context, this.isAvailable() ? mouseX : 0, this.isAvailable() ? mouseY : 0, delta);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        context.method_44380();
    }

    public void onMouseClick(double mouseX, double mouseY, int button) {
    }

    public void onMouseRelease(double mouseX, double mouseY, int button) {
    }

    public void onMouseDrag(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
    }

    public void onMouseMove(double mouseX, double mouseY) {
    }

    public void onMouseScroll(double mouseX, double mouseY, double verticalAmount) {
    }

    public void tick() {
    }

    public void onKeyPress(int keyCode, int scanCode, int modifiers) {
    }

    public void onCharTyped(char chr, int modifiers) {
    }

    public void onWidgetUpdate(int x, int y) {
        this.resetButton.method_48229(x, y);
        this.onWidgetUpdate();
    }

    public abstract void onWidgetUpdate();

    public abstract void draw(class_332 var1, int var2, int var3, float var4);

    public void drawOutsideScissor(class_332 context, int mouseX, int mouseY, float delta) {
    }

    private void renderBase(class_332 context) {
        Renderer2D.fillRoundedRectOutline(context, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), 2, 1, this.method_49606() ? MainColors.OUTLINE_WHITE_HOVERED.getRGB() : MainColors.OUTLINE_WHITE.getRGB());
        Renderer2D.fillRoundedRectOutline(context, this.method_46426() - 1, this.method_46427() - 1, this.method_25368() + 2, this.method_25364() + 2, 2, 1, MainColors.OUTLINE_BLACK.getRGB());
        this.renderName(context);
    }

    public boolean isAvailable() {
        return this.option.isAvailable();
    }

    protected void renderName(class_332 context) {
        context.method_25303(this.screen.method_64506(), this.option.getName(), this.method_46426() + 5, this.getTextYCentered() + 1, -1);
    }

    protected void handleResetButtonClick() {
        this.option.reset();
        this.onThirdPartyChange(this.option.getDefaultValue());
    }

    protected void renderHoverBackground(class_332 context, int hoverLeft, int hoverRight) {
        if (this.method_49606()) {
            context.method_25294(hoverLeft, this.method_46427(), hoverRight, this.method_46427() + this.method_25364(), 0x64FFFFFF);
        }
    }

    protected int getTextYCentered() {
        Objects.requireNonNull(this.screen.method_64506());
        int textHeight = 9;
        return this.method_46427() + (ScreenGlobals.OPTION_HEIGHT - textHeight) / 2;
    }

    public boolean method_49606() {
        return this.isAvailable() && this.isHovered && this.isVisible();
    }

    public boolean isVisible() {
        return this.parent.isExpanded() && this.option.searched();
    }

    public boolean isInScissor(int scissorX, int scissorY, int scissorWidth, int scissorHeight) {
        return this.method_46426() + this.method_25368() > scissorX && this.method_46426() < scissorX + scissorWidth && this.method_46427() + this.method_25364() - 2 > scissorY && this.method_46427() < scissorY + scissorHeight;
    }

    public void updateSearchQuery(String searchQuery) {
        this.option.updateSearchQ(searchQuery);
    }

    public void update() {
        this.screen.layoutGroupWidgets();
    }

    public void onChange() {
        this.screen.onChangesMade(this.option);
    }

    public <V> void onThirdPartyChange(V value) {
    }

    public OptionGroup getParent() {
        return this.parent;
    }

    public Option<?> getOption() {
        return this.option;
    }

    protected void method_47399(class_6382 builder) {
    }
}

