/*
 * Decompiled with CFR 0.152.
 */
package main.walksy.lib.core.gui.widgets;

import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import main.walksy.lib.core.config.local.Option;
import main.walksy.lib.core.config.local.options.groups.OptionGroup;
import main.walksy.lib.core.config.local.options.type.PixelGrid;
import main.walksy.lib.core.config.local.options.type.PixelGridAnimation;
import main.walksy.lib.core.gui.impl.HudEditorScreen;
import main.walksy.lib.core.gui.impl.WalksyLibConfigScreen;
import main.walksy.lib.core.gui.popup.impl.FrameManagerPopUp;
import main.walksy.lib.core.gui.popup.impl.GridEditorPopUp;
import main.walksy.lib.core.gui.widgets.ButtonWidget;
import main.walksy.lib.core.gui.widgets.OpenableWidget;
import main.walksy.lib.core.gui.widgets.sub.SliderSubWidget;
import main.walksy.lib.core.gui.widgets.sub.adaptor.FloatSliderAdapter;
import main.walksy.lib.core.gui.widgets.sub.adaptor.IntSliderAdapter;
import main.walksy.lib.core.renderer.Renderer2D;
import main.walksy.lib.core.utils.MainColors;
import main.walksy.lib.core.utils.ScreenGlobals;
import main.walksy.lib.core.utils.Scroller;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;

public class PixelGridAnimationWidget
extends OpenableWidget {
    public final ButtonWidget editHudButton;
    public final ButtonWidget editFrameButton;
    public final ButtonWidget viewFrames;
    private final Option<PixelGridAnimation> option;
    private final SliderSubWidget<Integer> animationSpeedSlider;
    private final SliderSubWidget<Float> frameSize;
    private final List<ButtonWidget> buttonFrames = new ArrayList<ButtonWidget>();
    private PixelGrid viewingGrid;
    private final Scroller scroller;
    private int frameToReplace = -1;
    private boolean draggingScroller = false;
    private int dragOffsetY = 0;

    public PixelGridAnimationWidget(OptionGroup parent, WalksyLibConfigScreen screen, int x, int y, int width, int height, Option<PixelGridAnimation> option) {
        super(parent, screen, option, x, y, width, height, option.getName(), ScreenGlobals.OPTION_HEIGHT * 6);
        this.option = option;
        this.scroller = new Scroller(0.0, 2.0);
        this.editHudButton = new ButtonWidget(this.method_25368() - 82, this.method_46427() + 3, 50, 14, false, "Edit Hud", () -> this.handleEditHudButtonClick(screen));
        this.editFrameButton = new ButtonWidget(this.method_25368() - 142, this.method_46427() + 101, 60, 14, false, "Edit Frame", this::handleEditFrameButtonClick);
        this.viewFrames = new ButtonWidget(this.method_46426() + 70, this.method_46427() + 101, 77, 14, false, "View Frames", this::handleViewFramesButtonClick);
        this.setupFrames(-1, true);
        List<PixelGrid> frames = option.getValue().getFrames();
        if (!frames.isEmpty()) {
            this.viewingGrid = frames.get(0).copy();
        }
        this.animationSpeedSlider = new SliderSubWidget<Integer>(this.method_46426() + 75, this.method_46427() + 38, 100, ScreenGlobals.OPTION_HEIGHT - 12, new IntSliderAdapter(0, 20, option.getValue().getAnimationSpeed()), option.getValue().getAnimationSpeed(), option.getValue()::setAnimationSpeed, true);
        this.frameSize = new SliderSubWidget<Float>(this.method_46426() + 75, this.method_46427() + 68, 100, ScreenGlobals.OPTION_HEIGHT - 12, new FloatSliderAdapter(0.0f, 10.0f, option.getValue().getSize()), Float.valueOf(option.getValue().getSize()), option.getValue()::setSize, true);
    }

    @Override
    public void draw(class_332 context, int mouseX, int mouseY, float delta) {
        super.draw(context, mouseX, mouseY, delta);
        this.animationSpeedSlider.setOnChange(this.option.getValue()::setAnimationSpeed);
        this.frameSize.setOnChange(this.option.getValue()::setSize);
        this.editHudButton.method_25394(context, mouseX, mouseY, delta);
        context.method_25301(this.method_46426() + this.method_25368() - 38, this.method_46427(), this.method_46427() + ScreenGlobals.OPTION_HEIGHT - 1, this.method_49606() ? MainColors.OUTLINE_WHITE_HOVERED.getRGB() : MainColors.OUTLINE_WHITE.getRGB());
        if (!this.fullyClosed()) {
            this.viewFrames.method_25394(context, mouseX, mouseY, delta);
            this.editFrameButton.method_25394(context, mouseX, mouseY, delta);
            this.animationSpeedSlider.render(context, mouseX, mouseY, delta);
            this.frameSize.render(context, mouseX, mouseY, delta);
            this.screen.scroll = !this.isHoveredFrameSelector();
            context.method_25292(this.method_46426() + 1, this.method_46426() + this.method_25368() - 2, this.method_46427() + ScreenGlobals.OPTION_HEIGHT - 1, this.method_49606() ? MainColors.OUTLINE_WHITE_HOVERED.getRGB() : MainColors.OUTLINE_WHITE.getRGB());
            context.method_25300(this.screen.method_64506(), "Frame " + this.frameToReplace + " Grid", this.method_25368() - 40, this.method_46427() + 23, -1);
            context.method_25303(this.screen.method_64506(), "Animation Speed", this.method_46426() + 75, this.method_46427() + 28, Color.LIGHT_GRAY.getRGB());
            context.method_25303(this.screen.method_64506(), "Size", this.method_46426() + 75, this.method_46427() + 58, Color.LIGHT_GRAY.getRGB());
            context.method_51448().method_22903();
            float scale = 0.6f;
            context.method_51448().method_22905(scale, scale, 1.0f);
            if (this.viewingGrid != null) {
                Renderer2D.renderGridOutline(context, this.viewingGrid, (int)((float)(this.method_25368() - 78) / scale), (int)((float)(this.method_46427() + 37) / scale), 7, 2, MainColors.OUTLINE_WHITE.getRGB(), true);
            }
            context.method_51448().method_22909();
            this.drawScrollableFrameSelector(context, mouseX, mouseY, delta);
        }
        if (this.option.getValue().getCurrentFrame() != null) {
            Renderer2D.renderGridTexture(context, this.option.getValue().getCurrentFrame(), this.method_25368() - 10, this.method_46427() + 3, 1, 0, false);
        }
    }

    private void drawScrollableFrameSelector(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_25301(this.method_46426() + 60, this.method_46427() + ScreenGlobals.OPTION_HEIGHT - 1, this.method_46427() + this.method_25364() - 1, MainColors.OUTLINE_WHITE.getRGB());
        context.method_25301(this.method_46426() + 65, this.method_46427() + ScreenGlobals.OPTION_HEIGHT - 1, this.method_46427() + this.method_25364() - 1, MainColors.OUTLINE_WHITE.getRGB());
        int trackHeight = this.method_25364() - ScreenGlobals.OPTION_HEIGHT;
        int contentHeight = this.buttonFrames.size() * 23;
        int handleHeight = class_3532.method_15340((int)(trackHeight * trackHeight / Math.max(trackHeight, contentHeight)), (int)10, (int)trackHeight);
        int handleY = this.method_46427() + ScreenGlobals.OPTION_HEIGHT - 1 + (int)(this.scroller.getValue() * (double)(trackHeight - handleHeight) / (double)Math.max(1, contentHeight - trackHeight));
        context.method_25294(this.method_46426() + 61, handleY + 1, this.method_46426() + 65, handleY + handleHeight, new Color(210, 210, 210).getRGB());
        context.method_44379(this.method_46426(), this.method_46427() + ScreenGlobals.OPTION_HEIGHT, this.method_46426() + 60, this.method_46427() + this.OPEN_HEIGHT - 1);
        for (ButtonWidget btn : this.buttonFrames) {
            btn.hovered = this.isHoveredFrameSelector();
            btn.scrollY = (float)this.scroller.getValue();
            btn.method_25394(context, mouseX, mouseY, delta);
        }
        context.method_44380();
    }

    @Override
    public void onMouseClick(double mouseX, double mouseY, int button) {
        super.onMouseClick(mouseX, mouseY, button);
        this.editHudButton.method_25348(mouseX, mouseY);
        this.editFrameButton.method_25348(mouseX, mouseY);
        this.viewFrames.method_25348(mouseX, mouseY);
        int handleY = this.method_46427() + ScreenGlobals.OPTION_HEIGHT + (int)this.scroller.getValue();
        if (this.isHoveringScroller()) {
            this.draggingScroller = true;
            this.dragOffsetY = (int)(mouseY - (double)handleY);
        }
        this.animationSpeedSlider.onClick((int)mouseX, (int)mouseY, button);
        this.frameSize.onClick((int)mouseX, (int)mouseY, button);
        for (ButtonWidget btn : this.buttonFrames) {
            btn.method_25348(mouseX, mouseY);
        }
    }

    @Override
    public void onMouseRelease(double mouseX, double mouseY, int button) {
        super.onMouseRelease(mouseX, mouseY, button);
        this.animationSpeedSlider.release();
        this.frameSize.release();
        this.draggingScroller = false;
    }

    @Override
    public void onMouseDrag(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        super.onMouseDrag(mouseX, mouseY, button, deltaX, deltaY);
        if (this.draggingScroller) {
            int trackStart = this.method_46427() + ScreenGlobals.OPTION_HEIGHT - 1;
            int trackHeight = this.method_25364() - ScreenGlobals.OPTION_HEIGHT;
            int contentHeight = this.buttonFrames.size() * 23;
            int handleHeight = class_3532.method_15340((int)(trackHeight * trackHeight / Math.max(trackHeight, contentHeight)), (int)10, (int)trackHeight);
            int newValue = (int)((mouseY - (double)this.dragOffsetY - (double)trackStart) * (double)(contentHeight - trackHeight) / (double)(trackHeight - handleHeight));
            this.scroller.setValue(class_3532.method_15340((int)newValue, (int)0, (int)Math.max(0, contentHeight - trackHeight)));
        }
        this.animationSpeedSlider.onDrag((int)mouseX);
        this.frameSize.onDrag((int)mouseX);
    }

    @Override
    public void onMouseScroll(double mouseX, double mouseY, double verticalAmount) {
        super.onMouseScroll(mouseX, mouseY, verticalAmount);
        if (this.isHoveredFrameSelector()) {
            this.scroller.onScroll(verticalAmount);
            this.scroller.setBounds(0.0, Math.max(0, this.buttonFrames.size() * 23 - (this.method_25364() - ScreenGlobals.OPTION_HEIGHT)));
        }
    }

    @Override
    public void onWidgetUpdate() {
        this.editHudButton.method_48229(this.method_25368() - 82, this.method_46427() + 3);
        this.viewFrames.method_48229(this.method_46426() + 70, this.method_46427() + 101);
        this.editFrameButton.method_48229(this.method_25368() - 142, this.method_46427() + 101);
        this.updateButtons();
        this.scroller.setBounds(0.0, Math.max(0, this.buttonFrames.size() * 23 - (this.method_25364() - ScreenGlobals.OPTION_HEIGHT)));
        this.animationSpeedSlider.setPos(new Point(this.method_46426() + 75, this.method_46427() + 38));
        this.frameSize.setPos(new Point(this.method_46426() + 75, this.method_46427() + 68));
    }

    private void handleEditHudButtonClick(WalksyLibConfigScreen parent) {
        class_310.method_1551().method_1507((class_437)new HudEditorScreen(parent, this.option));
    }

    private void handleEditFrameButtonClick() {
        if (this.viewingGrid == null) {
            return;
        }
        this.screen.popUp = new GridEditorPopUp(this.screen, this.viewingGrid.copy(), newGrid -> {
            this.option.setValue(PixelGridAnimation.replace(this.option.getValue(), newGrid, this.frameToReplace));
            this.viewingGrid = newGrid.copy();
            this.setupFrames(this.frameToReplace, false);
        }, this.frameToReplace);
    }

    private void handleViewFramesButtonClick() {
        this.screen.popUp = new FrameManagerPopUp(this.screen, this.option, () -> {
            this.setupFrames(this.frameToReplace, false);
            PixelGrid frame = this.option.getValue().getFrame(this.frameToReplace);
            PixelGrid grid = frame != null ? frame.copy() : this.option.getValue().getFrames().get(0).copy();
            this.viewingGrid = grid;
        }, grid -> this.option.getValue().setCurrentFrame(0));
    }

    @Override
    public boolean method_49606() {
        return this.mouseX >= this.method_46426() && this.mouseX < this.method_46426() + this.method_25368() - 6 && this.mouseY >= this.method_46427() && this.mouseY < this.method_46427() + ScreenGlobals.OPTION_HEIGHT && !this.editHudButton.method_49606();
    }

    @Override
    protected void onOpen(boolean prev) {
        if (prev) {
            this.screen.scroll = true;
        }
    }

    public boolean isHoveredFrameSelector() {
        int xStart = this.method_46426();
        int xEnd = this.method_46426() + 65;
        int yStart = this.method_46427();
        int yEnd = this.method_46427() + this.method_25364() - 1;
        return this.mouseX >= xStart && this.mouseX <= xEnd && this.mouseY >= yStart && this.mouseY <= yEnd;
    }

    private boolean isHoveringScroller() {
        int trackHeight = this.method_25364() - ScreenGlobals.OPTION_HEIGHT;
        int contentHeight = this.buttonFrames.size() * 23;
        int handleHeight = class_3532.method_15340((int)(trackHeight * trackHeight / Math.max(trackHeight, contentHeight)), (int)10, (int)trackHeight);
        int handleY = this.method_46427() + ScreenGlobals.OPTION_HEIGHT - 1 + (int)(this.scroller.getValue() * (double)(trackHeight - handleHeight) / (double)Math.max(1, contentHeight - trackHeight));
        int scrollerX = this.method_46426() + 61;
        return this.mouseX >= scrollerX && this.mouseX <= scrollerX + 4 && this.mouseY >= handleY + 1 && this.mouseY <= handleY + handleHeight;
    }

    public void updateButtons() {
        int yOffset = 0;
        for (ButtonWidget btn : this.buttonFrames) {
            btn.method_48229(this.method_46426() + 5, this.method_46427() + 23 + yOffset);
            yOffset += 23;
        }
    }

    public void setupFrames(int hoverFrame, boolean reset) {
        this.buttonFrames.clear();
        if (reset) {
            this.resetViewingGrid();
        }
        List<PixelGrid> frames = this.option.getValue().getFrames();
        for (int i = 0; i < frames.size(); ++i) {
            int frameIndex = i;
            ButtonWidget btn = new ButtonWidget(this.method_46426() + 5, this.method_46427() + 23 + i * 23, 51, 18, false, "Frame " + (frameIndex + 1), null);
            if (frameIndex == 0 && hoverFrame == -1) {
                btn.overrideHover = true;
                this.frameToReplace = 1;
            } else if (hoverFrame - 1 == frameIndex) {
                btn.overrideHover = true;
            }
            btn.setListener(() -> {
                this.buttonFrames.forEach(b -> {
                    b.overrideHover = b.method_49606();
                });
                this.viewingGrid = ((PixelGrid)frames.get(frameIndex)).copy();
                this.frameToReplace = frameIndex + 1;
            });
            this.buttonFrames.add(btn);
        }
    }

    @Override
    protected void handleResetButtonClick() {
        super.handleResetButtonClick();
        this.reset();
    }

    @Override
    public <V> void onThirdPartyChange(V value) {
        super.onThirdPartyChange(value);
        this.animationSpeedSlider.setValue(this.option.getValue().getAnimationSpeed());
        this.frameSize.setValue(Float.valueOf(this.option.getValue().getSize()));
    }

    public void reset() {
        this.resetViewingGrid();
        this.setupFrames(-1, true);
    }

    private void resetViewingGrid() {
        if (this.frameToReplace > 0) {
            this.viewingGrid = this.option.getValue().getFrame(1).copy();
        }
    }
}

