/*
 * Decompiled with CFR 0.152.
 */
package main.walksy.lib.core.gui.widgets;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicReference;
import main.walksy.lib.core.config.local.Option;
import main.walksy.lib.core.config.local.options.groups.OptionGroup;
import main.walksy.lib.core.gui.impl.WalksyLibConfigScreen;
import main.walksy.lib.core.gui.popup.impl.TextureDropPopUp;
import main.walksy.lib.core.gui.widgets.ButtonWidget;
import main.walksy.lib.core.gui.widgets.OptionWidget;
import main.walksy.lib.core.utils.IdentifierWrapper;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_332;
import net.minecraft.class_7919;

public class SpriteOptionWidget
extends OptionWidget {
    private final Option<IdentifierWrapper> option;
    private final ButtonWidget editTextureButton;
    private class_1011 image;
    private int visibleX;
    private int visibleY;
    private int visibleWidth;
    private int visibleHeight;

    public SpriteOptionWidget(OptionGroup parent, WalksyLibConfigScreen screen, int x, int y, int width, int height, Option<IdentifierWrapper> option) {
        super(parent, screen, option, x, y, width, height, option.getName());
        this.option = option;
        this.editTextureButton = new ButtonWidget(this.method_25368() - 100, this.method_46427() + 3, 70, 14, false, "Edit Texture", () -> {
            this.screen.popUp = new TextureDropPopUp(screen, "Texture Editor: " + option.getName(), pass -> {
                this.option.setValue(new IdentifierWrapper(pass.identifier(), pass.fileName()));
                this.reCalc();
            });
        });
        this.reCalc();
    }

    @Override
    public void draw(class_332 context, int mouseX, int mouseY, float delta) {
        this.editTextureButton.method_25394(context, mouseX, mouseY, delta);
        if (this.image == null) {
            return;
        }
        int padding = 6;
        float scaleX = (float)(((double)this.method_46426() * 2.2 - (double)padding) / (double)this.visibleWidth);
        float scaleY = Math.min((float)(this.method_25368() - padding) / (float)this.visibleWidth, (float)(this.method_25364() - padding) / (float)this.visibleHeight);
        float drawX = (float)(this.method_46426() + this.method_25368()) - (float)this.visibleWidth * scaleX - (float)padding;
        float drawY = (float)this.method_46427() + ((float)this.method_25364() - (float)this.visibleHeight * scaleY) / 2.0f;
        context.method_51448().method_22903();
        context.method_51448().method_22905(scaleX, scaleY, 1.0f);
        context.method_25290(class_1921::method_62277, this.option.getValue().getIdentifier(), (int)(drawX / scaleX), (int)(drawY / scaleY), (float)this.visibleX, (float)this.visibleY, this.visibleWidth, this.visibleHeight, this.image.method_4307(), this.image.method_4323());
        context.method_51448().method_22909();
        if (this.isHoveringImage(mouseX, mouseY)) {
            this.method_47400(class_7919.method_47407((class_2561)class_2561.method_30163((String)(this.option.getValue().getIdentifier().method_12836() + ": " + this.option.getValue().getIdentifier().method_12832()))));
        } else {
            this.method_47400(null);
        }
    }

    @Override
    public void onMouseClick(double mouseX, double mouseY, int button) {
        super.onMouseClick(mouseX, mouseY, button);
        this.editTextureButton.method_25348(mouseX, mouseY);
    }

    @Override
    public void onWidgetUpdate() {
        this.editTextureButton.method_48229(this.method_25368() - 100, this.method_46427() + 3);
    }

    @Override
    protected void handleResetButtonClick() {
        super.handleResetButtonClick();
        this.reCalc();
    }

    @Override
    public boolean method_49606() {
        return false;
    }

    public boolean isHoveringImage(double mouseX, double mouseY) {
        if (this.image == null) {
            return false;
        }
        int padding = 6;
        float scale = Math.min((float)(this.method_25368() - padding) / (float)this.visibleWidth, (float)(this.method_25364() - padding) / (float)this.visibleHeight);
        float drawX = (float)(this.method_46426() + this.method_25368()) - (float)this.visibleWidth * scale - (float)padding;
        float drawY = (float)this.method_46427() + ((float)this.method_25364() - (float)this.visibleHeight * scale) / 2.0f;
        return mouseX >= (double)drawX && mouseX <= (double)(drawX + (float)this.visibleWidth * scale) && mouseY >= (double)drawY && mouseY <= (double)(drawY + (float)this.visibleHeight * scale);
    }

    public void reCalc() {
        class_2960 id = this.option.getValue().getIdentifier();
        AtomicReference<class_1011> tempImage = new AtomicReference<class_1011>();
        class_1060 textureManager = class_310.method_1551().method_1531();
        class_1044 class_10442 = textureManager.method_4619(id);
        if (class_10442 instanceof class_1043) {
            class_1043 nativeTexture = (class_1043)class_10442;
            tempImage.set(nativeTexture.method_4525());
        } else {
            class_3300 manager = class_310.method_1551().method_1478();
            manager.method_14486(id).ifPresent(resource -> {
                try (InputStream stream = resource.method_14482();){
                    tempImage.set(class_1011.method_4309((InputStream)stream));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        this.image = (class_1011)tempImage.get();
        if (this.image != null) {
            int minX = this.image.method_4307();
            int minY = this.image.method_4323();
            int maxX = 0;
            int maxY = 0;
            for (int y1 = 0; y1 < this.image.method_4323(); ++y1) {
                for (int x1 = 0; x1 < this.image.method_4307(); ++x1) {
                    int alpha = this.image.method_61940(x1, y1) >>> 24;
                    if (alpha == 0) continue;
                    if (x1 < minX) {
                        minX = x1;
                    }
                    if (y1 < minY) {
                        minY = y1;
                    }
                    if (x1 > maxX) {
                        maxX = x1;
                    }
                    if (y1 <= maxY) continue;
                    maxY = y1;
                }
            }
            if (minX <= maxX && minY <= maxY) {
                this.visibleX = minX;
                this.visibleY = minY;
                this.visibleWidth = maxX - minX + 1;
                this.visibleHeight = maxY - minY + 1;
            } else {
                this.visibleX = 0;
                this.visibleY = 0;
                this.visibleWidth = 1;
                this.visibleHeight = 1;
            }
        } else {
            this.visibleX = 0;
            this.visibleY = 0;
            this.visibleWidth = 1;
            this.visibleHeight = 1;
        }
    }
}

