/*
 * Decompiled with CFR 0.152.
 */
package main.walksy.lib.core.gui.widgets;

import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import main.walksy.lib.core.config.local.Option;
import main.walksy.lib.core.config.local.options.groups.OptionGroup;
import main.walksy.lib.core.gui.impl.WalksyLibConfigScreen;
import main.walksy.lib.core.gui.widgets.ButtonWidget;
import main.walksy.lib.core.gui.widgets.OptionWidget;
import main.walksy.lib.core.gui.widgets.sub.TextboxSubWidget;
import main.walksy.lib.core.utils.MainColors;
import main.walksy.lib.core.utils.ScreenGlobals;
import net.minecraft.class_332;

public class StringListOptionWidget
extends OptionWidget {
    private final Option<List<String>> option;
    private final ButtonWidget addButton;
    private final List<TextboxSubWidget> textboxes = new ArrayList<TextboxSubWidget>();
    private final List<ButtonWidget> removeButtons = new ArrayList<ButtonWidget>();
    private int pendingRemovalIndex = -1;
    public int ADDITIONAL_HEIGHT;

    public StringListOptionWidget(OptionGroup parent, WalksyLibConfigScreen screen, int x, int y, int width, int height, Option<List<String>> option) {
        super(parent, screen, option, x, y, width, height, option.getName());
        this.option = option;
        this.setHeight();
        this.addButton = new ButtonWidget(this.method_46426() + width - 37, this.method_46427() + 3, 30, 14, false, "Add", this::onAdd);
    }

    @Override
    public void draw(class_332 context, int mouseX, int mouseY, float delta) {
        this.addButton.method_25394(context, mouseX, mouseY, delta);
        context.method_25292(this.method_46426() + 1, this.method_46426() + this.method_25368() - 2, this.method_46427() + ScreenGlobals.OPTION_HEIGHT - 1, this.method_49606() ? MainColors.OUTLINE_WHITE_HOVERED.getRGB() : MainColors.OUTLINE_WHITE.getRGB());
        if (this.option.getValue().isEmpty()) {
            int cX = this.method_25368() / 2;
            context.method_25300(this.screen.method_64506(), "No Entries", cX + this.screen.method_64506().method_1727("No Entries") / 2, this.getTextYCentered() + 1 + this.ADDITIONAL_HEIGHT, -1);
        }
        for (int i = 0; i < this.textboxes.size(); ++i) {
            TextboxSubWidget textBox = this.textboxes.get(i);
            int width = this.screen.method_64506().method_1727(String.valueOf(i + 1));
            int off = -1;
            context.method_25303(this.screen.method_64506(), String.valueOf(i + 1), this.method_46426() + 5, textBox.getPos().y + 6 + off, -1);
            context.method_25301(this.method_46426() + width + 8, textBox.getPos().y + 1 + off, textBox.getPos().y - 1 + off + textBox.getHeight(), textBox.hovered || textBox.isFocused() ? -1 : new Color(255, 255, 255, 180).getRGB());
            textBox.render(context, mouseX, mouseY, delta);
            this.removeButtons.get(i).method_25394(context, mouseX, mouseY, delta);
        }
    }

    @Override
    public void onMouseClick(double mouseX, double mouseY, int button) {
        this.addButton.method_25348(mouseX, mouseY);
        for (TextboxSubWidget textbox : this.textboxes) {
            textbox.setFocus(false);
            textbox.onClick((int)mouseX, (int)mouseY, button);
        }
        for (int i = 0; i < this.removeButtons.size(); ++i) {
            this.removeButtons.get(i).method_25348(mouseX, mouseY);
        }
        if (this.pendingRemovalIndex >= 0) {
            ArrayList mutable = new ArrayList(this.option.getValue());
            if (this.pendingRemovalIndex < mutable.size()) {
                mutable.remove(this.pendingRemovalIndex);
                this.option.setValue(mutable);
                this.setHeight();
            }
            this.pendingRemovalIndex = -1;
        }
        super.onMouseClick(mouseX, mouseY, button);
    }

    @Override
    public void onWidgetUpdate() {
        this.addButton.method_48229(this.method_46426() + this.field_22758 - 37, this.method_46427() + 3);
        for (int i = 0; i < this.textboxes.size(); ++i) {
            int labelWidth = this.screen.method_64506().method_1727(String.valueOf(i + 1));
            this.textboxes.get(i).setPos(new Point(this.method_46426() + labelWidth + 10, this.method_46427() + 25 + i * 20));
            this.textboxes.get(i).setWidth(this.method_25368() - (labelWidth + 44));
            this.removeButtons.get(i).method_48229(this.method_46426() + this.method_25368() - 26, this.method_46427() + 25 + i * 20 + 1);
        }
    }

    @Override
    public void onKeyPress(int keyCode, int scanCode, int modifiers) {
        for (TextboxSubWidget textbox : this.textboxes) {
            textbox.onKeyPress(keyCode, scanCode, modifiers);
        }
        super.onKeyPress(keyCode, scanCode, modifiers);
    }

    @Override
    public void onCharTyped(char chr, int modifiers) {
        for (TextboxSubWidget textbox : this.textboxes) {
            textbox.onCharTyped(chr, modifiers);
        }
        super.onCharTyped(chr, modifiers);
    }

    @Override
    protected void handleResetButtonClick() {
        super.handleResetButtonClick();
        this.setHeight();
    }

    @Override
    public boolean method_49606() {
        return false;
    }

    private void onAdd() {
        ArrayList<String> mutable = new ArrayList<String>((Collection)this.option.getValue());
        mutable.add("");
        this.option.setValue(mutable);
        this.setHeight();
    }

    public void setHeight() {
        this.rebuildTextboxes();
        int size = this.option.getValue().size();
        this.ADDITIONAL_HEIGHT = size == 0 ? 20 : size * 20 + 4;
        this.method_53533(ScreenGlobals.OPTION_HEIGHT + this.ADDITIONAL_HEIGHT);
        this.update();
    }

    private void rebuildTextboxes() {
        this.textboxes.clear();
        this.removeButtons.clear();
        int yOffset = this.method_46427() + ScreenGlobals.OPTION_HEIGHT + 4;
        int textboxHeight = 18;
        List<String> currentValues = this.option.getValue();
        for (int i = 0; i < currentValues.size(); ++i) {
            int y = yOffset + i * (textboxHeight + 2);
            int index = i;
            Consumer<String> onChange = newValue -> {
                ArrayList<String> newList = new ArrayList<String>((Collection)this.option.getValue());
                newList.set(index, (String)newValue);
                this.option.setValue(newList);
            };
            TextboxSubWidget textbox = new TextboxSubWidget(this.screen, this.method_46426() + 8, y, this.method_25368() - 34, this.method_25368() - 34, textboxHeight, currentValues.get(i), onChange, false);
            ButtonWidget removeButton = new ButtonWidget(this.method_46426() + this.method_25368() - 26, y + 1, 20, 14, false, "-", () -> {
                this.pendingRemovalIndex = index;
            });
            this.textboxes.add(textbox);
            this.removeButtons.add(removeButton);
        }
    }

    @Override
    public <V> void onThirdPartyChange(V value) {
        super.onThirdPartyChange(value);
        this.rebuildTextboxes();
        this.setHeight();
        this.onWidgetUpdate();
    }
}

