/*
 * Decompiled with CFR 0.152.
 */
package main.walksy.lib.core.gui.widgets;

import java.awt.Color;
import java.util.List;
import main.walksy.lib.core.gui.utils.CategoryTab;
import main.walksy.lib.core.gui.utils.TabLocation;
import main.walksy.lib.core.gui.widgets.AbstractWidget;
import main.walksy.lib.core.utils.MainColors;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_6382;
import net.minecraft.class_8087;
import net.minecraft.class_8088;

public class UniversalTabWidget
extends AbstractWidget {
    private final class_8088 tabManager;
    private final TabLocation location;
    private final class_437 parent;
    private static final int TAB_WIDTH = 100;
    private static final int TAB_HEIGHT = 20;
    private List<CategoryTab> tabs;
    private float currentScrollOffset = 0.0f;
    private float targetScrollOffset = 0.0f;

    public UniversalTabWidget(int x, int y, int width, int height, List<CategoryTab> tabs, class_8088 tabManager, TabLocation location, class_437 parent) {
        super(x, y, width, height, null);
        this.tabManager = tabManager;
        this.location = location;
        this.parent = parent;
        this.tabs = tabs;
    }

    private void renderArrowIndicator(class_332 ctx) {
        MaxOffset offset = this.getMaxOffsetDirection();
        if (offset == null) {
            return;
        }
        ctx.method_51448().method_22903();
        int fadeAlpha = (int)((Math.sin((double)(System.currentTimeMillis() % 1000L) / 1000.0 * 2.0 * Math.PI) * 0.5 + 0.5) * 255.0);
        fadeAlpha = Math.min(Math.max(fadeAlpha, 0), 255);
        if (offset != MaxOffset.RIGHT) {
            ctx.method_51448().method_22903();
            ctx.method_51448().method_22904((double)(this.method_46426() + this.method_25368() - 25), (double)(this.method_46427() + this.method_25364()) / 2.0 + 2.5, 0.0);
            ctx.method_51448().method_22905(2.0f, 2.0f, 1.0f);
            ctx.method_25291(class_1921::method_62275, class_2960.method_60655((String)"walksylib", (String)"gui/arrow.png"), -1, -1, 0.0f, 0.0f, 8, 8, 8, 16, new Color(255, 255, 255, fadeAlpha).getRGB());
            ctx.method_51448().method_22909();
        }
        if (offset != MaxOffset.LEFT) {
            ctx.method_51448().method_22903();
            ctx.method_51448().method_22904((double)(this.method_46426() + 25), (double)(this.method_46427() + this.method_25364()) / 2.0 + 2.5, 0.0);
            ctx.method_51448().method_22905(2.0f, 2.0f, 1.0f);
            ctx.method_25291(class_1921::method_62275, class_2960.method_60655((String)"walksylib", (String)"gui/arrow.png"), 1, -1, 0.0f, 8.0f, 8, 8, 8, 16, new Color(255, 255, 255, fadeAlpha).getRGB());
            ctx.method_51448().method_22909();
        }
        ctx.method_51448().method_22909();
    }

    private String getAnimatedTabTitle(String full, class_327 textRenderer, int maxWidth) {
        if (textRenderer.method_1727(full) <= maxWidth) {
            return full;
        }
        String ellipsis = "...";
        int ellipsisWidth = textRenderer.method_1727(ellipsis);
        int visibleWidth = maxWidth - ellipsisWidth;
        int[] widths = new int[full.length() + 1];
        for (int i = 0; i < full.length(); ++i) {
            widths[i + 1] = widths[i] + textRenderer.method_1727(full.substring(i, i + 1));
        }
        int mChars = 0;
        int i = 1;
        while (i <= full.length() && widths[i] <= visibleWidth) {
            mChars = i++;
        }
        int steps = full.length() - mChars + 1;
        int cycle = steps * 2 - 2;
        int pos = (int)(System.currentTimeMillis() / 100L % (long)cycle);
        if (pos >= steps) {
            pos = cycle - pos;
        }
        String visiblePart = full.substring(pos, pos + mChars);
        return pos == steps - 1 ? visiblePart : visiblePart + ellipsis;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int totalWidth = this.tabs.size() * 104 - 4;
        if (totalWidth <= this.field_22758) {
            return false;
        }
        this.targetScrollOffset -= (float)(verticalAmount * 20.0);
        this.targetScrollOffset = Math.max(0.0f, Math.min(this.targetScrollOffset, (float)(totalWidth - this.field_22758)));
        return true;
    }

    protected void method_48579(class_332 ctx, int mouseX, int mouseY, float delta) {
        class_310 client = class_310.method_1551();
        this.currentScrollOffset = class_3532.method_16439((float)0.2f, (float)this.currentScrollOffset, (float)this.targetScrollOffset);
        if (this.location == TabLocation.TOP || this.location == TabLocation.BOTTOM) {
            int tabX;
            int i;
            if (this.tabs.isEmpty()) {
                return;
            }
            ctx.method_44379(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759);
            int tabCount = this.tabs.size();
            int totalWidth = tabCount * 104 - 4;
            int baseX = totalWidth <= this.field_22758 ? this.method_46426() + (this.field_22758 - totalWidth) / 2 : this.method_46426() - (int)this.currentScrollOffset;
            int[] tabXs = new int[tabCount];
            boolean[] hoveredTabs = new boolean[tabCount];
            boolean[] selectedTabs = new boolean[tabCount];
            for (i = 0; i < tabCount; ++i) {
                boolean selected;
                boolean hovered;
                tabXs[i] = tabX = baseX + i * 104;
                hoveredTabs[i] = hovered = mouseX >= tabX && mouseX <= tabX + 100 && mouseY >= this.method_46427() && mouseY <= this.method_46427() + 20;
                selectedTabs[i] = selected = ((Object)((Object)this.tabs.get(i))).equals(this.tabManager.method_48614());
            }
            for (i = 0; i < tabCount; ++i) {
                tabX = tabXs[i];
                if (tabX + 100 < this.method_46426() || tabX > this.method_46426() + this.field_22758) continue;
                String fullText = this.tabs.get(i).method_48610().getString();
                String text = this.getAnimatedTabTitle(fullText, client.field_1772, 90);
                int color = selectedTabs[i] ? -1 : (hoveredTabs[i] ? -3355444 : -7829368);
                ctx.method_25303(client.field_1772, text, tabX + (100 - client.field_1772.method_1727(text)) / 2, this.method_46427() + 6, color);
            }
            int y = this.method_46427() + 20 - 1;
            int startX = baseX;
            int endX = baseX + totalWidth;
            ctx.method_25292(startX, endX, y, MainColors.OUTLINE_WHITE.getRGB());
            ctx.method_25292(startX - 2, endX + 2, y + 1, MainColors.OUTLINE_BLACK.getRGB());
            int leftAlpha = selectedTabs[0] ? 255 : (hoveredTabs[0] ? 204 : 51);
            int rightAlpha = selectedTabs[tabCount - 1] ? 255 : (hoveredTabs[tabCount - 1] ? 204 : 51);
            ctx.method_25301(startX - 1, y + 1, y - 20, new Color(255, 255, 255, leftAlpha).getRGB());
            ctx.method_25301(startX - 2, y + 1, y - 20 - 1, new Color(0, 0, 0, 191).getRGB());
            if ((tabCount - 1) * 100 <= this.parent.field_22789) {
                ctx.method_25292(0, startX - 3, 27, new Color(0, 0, 0, 191).getRGB());
            }
            ctx.method_25301(endX + 1, y + 1, y - 20, new Color(255, 255, 255, rightAlpha).getRGB());
            ctx.method_25301(endX + 2, y + 1, y - 20 - 1, new Color(0, 0, 0, 191).getRGB());
            ctx.method_25292(this.method_25368(), endX + 3, 27, new Color(0, 0, 0, 191).getRGB());
            for (int i2 = 0; i2 < tabCount; ++i2) {
                int tabX2 = tabXs[i2];
                if (tabX2 + 100 < this.method_46426() || tabX2 > this.method_46426() + this.field_22758 || !selectedTabs[i2] && !hoveredTabs[i2]) continue;
                int fillRight = tabX2 + 100;
                if (i2 == tabCount - 1) {
                    ++fillRight;
                }
                ctx.method_25294(tabX2, this.method_46427() + 20 - 1, fillRight, this.method_46427() + 20, selectedTabs[i2] ? -1 : -3355444);
            }
            this.renderArrowIndicator(ctx);
            ctx.method_44380();
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        for (int i = 0; i < this.tabs.size(); ++i) {
            int tabX = (this.tabs.size() * 104 - 4 <= this.field_22758 ? this.method_46426() + (this.field_22758 - (this.tabs.size() * 104 - 4)) / 2 : this.method_46426() - (int)this.currentScrollOffset) + i * 104;
            if (!(mouseX >= (double)tabX) || !(mouseX <= (double)(tabX + 100)) || !(mouseY >= (double)this.method_46427()) || !(mouseY <= (double)(this.method_46427() + 20))) continue;
            if (this.tabManager.method_48614() != this.tabs.get(i)) {
                this.tabManager.method_48615((class_8087)this.tabs.get(i), false);
            }
            return true;
        }
        return false;
    }

    protected void method_47399(class_6382 builder) {
    }

    public void setTabs(List<CategoryTab> tabs) {
        this.tabs.clear();
        this.tabs.addAll(tabs);
    }

    public void selectTab(int index, boolean bl) {
        if (index >= 0 && index < this.tabs.size()) {
            this.tabManager.method_48615((class_8087)this.tabs.get(index), false);
        }
    }

    public MaxOffset getMaxOffsetDirection() {
        int totalWidth = this.tabs.size() * 104 - 4;
        if (totalWidth <= this.field_22758) {
            return null;
        }
        if (this.targetScrollOffset <= 0.0f) {
            return MaxOffset.LEFT;
        }
        if (this.targetScrollOffset >= (float)(totalWidth - this.field_22758)) {
            return MaxOffset.RIGHT;
        }
        return MaxOffset.MID;
    }

    public static enum MaxOffset {
        LEFT,
        RIGHT,
        MID;

    }
}

