/*
 * Decompiled with CFR 0.152.
 */
package main.walksy.lib.core.gui.widgets.sub;

import java.awt.Color;
import java.util.function.Consumer;
import main.walksy.lib.core.gui.widgets.sub.SubWidget;
import main.walksy.lib.core.gui.widgets.sub.adaptor.SliderAdapter;
import main.walksy.lib.core.renderer.Renderer2D;
import main.walksy.lib.core.utils.Animation;
import main.walksy.lib.core.utils.MainColors;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;

public class SliderSubWidget<T>
extends SubWidget {
    private float sliderPosition = 0.0f;
    private boolean dragging = false;
    public boolean isHovered = false;
    private final SliderAdapter<T> adapter;
    private T value;
    private Consumer<T> onChange;
    private final boolean isRight;
    private final Animation sliderPositionAnimation = new Animation(this.sliderPosition, 0.5f);

    public SliderSubWidget(int x, int y, int width, int height, SliderAdapter<T> adapter, T initialValue, Consumer<T> onChange, boolean right) {
        super(x, y, width, height);
        this.adapter = adapter;
        this.isRight = right;
        this.onChange = onChange;
        this.setValue(initialValue);
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float delta) {
        this.sliderPositionAnimation.update(delta);
        this.sliderPosition = this.sliderPositionAnimation.getCurrentValue();
        this.isHovered = mouseX >= this.x && mouseX <= this.x + this.width && mouseY >= this.y && mouseY <= this.y + this.height;
        Renderer2D.fillRoundedRect(context, this.x, this.y, this.width, this.height, 1, new Color(255, 255, 255, 20).getRGB());
        Renderer2D._fillRoundedRectOutline(context, this.x, this.y, this.width, this.height, 1, 1, MainColors.OUTLINE_BLACK.getRGB());
        int v = this.isHovered ? 220 : 155;
        Renderer2D.fillRoundedRect(context, (float)this.x + this.sliderPosition * (float)(this.width - 10), (float)this.y + (float)(this.height - 10) / 2.0f, 10.0f, 10.0f, 2, new Color(v, v, v, 255).getRGB());
        context.method_51433(class_310.method_1551().field_1772, this.adapter.format(this.value), this.isRight ? this.x + this.width + 3 : this.x - class_310.method_1551().field_1772.method_1727(this.adapter.format(this.adapter.getMax())) - 3, this.y + (this.height - 8) / 2, -1, false);
    }

    @Override
    public void onClick(int mouseX, int mouseY, int button) {
        if (this.isHovered) {
            this.dragging = true;
            this.onChange(mouseX);
        }
    }

    @Override
    public void onDrag(int mouseX) {
        if (this.dragging) {
            this.onChange(mouseX);
        }
    }

    private void onChange(int mouseX) {
        float targetSliderPosition = class_3532.method_15363((float)((float)(mouseX - this.x) / (float)this.width), (float)0.0f, (float)1.0f);
        this.sliderPositionAnimation.setTargetValue(targetSliderPosition);
        this.value = this.adapter.fromSliderPosition(targetSliderPosition);
        this.onChange.accept(this.value);
    }

    public void setValue(T value) {
        this.value = this.adapter.clamp(value);
        float targetSliderPosition = class_3532.method_15363((float)this.adapter.toSliderPosition(this.value), (float)0.0f, (float)1.0f);
        this.sliderPositionAnimation.setTargetValue(targetSliderPosition);
    }

    public T getValue() {
        return this.value;
    }

    public void release() {
        this.dragging = false;
    }

    public void setOnChange(Consumer<T> onChange) {
        this.onChange = onChange;
    }
}

