/*
 * Decompiled with CFR 0.152.
 */
package main.walksy.lib.core.gui.widgets.sub;

import java.awt.Color;
import java.util.Objects;
import java.util.function.Consumer;
import main.walksy.lib.core.gui.impl.WalksyLibConfigScreen;
import main.walksy.lib.core.gui.widgets.sub.SubWidget;
import main.walksy.lib.core.mixin.TextFieldWidgetAccessor;
import main.walksy.lib.core.renderer.Renderer2D;
import net.minecraft.class_1144;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_3532;

public class TextboxSubWidget
extends SubWidget {
    private final class_342 field;
    private final WalksyLibConfigScreen parent;
    public boolean hovered = false;
    private boolean centered;
    private int scrollWidth;

    public TextboxSubWidget(WalksyLibConfigScreen parent, int x, int y, int width, int scrollWidth, int height, String defaultV, Consumer<String> onChange, boolean centered) {
        super(x, y, width, height);
        this.parent = parent;
        this.scrollWidth = scrollWidth;
        this.field = new class_342(class_310.method_1551().field_1772, x, y, width, height, class_2561.method_30163((String)defaultV));
        this.field.method_1863(onChange);
        this.field.method_1852(defaultV);
        this.field.field_22763 = true;
        this.centered = centered;
    }

    public int getScrollOffset() {
        class_327 tr = class_310.method_1551().field_1772;
        int textWidth = tr.method_1727(this.field.method_1882());
        return Math.max(0, textWidth - this.scrollWidth);
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float delta) {
        if (!this.field.method_1885()) {
            return;
        }
        this.hovered = mouseX >= this.x && mouseX <= this.x + this.width && mouseY >= this.y && mouseY <= this.y + this.height;
        int color = this.hovered || this.field.method_25370() ? -1 : new Color(255, 255, 255, 180).getRGB();
        class_327 tr = class_310.method_1551().field_1772;
        String text = this.field.method_1882();
        int scrollOffset = this.getScrollOffset();
        if (text.isEmpty() && !this.field.method_25370()) {
            Objects.requireNonNull(tr);
            context.method_25303(tr, "...", this.x + 3, this.y + 1 + 9 / 2, color);
        }
        if (this.field.method_25370() && this.parent.tickCount % 20 < 10) {
            TextFieldWidgetAccessor accessor = (TextFieldWidgetAccessor)this.field;
            int cursor = class_3532.method_15340((int)(this.field.method_1881() - accessor.getFirstCharacterIndex()), (int)0, (int)text.length());
            String visible = class_310.method_1551().field_1772.method_27523(text.substring(accessor.getFirstCharacterIndex()), this.field.method_1859());
            int caretX = this.x + 4 + class_310.method_1551().field_1772.method_1727(visible.substring(0, class_3532.method_15340((int)cursor, (int)0, (int)visible.length()))) - 1 - scrollOffset;
            float f = caretX;
            Objects.requireNonNull(tr);
            float f2 = this.y + 9 / 2 - 1;
            Objects.requireNonNull(tr);
            Renderer2D.drawVerticalLine(context, f, f2, this.y + 9 + 5, -1);
        }
        if (this.centered) {
            String trimmed = tr.method_27523(text, this.field.method_1859());
            int n = this.x + this.width / 2 - tr.method_1727(trimmed) / 2;
            Objects.requireNonNull(tr);
            context.method_25303(tr, trimmed, n, this.y + 1 + 9 / 2, color);
        } else {
            Objects.requireNonNull(tr);
            context.method_25303(tr, text, this.x + 3 - scrollOffset, this.y + 1 + 9 / 2, color);
        }
        int textX = this.x + 4 - scrollOffset;
        Objects.requireNonNull(tr);
        int textY = this.y + 1 + 9 / 2;
        int firstCharIndex = ((TextFieldWidgetAccessor)this.field).getFirstCharacterIndex();
        String visibleText = tr.method_27523(text.substring(firstCharIndex), this.field.method_1859());
        int selectionStart = class_3532.method_15340((int)((TextFieldWidgetAccessor)this.field).getSelectionStart(), (int)0, (int)text.length());
        int selectionEnd = class_3532.method_15340((int)((TextFieldWidgetAccessor)this.field).getSelectionEnd(), (int)0, (int)text.length());
        int visibleSelectionStart = class_3532.method_15340((int)(selectionStart - firstCharIndex), (int)0, (int)visibleText.length());
        int visibleSelectionEnd = class_3532.method_15340((int)(selectionEnd - firstCharIndex), (int)0, (int)visibleText.length());
        if (visibleSelectionStart != visibleSelectionEnd) {
            int highlightStartX = textX + tr.method_1727(visibleText.substring(0, visibleSelectionStart));
            int highlightEndX = textX + tr.method_1727(visibleText.substring(0, visibleSelectionEnd));
            this.drawSelectionHighlight(context, highlightStartX - 1, textY - 1, highlightEndX - 1, textY + 9);
        }
    }

    @Override
    public void onClick(int mouseX, int mouseY, int button) {
        if (this.hovered) {
            this.field.method_25348((double)mouseX, (double)mouseY);
            this.field.method_1872(false);
            this.setFocus(true);
            class_339.method_62888((class_1144)class_310.method_1551().method_1483());
        } else {
            this.setFocus(false);
        }
    }

    @Override
    public void onDrag(int mouseX) {
    }

    @Override
    public void onKeyPress(int keyCode, int scanCode, int modifiers) {
        this.field.method_25404(keyCode, scanCode, modifiers);
        super.onKeyPress(keyCode, scanCode, modifiers);
    }

    @Override
    public void onCharTyped(char chr, int modifiers) {
        this.field.method_25400(chr, modifiers);
        super.onCharTyped(chr, modifiers);
    }

    public void setFocus(boolean focus) {
        this.field.method_25365(focus);
    }

    public boolean isFocused() {
        return this.field.method_25370();
    }

    public String getText() {
        return this.field.method_1882();
    }

    public void setText(String text) {
        this.field.method_1852(text);
    }

    private void drawSelectionHighlight(class_332 context, int x1, int y1, int x2, int y2) {
        int i;
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
        }
        if (x2 > this.x + this.width) {
            x2 = this.x + this.width;
        }
        if (x1 > this.x + this.width) {
            x1 = this.x + this.width;
        }
        context.method_51739(class_1921.method_51786(), x1, y1, x2, y2, -16776961);
    }
}

