/*
 * Decompiled with CFR 0.152.
 */
package main.walksy.lib.core.gui.widgets.sub.adaptor;

import main.walksy.lib.core.gui.widgets.sub.adaptor.SliderAdapter;

public class DoubleSliderAdapter
implements SliderAdapter<Double> {
    private final double min;
    private final double max;
    private final double def;

    public DoubleSliderAdapter(double min, double max, double def) {
        this.min = min;
        this.max = max;
        this.def = def;
    }

    @Override
    public float toSliderPosition(Double value) {
        return (float)((value - this.min) / (this.max - this.min));
    }

    @Override
    public Double fromSliderPosition(float sliderPos) {
        return this.min + (double)sliderPos * (this.max - this.min);
    }

    @Override
    public Double clamp(Double value) {
        return Math.max(this.min, Math.min(this.max, value));
    }

    @Override
    public String format(Double value) {
        return String.format("%.1f", value);
    }

    @Override
    public Double defaultValue() {
        return this.def;
    }

    @Override
    public Double getMin() {
        return this.min;
    }

    @Override
    public Double getMax() {
        return this.max;
    }
}

