/*
 * Decompiled with CFR 0.152.
 */
package main.walksy.lib.core.gui.widgets.sub.adaptor;

import main.walksy.lib.core.gui.widgets.sub.adaptor.SliderAdapter;

public class FloatSliderAdapter
implements SliderAdapter<Float> {
    private final float min;
    private final float max;
    private final float def;

    public FloatSliderAdapter(float min, float max, float def) {
        this.min = min;
        this.max = max;
        this.def = def;
    }

    @Override
    public float toSliderPosition(Float value) {
        return (value.floatValue() - this.min) / (this.max - this.min);
    }

    @Override
    public Float fromSliderPosition(float sliderPos) {
        return Float.valueOf(this.min + sliderPos * (this.max - this.min));
    }

    @Override
    public Float clamp(Float value) {
        return Float.valueOf(Math.max(this.min, Math.min(this.max, value.floatValue())));
    }

    @Override
    public String format(Float value) {
        return String.format("%.1f", value);
    }

    @Override
    public Float defaultValue() {
        return Float.valueOf(this.def);
    }

    @Override
    public Float getMin() {
        return Float.valueOf(this.min);
    }

    @Override
    public Float getMax() {
        return Float.valueOf(this.max);
    }
}

