/*
 * Decompiled with CFR 0.152.
 */
package main.walksy.lib.core.gui.widgets.sub.adaptor;

import main.walksy.lib.core.gui.widgets.sub.adaptor.SliderAdapter;

public class IntSliderAdapter
implements SliderAdapter<Integer> {
    private final int min;
    private final int max;
    private final int def;

    public IntSliderAdapter(int min, int max, int def) {
        this.min = min;
        this.max = max;
        this.def = def;
    }

    @Override
    public float toSliderPosition(Integer value) {
        return (float)(value - this.min) / (float)(this.max - this.min);
    }

    @Override
    public Integer fromSliderPosition(float sliderPos) {
        return this.min + Math.round(sliderPos * (float)(this.max - this.min));
    }

    @Override
    public Integer clamp(Integer value) {
        return Math.max(this.min, Math.min(this.max, value));
    }

    @Override
    public String format(Integer value) {
        return Integer.toString(value);
    }

    @Override
    public Integer defaultValue() {
        return this.def;
    }

    @Override
    public Integer getMin() {
        return this.min;
    }

    @Override
    public Integer getMax() {
        return this.max;
    }
}

