/*
 * Decompiled with CFR 0.152.
 */
package main.walksy.lib.core.manager;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import main.walksy.lib.core.config.impl.LocalConfig;
import main.walksy.lib.core.config.local.Category;
import main.walksy.lib.core.config.local.Option;
import main.walksy.lib.core.config.local.options.groups.OptionGroup;
import main.walksy.lib.core.config.local.options.type.PixelGrid;
import main.walksy.lib.core.config.local.options.type.PixelGridAnimation;
import main.walksy.lib.core.config.local.options.type.WalksyLibColor;
import main.walksy.lib.core.config.serialization.OptionConverter;
import main.walksy.lib.core.config.serialization.SerializableCategory;
import main.walksy.lib.core.config.serialization.SerializableGroup;
import main.walksy.lib.core.config.serialization.SerializableOption;
import main.walksy.lib.core.config.serialization.adapters.ColorTypeAdapter;
import main.walksy.lib.core.config.serialization.adapters.IdentifierWrapperAdapter;
import main.walksy.lib.core.config.serialization.adapters.PixelGridAdapter;
import main.walksy.lib.core.config.serialization.adapters.PixelGridAnimationAdapter;
import main.walksy.lib.core.utils.IdentifierWrapper;
import main.walksy.lib.core.utils.log.WalksyLibLogger;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class WalksyLibConfigManager {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(WalksyLibColor.class, (Object)new ColorTypeAdapter()).registerTypeAdapter(PixelGrid.class, (Object)new PixelGridAdapter()).registerTypeAdapter(PixelGridAnimation.class, (Object)new PixelGridAnimationAdapter()).registerTypeAdapter(IdentifierWrapper.class, (Object)new IdentifierWrapperAdapter()).serializeNulls().setPrettyPrinting().create();
    private final LocalConfig localConfig;

    public WalksyLibConfigManager(LocalConfig localConfig) {
        this.localConfig = localConfig;
    }

    public LocalConfig get() {
        return this.localConfig;
    }

    public void cleanCache() {
        Path cacheDir = WalksyLibConfigManager.getCachedImageDir();
        if (!Files.exists(cacheDir, new LinkOption[0])) {
            return;
        }
        ArrayList<String> usedFiles = new ArrayList<String>();
        for (Category category : this.localConfig.categories()) {
            for (Option<?> option : category.options()) {
                IdentifierWrapper wrapper;
                String fileName;
                Object value = option.getValue();
                if (!(value instanceof IdentifierWrapper) || (fileName = (wrapper = (IdentifierWrapper)value).getFileName()) == null || fileName.isEmpty()) continue;
                usedFiles.add(fileName);
            }
            for (OptionGroup group : category.optionGroups()) {
                for (Option<?> option : group.getOptions()) {
                    IdentifierWrapper wrapper;
                    String fileName;
                    Object value = option.getValue();
                    if (!(value instanceof IdentifierWrapper) || (fileName = (wrapper = (IdentifierWrapper)value).getFileName()) == null || fileName.isEmpty()) continue;
                    usedFiles.add(fileName);
                }
            }
        }
        try {
            Files.list(cacheDir).forEach(path -> {
                String fileName = path.getFileName().toString();
                if (!usedFiles.contains(fileName)) {
                    try {
                        Files.delete(path);
                    }
                    catch (IOException e) {
                        WalksyLibLogger.err("Failed to delete unused cached image: " + fileName);
                    }
                }
            });
        }
        catch (IOException e) {
            WalksyLibLogger.err("Failed to list cache directory: " + e.getMessage());
        }
    }

    public static SerializableCategory serializeCategory(Category category) {
        SerializableCategory serialized = new SerializableCategory();
        serialized.name = category.name();
        serialized.options = new ArrayList<SerializableOption>();
        serialized.groups = new ArrayList<SerializableGroup>();
        for (Option<?> option : category.options()) {
            if (option.getType() == Runnable.class) continue;
            serialized.options.add(OptionConverter.fromOption(option));
        }
        for (OptionGroup group : category.optionGroups()) {
            SerializableGroup serializedGroup = new SerializableGroup();
            serializedGroup.name = group.getName();
            serializedGroup.expanded = group.isExpanded();
            serializedGroup.options = new ArrayList<SerializableOption>();
            for (Option<?> option : group.getOptions()) {
                if (option.getType() == Runnable.class) continue;
                serializedGroup.options.add(OptionConverter.fromOption(option));
            }
            serialized.groups.add(serializedGroup);
        }
        return serialized;
    }

    public static void applyCategoryValues(Category category, SerializableCategory serializedCategory) {
        for (Option<?> option2 : category.options()) {
            class_2960 identifier;
            IdentifierWrapper wrapper;
            String fileName;
            serializedCategory.options.stream().filter(serialized -> serialized.name.equals(option2.getName())).findFirst().ifPresent(serialized -> WalksyLibConfigManager.applyOptionValues(option2, serialized));
            Object value = option2.getValue();
            if (!(value instanceof IdentifierWrapper) || (fileName = (wrapper = (IdentifierWrapper)value).getFileName()) == null || fileName.isEmpty() || (identifier = WalksyLibConfigManager.loadTextureFromCache(fileName)) == null) continue;
            wrapper.setIdentifier(identifier);
        }
        for (OptionGroup group : category.optionGroups()) {
            serializedCategory.groups.stream().filter(serialized -> serialized.name.equals(group.getName())).findFirst().ifPresent(serializedGroup -> {
                group.setExpanded(serializedGroup.expanded);
                for (Option<?> option : group.getOptions()) {
                    serializedGroup.options.stream().filter(serialized -> serialized.name.equals(option.getName())).findFirst().ifPresent(serialized -> WalksyLibConfigManager.applyOptionValues(option, serialized));
                }
            });
            group.getOptions().forEach(option -> {
                class_2960 identifier;
                IdentifierWrapper wrapper;
                String fileName;
                Object value = option.getValue();
                if (value instanceof IdentifierWrapper && (fileName = (wrapper = (IdentifierWrapper)value).getFileName()) != null && !fileName.isEmpty() && (identifier = WalksyLibConfigManager.loadTextureFromCache(fileName)) != null) {
                    wrapper.setIdentifier(identifier);
                }
            });
        }
    }

    public static void applyOptionValues(Option<?> option, SerializableOption serialized) {
        try {
            OptionConverter.setOptionValue(option, serialized.value);
        }
        catch (Exception e) {
            System.err.println("Failed to set value for option '" + option.getName() + "': " + e.getMessage());
            return;
        }
    }

    public static Path getCachedImageDir() {
        Path configDir = FabricLoader.getInstance().getConfigDir();
        Path destDir = configDir.resolve("WalksyLib").resolve("CachedImages");
        try {
            Files.createDirectories(destDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            System.err.println("Failed to create cached image directory: " + e.getMessage());
        }
        return destDir;
    }

    public static class_2960 loadTextureFromCache(String fileName) {
        class_2960 class_29602;
        block10: {
            Path imagePath = WalksyLibConfigManager.getCachedImageDir().resolve(fileName);
            if (!Files.exists(imagePath, new LinkOption[0])) {
                return null;
            }
            InputStream stream = Files.newInputStream(imagePath, new OpenOption[0]);
            try {
                class_1011 image = class_1011.method_4309((InputStream)stream);
                class_1043 texture = new class_1043(image);
                String name = fileName;
                int dotIndex = name.lastIndexOf(46);
                if (dotIndex > 0) {
                    name = name.substring(0, dotIndex);
                }
                name = name.toLowerCase().replaceAll("[^a-z0-9._-]", "_");
                String dynamicId = "dropped/" + name;
                class_2960 textureId = class_2960.method_60655((String)"walksylib", (String)dynamicId);
                class_310.method_1551().method_1531().method_4616(textureId, (class_1044)texture);
                class_29602 = textureId;
                if (stream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            stream.close();
        }
        return class_29602;
    }
}

