/*
 * Decompiled with CFR 0.152.
 */
package main.walksy.lib.core.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.function.Function;
import main.walksy.lib.core.config.local.options.type.PixelGrid;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_1921;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public class Renderer2D {
    public static void drawRoundedTexture(class_332 ctx, Function<class_2960, class_1921> renderLayers, class_2960 sprite, int x, int y, int width, int height, int radius, int textureWidth, int textureHeight) {
        for (int dy = 0; dy < height; ++dy) {
            for (int dx = 0; dx < width; ++dx) {
                boolean skip = false;
                if (dx < radius && dy < radius && Math.pow(radius - dx, 2.0) + Math.pow(radius - dy, 2.0) > (double)(radius * radius)) {
                    skip = true;
                }
                if (dx >= width - radius && dy < radius && Math.pow(dx - (width - radius - 1), 2.0) + Math.pow(radius - dy, 2.0) > (double)(radius * radius)) {
                    skip = true;
                }
                if (dx < radius && dy >= height - radius && Math.pow(radius - dx, 2.0) + Math.pow(dy - (height - radius - 1), 2.0) > (double)(radius * radius)) {
                    skip = true;
                }
                if (dx >= width - radius && dy >= height - radius && Math.pow(dx - (width - radius - 1), 2.0) + Math.pow(dy - (height - radius - 1), 2.0) > (double)(radius * radius)) {
                    skip = true;
                }
                if (skip) continue;
                int u = dx % textureWidth;
                int v = dy % textureHeight;
                ctx.method_25290(renderLayers, sprite, x + dx, y + dy, (float)u, (float)v, 1, 1, textureWidth, textureHeight);
            }
        }
    }

    public static void renderMiniArrow(class_332 context, float x, float y, float scale, ArrowDirection direction, int color) {
        int[][] lines;
        block6: for (int[] line : lines = new int[][]{{-3, 0, 3, 1}, {-2, 1, 2, 2}, {-1, 2, 1, 3}}) {
            float x1 = (float)line[0] * scale;
            float y1 = (float)line[1] * scale;
            float x2 = (float)line[2] * scale;
            float y2 = (float)line[3] * scale;
            switch (direction.ordinal()) {
                case 0: {
                    context.method_25294((int)(x + x1), (int)(y - y2), (int)(x + x2), (int)(y - y1), color);
                    continue block6;
                }
                case 1: {
                    context.method_25294((int)(x + x1), (int)(y + y1), (int)(x + x2), (int)(y + y2), color);
                    continue block6;
                }
                case 2: {
                    context.method_25294((int)(x - y2), (int)(y + x1), (int)(x - y1), (int)(y + x2), color);
                    continue block6;
                }
                case 3: {
                    context.method_25294((int)(x + y1), (int)(y + x1), (int)(x + y2), (int)(y + x2), color);
                }
            }
        }
    }

    public static void drawVerticalLine(class_332 context, float x, float y1, float y2, int color) {
        if (y2 < y1) {
            float i = y1;
            y1 = y2;
            y2 = i;
        }
        Renderer2D.fill(context.method_51448(), x, y1 + 1.0f, (float)((double)x + 0.8), y2, color);
    }

    private static void fillArrowLine(class_332 context, int centerX, int topY, int width) {
        int half = width / 2;
        context.method_25294(centerX - half, topY, centerX + half, topY + 2, -1);
    }

    public static void fillRoundedRectGradient(class_332 ctx, int x, int y, int width, int height, int radius, int colorTop, int colorBottom) {
        int right = x + width;
        int bottom = y + height;
        Function<Float, Integer> lerpColor = t -> {
            int aTop = colorTop >> 24 & 0xFF;
            int rTop = colorTop >> 16 & 0xFF;
            int gTop = colorTop >> 8 & 0xFF;
            int bTop = colorTop & 0xFF;
            int aBot = colorBottom >> 24 & 0xFF;
            int rBot = colorBottom >> 16 & 0xFF;
            int gBot = colorBottom >> 8 & 0xFF;
            int bBot = colorBottom & 0xFF;
            int a = (int)((float)aTop + t.floatValue() * (float)(aBot - aTop));
            int r = (int)((float)rTop + t.floatValue() * (float)(rBot - rTop));
            int g = (int)((float)gTop + t.floatValue() * (float)(gBot - gTop));
            int b = (int)((float)bTop + t.floatValue() * (float)(bBot - bTop));
            return a << 24 | r << 16 | g << 8 | b;
        };
        for (int currentY = y; currentY < bottom; ++currentY) {
            int offsetX;
            int dy;
            float t2 = (float)(currentY - y) / (float)(height - 1);
            int color = lerpColor.apply(Float.valueOf(t2));
            int leftX = x;
            int rightX = right - 1;
            if (currentY < y + radius) {
                dy = y + radius - currentY;
                offsetX = (int)Math.sqrt(radius * radius - dy * dy);
                leftX = x + radius - offsetX;
            } else if (currentY >= bottom - radius) {
                dy = currentY - (bottom - radius - 1);
                offsetX = (int)Math.sqrt(radius * radius - dy * dy);
                leftX = x + radius - offsetX;
            }
            if (currentY < y + radius) {
                dy = y + radius - currentY;
                offsetX = (int)Math.sqrt(radius * radius - dy * dy);
                rightX = right - radius + offsetX - 1;
            } else if (currentY >= bottom - radius) {
                dy = currentY - (bottom - radius - 1);
                offsetX = (int)Math.sqrt(radius * radius - dy * dy);
                rightX = right - radius + offsetX - 1;
            }
            if (rightX < leftX) continue;
            ctx.method_25294(leftX, currentY, rightX + 1, currentY + 1, color);
        }
    }

    public static void fillRoundedRect(class_332 ctx, float x, float y, float width, float height, int radius, int color) {
        float right = x + width;
        float bottom = y + height;
        class_4587 stack = ctx.method_51448();
        Renderer2D.fill(stack, x + (float)radius + 1.0f, y, right - (float)radius - 1.0f, y + (float)radius, color);
        Renderer2D.fill(stack, x + (float)radius + 1.0f, bottom - (float)radius, right - (float)radius - 1.0f, bottom, color);
        Renderer2D.fill(stack, x, y + (float)radius + 1.0f, x + (float)radius, bottom - (float)radius - 1.0f, color);
        Renderer2D.fill(stack, right - (float)radius, y + (float)radius + 1.0f, right, bottom - (float)radius - 1.0f, color);
        Renderer2D.fill(stack, x + (float)radius + 1.0f, y + (float)radius, right - (float)radius - 1.0f, bottom - (float)radius, color);
        Renderer2D.fill(stack, x + (float)radius, y + (float)radius + 1.0f, x + (float)radius + 1.0f, bottom - (float)radius - 1.0f, color);
        Renderer2D.fill(stack, right - (float)radius - 1.0f, y + (float)radius + 1.0f, right - (float)radius, bottom - (float)radius - 1.0f, color);
        Renderer2D.fillCircleQuarter(ctx, x + (float)radius, y + (float)radius, radius, color, Corner.TOP_LEFT);
        Renderer2D.fillCircleQuarter(ctx, right - (float)radius - 1.0f, y + (float)radius, radius, color, Corner.TOP_RIGHT);
        Renderer2D.fillCircleQuarter(ctx, x + (float)radius, bottom - (float)radius - 1.0f, radius, color, Corner.BOTTOM_LEFT);
        Renderer2D.fillCircleQuarter(ctx, right - (float)radius - 1.0f, bottom - (float)radius - 1.0f, radius, color, Corner.BOTTOM_RIGHT);
    }

    public static void fillRoundedRectOutline(class_332 ctx, int x, int y, int width, int height, int radius, int thickness, int color) {
        int right = x + width;
        int bottom = y + height;
        ctx.method_25294(x + radius + 1, y, right - radius - 1, y + thickness, color);
        ctx.method_25294(x + radius + 1, bottom - thickness, right - radius - 1, bottom, color);
        ctx.method_25294(x, y + radius + 1, x + thickness, bottom - radius - 1, color);
        ctx.method_25294(right - thickness, y + radius + 1, right, bottom - radius - 1, color);
        Renderer2D.drawCircleQuarterOutline(ctx, x + radius, y + radius, radius, thickness, color, Corner.TOP_LEFT);
        Renderer2D.drawCircleQuarterOutline(ctx, right - radius - 1, y + radius, radius, thickness, color, Corner.TOP_RIGHT);
        Renderer2D.drawCircleQuarterOutline(ctx, x + radius, bottom - radius - 1, radius, thickness, color, Corner.BOTTOM_LEFT);
        Renderer2D.drawCircleQuarterOutline(ctx, right - radius - 1, bottom - radius - 1, radius, thickness, color, Corner.BOTTOM_RIGHT);
    }

    public static void _fillRoundedRectOutline(class_332 ctx, int x, int y, int width, int height, int radius, int thickness, int color) {
        int right = x + width;
        int bottom = y + height;
        Renderer2D.fill(ctx.method_51448(), x + radius + 1, y, right - radius - 1, y + thickness, color);
        Renderer2D.fill(ctx.method_51448(), x + radius + 1, bottom - thickness, right - radius - 1, bottom, color);
        Renderer2D.fill(ctx.method_51448(), x, y + radius + 1, x + thickness, bottom - radius - 1, color);
        Renderer2D.fill(ctx.method_51448(), right - thickness, y + radius + 1, right, bottom - radius - 1, color);
        Renderer2D._drawCircleQuarterOutline(ctx, x + radius, y + radius, radius, thickness, color, Corner.TOP_LEFT);
        Renderer2D._drawCircleQuarterOutline(ctx, right - radius - 1, y + radius, radius, thickness, color, Corner.TOP_RIGHT);
        Renderer2D._drawCircleQuarterOutline(ctx, x + radius, bottom - radius - 1, radius, thickness, color, Corner.BOTTOM_LEFT);
        Renderer2D._drawCircleQuarterOutline(ctx, right - radius - 1, bottom - radius - 1, radius, thickness, color, Corner.BOTTOM_RIGHT);
    }

    public static void fillRoundedRectOutline_ModWidget(class_332 ctx, int x, int y, int width, int height, int radius, int thickness, int color) {
        int right = x + width;
        int bottom = y + height;
        ctx.method_25294(x + 1, y, right - radius - 1, y + thickness, color);
        ctx.method_25294(x + 1, bottom - thickness, right - radius - 1, bottom, color);
        ctx.method_25294(x, y, x + thickness, bottom, color);
        ctx.method_25294(right - thickness, y + radius + 1, right, bottom - radius - 1, color);
        Renderer2D.drawCircleQuarterOutline(ctx, right - radius - 1, y + radius, radius, thickness, color, Corner.TOP_RIGHT);
        Renderer2D.drawCircleQuarterOutline(ctx, right - radius - 1, bottom - radius - 1, radius, thickness, color, Corner.BOTTOM_RIGHT);
    }

    public static void drawHueSaturationValueBox(class_332 ctx, int x, int y, int width, int height, int radius, float hue) {
        class_4597.class_4598 immediate = class_310.method_1551().method_22940().method_23000();
        class_4588 vertices = immediate.getBuffer(class_1921.method_51784());
        int x0 = x;
        int y0 = y;
        int x1 = x + width;
        int y1 = y + height;
        if (width <= 0 || height <= 0) {
            return;
        }
        int steps = Math.max(2, height);
        for (int i = 0; i < steps; ++i) {
            float t0 = (float)i / (float)steps;
            float t1 = (float)(i + 1) / (float)steps;
            float value0 = 1.0f - t0;
            float value1 = 1.0f - t1;
            int leftColor0 = Color.HSBtoRGB(hue, 0.0f, value0) | 0xFF000000;
            int rightColor0 = Color.HSBtoRGB(hue, 1.0f, value0) | 0xFF000000;
            int leftColor1 = Color.HSBtoRGB(hue, 0.0f, value1) | 0xFF000000;
            int rightColor1 = Color.HSBtoRGB(hue, 1.0f, value1) | 0xFF000000;
            float yStart = (float)y0 + t0 * (float)height;
            float yEnd = (float)y0 + t1 * (float)height;
            int dy0 = (int)(yStart - (float)y0);
            int dy1 = (int)(yEnd - (float)y0);
            int leftX0 = x0;
            int rightX0 = x1 - 1;
            int leftX1 = x0;
            int rightX1 = x1 - 1;
            if (radius > 0) {
                int offsetX;
                int dd;
                if (dy0 < radius) {
                    dd = radius - dy0;
                    offsetX = (int)Math.sqrt((double)radius * (double)radius - (double)dd * (double)dd);
                    leftX0 = x0 + radius - offsetX;
                    rightX0 = x1 - radius + offsetX - 1;
                } else if (dy0 >= height - radius) {
                    dd = dy0 - (height - radius - 1);
                    offsetX = (int)Math.sqrt((double)radius * (double)radius - (double)dd * (double)dd);
                    leftX0 = x0 + radius - offsetX;
                    rightX0 = x1 - radius + offsetX - 1;
                }
                if (dy1 < radius) {
                    dd = radius - dy1;
                    offsetX = (int)Math.sqrt((double)radius * (double)radius - (double)dd * (double)dd);
                    leftX1 = x0 + radius - offsetX;
                    rightX1 = x1 - radius + offsetX - 1;
                } else if (dy1 >= height - radius) {
                    dd = dy1 - (height - radius - 1);
                    offsetX = (int)Math.sqrt((double)radius * (double)radius - (double)dd * (double)dd);
                    leftX1 = x0 + radius - offsetX;
                    rightX1 = x1 - radius + offsetX - 1;
                }
            }
            int leftX = Math.max(leftX0, leftX1);
            int rightX = Math.min(rightX0, rightX1);
            if (rightX <= leftX) continue;
            float px0 = leftX;
            float px1 = rightX + 1;
            vertices.method_22912(px0, yStart, 0.0f).method_39415(leftColor0);
            vertices.method_22912(px0, yEnd, 0.0f).method_39415(leftColor1);
            vertices.method_22912(px1, yEnd, 0.0f).method_39415(rightColor1);
            vertices.method_22912(px1, yStart, 0.0f).method_39415(rightColor0);
        }
        immediate.method_22993();
    }

    public static void drawRoundedHueSlider(class_332 ctx, int x, int y, int width, int height, int radius) {
        int dy;
        int right = x + width;
        int bottom = y + height;
        for (dy = radius; dy < height - radius; ++dy) {
            float hue = 1.0f - (float)dy / (float)(height - 1);
            int color = Color.HSBtoRGB(hue, 1.0f, 1.0f);
            ctx.method_25294(x, y + dy, right, y + dy + 1, color);
        }
        for (dy = 0; dy < radius; ++dy) {
            float hueTop = 1.0f - (float)dy / (float)(height - 1);
            float hueBottom = 1.0f - (float)(height - 1 - dy) / (float)(height - 1);
            int colorTop = Color.HSBtoRGB(hueTop, 1.0f, 1.0f);
            int colorBottom = Color.HSBtoRGB(hueBottom, 1.0f, 1.0f);
            ctx.method_25294(x + radius, y + dy, right - radius, y + dy + 1, colorTop);
            ctx.method_25294(x + radius, bottom - radius + dy, right - radius, bottom - radius + dy + 1, colorBottom);
        }
        int red = Color.HSBtoRGB(0.0f, 1.0f, 1.0f);
        Renderer2D.fillCircleQuarter(ctx, x + radius, y + radius, radius, red, Corner.TOP_LEFT);
        Renderer2D.fillCircleQuarter(ctx, right - radius - 1, y + radius, radius, red, Corner.TOP_RIGHT);
        Renderer2D.fillCircleQuarter(ctx, x + radius, bottom - radius - 1, radius, red, Corner.BOTTOM_LEFT);
        Renderer2D.fillCircleQuarter(ctx, right - radius - 1, bottom - radius - 1, radius, red, Corner.BOTTOM_RIGHT);
    }

    public static void fillPixelCircle(class_332 ctx, int centerX, int centerY, int radius, int color) {
        int x = radius;
        int err = 0;
        for (int y = 0; x >= y; ++y) {
            ctx.method_25292(centerX - x, centerX + x, centerY + y, color);
            ctx.method_25292(centerX - x, centerX + x, centerY - y, color);
            ctx.method_25292(centerX - y, centerX + y, centerY + x, color);
            ctx.method_25292(centerX - y, centerX + y, centerY - x, color);
            if (err <= 0) {
                err += 2 * y + 1;
                continue;
            }
            err += 2 * (y - --x + 1);
        }
    }

    private static void fillCircleQuarter(class_332 ctx, float centerX, float centerY, int radius, int color, Corner corner) {
        for (int y = 0; y <= radius; ++y) {
            block7: for (int x = 0; x <= radius; ++x) {
                if (x * x + y * y > radius * radius) continue;
                float drawX = centerX;
                float drawY = centerY;
                class_4587 stack = ctx.method_51448();
                switch (corner.ordinal()) {
                    case 0: {
                        Renderer2D.fill(stack, drawX - (float)x, drawY - (float)y, drawX - (float)x + 1.0f, drawY - (float)y + 1.0f, color);
                        continue block7;
                    }
                    case 1: {
                        Renderer2D.fill(stack, drawX + (float)x, drawY - (float)y, drawX + (float)x + 1.0f, drawY - (float)y + 1.0f, color);
                        continue block7;
                    }
                    case 2: {
                        Renderer2D.fill(stack, drawX - (float)x, drawY + (float)y, drawX - (float)x + 1.0f, drawY + (float)y + 1.0f, color);
                        continue block7;
                    }
                    case 3: {
                        Renderer2D.fill(stack, drawX + (float)x, drawY + (float)y, drawX + (float)x + 1.0f, drawY + (float)y + 1.0f, color);
                    }
                }
            }
        }
    }

    private static void drawCircleQuarterOutline(class_332 ctx, int centerX, int centerY, int radius, int thickness, int color, Corner corner) {
        int outerRadiusSq = radius * radius;
        int innerRadiusSq = (radius - thickness) * (radius - thickness);
        for (int y = 0; y <= radius; ++y) {
            block7: for (int x = 0; x <= radius; ++x) {
                int distSq = x * x + y * y;
                if (distSq > outerRadiusSq || distSq < innerRadiusSq) continue;
                int drawX = centerX;
                int drawY = centerY;
                switch (corner.ordinal()) {
                    case 0: {
                        ctx.method_25294(drawX - x, drawY - y, drawX - x + 1, drawY - y + 1, color);
                        continue block7;
                    }
                    case 1: {
                        ctx.method_25294(drawX + x, drawY - y, drawX + x + 1, drawY - y + 1, color);
                        continue block7;
                    }
                    case 2: {
                        ctx.method_25294(drawX - x, drawY + y, drawX - x + 1, drawY + y + 1, color);
                        continue block7;
                    }
                    case 3: {
                        ctx.method_25294(drawX + x, drawY + y, drawX + x + 1, drawY + y + 1, color);
                    }
                }
            }
        }
    }

    private static void _drawCircleQuarterOutline(class_332 ctx, int centerX, int centerY, int radius, int thickness, int color, Corner corner) {
        int outerRadiusSq = radius * radius;
        int innerRadiusSq = (radius - thickness) * (radius - thickness);
        for (int y = 0; y <= radius; ++y) {
            block7: for (int x = 0; x <= radius; ++x) {
                int distSq = x * x + y * y;
                if (distSq > outerRadiusSq || distSq < innerRadiusSq) continue;
                int drawX = centerX;
                int drawY = centerY;
                switch (corner.ordinal()) {
                    case 0: {
                        Renderer2D.fill(ctx.method_51448(), drawX - x, drawY - y, drawX - x + 1, drawY - y + 1, color);
                        continue block7;
                    }
                    case 1: {
                        Renderer2D.fill(ctx.method_51448(), drawX + x, drawY - y, drawX + x + 1, drawY - y + 1, color);
                        continue block7;
                    }
                    case 2: {
                        Renderer2D.fill(ctx.method_51448(), drawX - x, drawY + y, drawX - x + 1, drawY + y + 1, color);
                        continue block7;
                    }
                    case 3: {
                        Renderer2D.fill(ctx.method_51448(), drawX + x, drawY + y, drawX + x + 1, drawY + y + 1, color);
                    }
                }
            }
        }
    }

    public static void renderGridTexture(class_332 context, PixelGrid grid, float x1, float y1, int pixelSize, int gapSize, boolean blend) {
        for (int y = 0; y < grid.getHeight(); ++y) {
            for (int x = 0; x < grid.getWidth(); ++x) {
                boolean val = grid.getPixel(x, y);
                float px = x1 + (float)(x * (pixelSize + gapSize));
                float py = y1 + (float)(y * (pixelSize + gapSize));
                float px2 = px + (float)pixelSize;
                float py2 = py + (float)pixelSize;
                if (!val) continue;
                Renderer2D.drawFilledRectangle(context.method_51448(), px, py, px2, py2, Color.WHITE, blend);
            }
        }
    }

    public static void drawFilledRectangle(class_4587 stack, float x1, float y1, float x2, float y2, Color color, boolean blend) {
        stack.method_22903();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader((class_10156)class_10142.field_53876);
        if (blend) {
            RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.ONE_MINUS_DST_COLOR, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_COLOR, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
        }
        Renderer2D.setGlProperty(2848, false);
        class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27381, class_290.field_1576);
        Matrix4f matrix = stack.method_23760().method_23761();
        float[] pts = new float[]{x1, y1, x1, y2, x2, y2, x2, y1};
        for (int i = 0; i < pts.length; i += 2) {
            buffer.method_22918(matrix, pts[i], pts[i + 1], 0.0f).method_1336(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        }
        class_286.method_43433((class_9801)buffer.method_60800());
        RenderSystem.disableBlend();
        stack.method_22909();
    }

    private static void setGlProperty(int property, boolean isEnabled) {
        if (isEnabled) {
            GL11.glEnable((int)property);
        } else {
            GL11.glDisable((int)property);
        }
    }

    public static void renderGridOutline(class_332 context, PixelGrid grid, int x1, int y1, int pixelSize, int gapSize) {
        int gridWidthPixels = grid.getWidth() * pixelSize + (grid.getWidth() - 1) * gapSize;
        int gridHeightPixels = grid.getHeight() * pixelSize + (grid.getHeight() - 1) * gapSize;
        int x2 = x1 + gridWidthPixels;
        int y2 = y1 + gridHeightPixels;
        float borderWidth = 0.3f;
        int blue = new Color(0, 100, 255).getRGB();
        Renderer2D.fill(context.method_51448(), (float)x1 - borderWidth, (float)y1 - borderWidth, (float)x2 + borderWidth, y1, blue);
        Renderer2D.fill(context.method_51448(), (float)x1 - borderWidth, y2, (float)x2 + borderWidth, (float)y2 + borderWidth, blue);
        Renderer2D.fill(context.method_51448(), (float)x1 - borderWidth, y1, x1, y2, blue);
        Renderer2D.fill(context.method_51448(), x2, y1, (float)x2 + borderWidth, y2, blue);
    }

    public static void renderGridOutline(class_332 context, PixelGrid grid, int x1, int y1, int pixelSize, int gapSize, int outlineColor, boolean markCenter) {
        int py;
        int px;
        if (markCenter) {
            int centerX = grid.getWidth() / 2;
            int centerY = grid.getHeight() / 2;
            px = x1 + centerX * (pixelSize + gapSize);
            py = y1 + centerY * (pixelSize + gapSize);
            int centerColor = new Color(255, 100, 100, 100).getRGB();
            context.method_25294(px + 1, py + 1, px + pixelSize - 1, py + pixelSize - 1, centerColor);
        }
        for (int y = 0; y < grid.getHeight(); ++y) {
            for (int x = 0; x < grid.getWidth(); ++x) {
                px = x1 + x * (pixelSize + gapSize);
                py = y1 + y * (pixelSize + gapSize);
                boolean val = grid.getPixel(x, y);
                if (val) {
                    context.method_25294(px + 1, py + 1, px + pixelSize - 1, py + pixelSize - 1, Color.WHITE.getRGB());
                }
                context.method_25294(px + 1, py, px + pixelSize - 1, py + 1, outlineColor);
                context.method_25294(px + 1, py + pixelSize - 1, px + pixelSize - 1, py + pixelSize, outlineColor);
                context.method_25294(px, py, px + 1, py + pixelSize, outlineColor);
                context.method_25294(px + pixelSize - 1, py, px + pixelSize, py + pixelSize, outlineColor);
            }
        }
    }

    public static void startPopUpRender(class_332 context, int z, int width, int height) {
        context.method_51448().method_22903();
        context.method_51448().method_46416(0.0f, 0.0f, (float)z);
        context.method_25294(0, 0, width, height, new Color(0, 0, 0, 100).getRGB());
    }

    public static void endPopUpRender(class_332 context) {
        context.method_51448().method_22909();
    }

    public static void fill(class_4587 stack, float x1, float y1, float x2, float y2, int color) {
        float i;
        Matrix4f matrix4f = stack.method_23760().method_23761();
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
        }
        class_4597.class_4598 immediate = class_310.method_1551().method_22940().method_23000();
        class_4588 vertexConsumer = immediate.getBuffer(class_1921.method_51784());
        vertexConsumer.method_22918(matrix4f, x1, y1, 0.0f).method_39415(color);
        vertexConsumer.method_22918(matrix4f, x1, y2, 0.0f).method_39415(color);
        vertexConsumer.method_22918(matrix4f, x2, y2, 0.0f).method_39415(color);
        vertexConsumer.method_22918(matrix4f, x2, y1, 0.0f).method_39415(color);
        immediate.method_22993();
    }

    public static enum ArrowDirection {
        UP,
        DOWN,
        LEFT,
        RIGHT;

    }

    private static enum Corner {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }
}

