/*
 * Decompiled with CFR 0.152.
 */
package main.walksy.lib.core.utils;

import net.minecraft.class_3532;

public class Animation {
    private float currentValue;
    private float targetValue;
    private float speed;

    public Animation(float initialValue, float speed) {
        this.currentValue = initialValue;
        this.targetValue = initialValue;
        this.speed = speed;
    }

    public void update(float delta, Runnable onAnimating) {
        float t = 1.0f - (float)Math.exp(-this.speed * delta);
        float newValue = class_3532.method_16439((float)t, (float)this.currentValue, (float)this.targetValue);
        if (Math.abs(newValue - this.targetValue) > 0.001f && onAnimating != null) {
            onAnimating.run();
        }
        this.currentValue = newValue;
    }

    public void update(float delta) {
        this.update(delta, null);
    }

    public void setTargetValue(float targetValue) {
        this.targetValue = targetValue;
    }

    public float getCurrentValue() {
        return this.currentValue;
    }

    public void jumpTo(float value) {
        this.currentValue = value;
        this.targetValue = value;
    }

    public boolean isAnimating() {
        return this.currentValue != this.targetValue;
    }

    public float getTargetValue() {
        return this.targetValue;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }
}

