/*
 * Decompiled with CFR 0.152.
 */
package ru.tcd3v.deltime.client;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1542;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_898;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class DeltimeClient
implements ClientModInitializer {
    private static class_304 toggleKeyBinding;
    private static class_304 toggleModeKeyBinding;
    public static boolean isEnabled;
    public static DisplayMode displayMode;

    public void onInitializeClient() {
        toggleKeyBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.itemtimer.toggle", class_3675.class_307.field_1668, 72, "category.itemtimer.general"));
        toggleModeKeyBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.itemtimer.toggle_mode", class_3675.class_307.field_1668, 74, "category.itemtimer.general"));
        WorldRenderEvents.AFTER_ENTITIES.register(context -> {
            class_310 client = class_310.method_1551();
            if (client.field_1687 == null || client.field_1724 == null) {
                return;
            }
            while (toggleKeyBinding.method_1436()) {
                isEnabled = !isEnabled;
                client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("Item Timer: " + (isEnabled ? "\u0412\u043a\u043b\u044e\u0447\u0435\u043d" : "\u0412\u044b\u043a\u043b\u044e\u0447\u0435\u043d"))), true);
                if (isEnabled) continue;
                client.field_1687.method_8390(class_1542.class, client.field_1724.method_5829().method_1014(64.0), e -> true).forEach(e -> e.method_5880(false));
            }
            while (toggleModeKeyBinding.method_1436()) {
                displayMode = displayMode.next();
                client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("\u0420\u0435\u0436\u0438\u043c \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f: " + displayMode.getDisplayName())), true);
            }
            if (!isEnabled) {
                return;
            }
            client.field_1687.method_8390(class_1542.class, client.field_1724.method_5829().method_1014(64.0), e -> true).forEach(itemEntity -> {
                int maxAge = 6000;
                int age = itemEntity.method_6985();
                int remainingTicks = Math.max(0, maxAge - age);
                if (remainingTicks <= 0) {
                    itemEntity.method_5665(null);
                    itemEntity.method_5880(false);
                    return;
                }
                int totalSeconds = remainingTicks / 20;
                int minutes = totalSeconds / 60;
                int seconds = totalSeconds % 60;
                String timerText = String.format("%d:%02d", minutes, seconds);
                itemEntity.method_5665((class_2561)class_2561.method_43470((String)timerText));
                boolean looking = this.isPlayerLookingAtItem(client, (class_1542)itemEntity);
                boolean show = displayMode == DisplayMode.ALWAYS || displayMode == DisplayMode.LOOKING_AT && looking;
                itemEntity.method_5880(show);
            });
        });
    }

    private boolean isPlayerLookingAtItem(class_310 client, class_1542 itemEntity) {
        if (client.field_1724 == null) {
            return false;
        }
        class_243 playerEyePos = client.field_1724.method_33571();
        class_243 playerLookVec = client.field_1724.method_5828(1.0f);
        class_243 itemPos = itemEntity.method_19538().method_1031(0.0, (double)(itemEntity.method_17682() / 2.0f), 0.0);
        class_243 toItem = itemPos.method_1020(playerEyePos).method_1029();
        double dotProduct = playerLookVec.method_1026(toItem);
        double angle = Math.acos(Math.max(-1.0, Math.min(1.0, dotProduct)));
        double distance = playerEyePos.method_1022(itemPos);
        double maxAngle = Math.toRadians(15.0);
        if (distance > 10.0) {
            maxAngle = Math.toRadians(8.0);
        }
        return angle <= maxAngle && distance <= 32.0;
    }

    private void renderItemNameAndTimer(class_4587 matrices, class_4597 vertexConsumers, class_1542 itemEntity, class_243 cameraPos, float tickDelta) {
        double z;
        double y;
        class_310 client = class_310.method_1551();
        class_327 textRenderer = client.field_1772;
        class_898 dispatcher = client.method_1561();
        double x = class_3532.method_16436((double)tickDelta, (double)itemEntity.field_6038, (double)itemEntity.method_23317()) - cameraPos.field_1352;
        double distance = Math.sqrt(x * x + (y = class_3532.method_16436((double)tickDelta, (double)itemEntity.field_5971, (double)itemEntity.method_23318()) - cameraPos.field_1351 + (double)itemEntity.method_17682() + 0.5) * y + (z = class_3532.method_16436((double)tickDelta, (double)itemEntity.field_5989, (double)itemEntity.method_23321()) - cameraPos.field_1350) * z);
        if (distance > 64.0) {
            return;
        }
        matrices.method_22903();
        matrices.method_22904(x, y, z);
        matrices.method_22907((Quaternionfc)dispatcher.method_24197());
        matrices.method_22905(-0.025f, -0.025f, 0.025f);
        Matrix4f matrix = matrices.method_23760().method_23761();
        int age = itemEntity.method_6985();
        int maxAge = 6000;
        int remainingTicks = Math.max(0, maxAge - age);
        if (remainingTicks <= 0) {
            matrices.method_22909();
            return;
        }
        int totalSeconds = remainingTicks / 20;
        int minutes = totalSeconds / 60;
        int seconds = totalSeconds % 60;
        String timerText = String.format("%d:%02d", minutes, seconds);
        class_5250 timerDisplay = class_2561.method_43470((String)timerText);
        float timerWidth = textRenderer.method_27525((class_5348)timerDisplay);
        int timerColor = this.getTimerColor(remainingTicks, maxAge);
        textRenderer.method_27522((class_2561)timerDisplay, -timerWidth / 2.0f, -20.0f, timerColor, false, matrix, vertexConsumers, class_327.class_6415.field_33993, 0x40000000, 0xF000F0);
        matrices.method_22909();
    }

    private int getTimerColor(int remainingTicks, int maxAge) {
        float ratio = (float)remainingTicks / (float)maxAge;
        if (ratio > 0.5f) {
            return 0x55FF55;
        }
        if (ratio > 0.25f) {
            return 0xFFFF55;
        }
        return 0xFF5555;
    }

    static {
        isEnabled = true;
        displayMode = DisplayMode.ALWAYS;
    }

    public static enum DisplayMode {
        ALWAYS("\u0412\u0441\u0435\u0433\u0434\u0430"),
        LOOKING_AT("\u041f\u0440\u0438 \u043d\u0430\u0432\u0435\u0434\u0435\u043d\u0438\u0438");

        private final String displayName;

        private DisplayMode(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public DisplayMode next() {
            return DisplayMode.values()[(this.ordinal() + 1) % DisplayMode.values().length];
        }
    }
}

