/*
 * Decompiled with CFR 0.152.
 */
package functional_trims.trim_effect;

import functional_trims.func.TrimHelper;
import functional_trims.trim_effect.ModEffects;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1293;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_8054;
import net.minecraft.class_8055;
import net.minecraft.server.MinecraftServer;

public class AmethystTrimEffect
implements ServerTickEvents.EndTick {
    private static final int STAND_STILL_TICKS = 60;
    private static final int CROUCH_TICKS = 30;
    private static final int EFFECT_DURATION = -1;
    private static final double MOVEMENT_THRESHOLD_SQ = 1.0E-4;
    private static final Map<UUID, PlayerData> PLAYER_DATA = new HashMap<UUID, PlayerData>();

    public void onEndTick(MinecraftServer server) {
        for (class_3222 player : server.method_3760().method_14571()) {
            boolean isMoving;
            boolean hasFullSet = TrimHelper.countTrim((class_1657)player, (class_5321<class_8054>)class_8055.field_42013) == 4;
            PlayerData data = PLAYER_DATA.computeIfAbsent(player.method_5667(), uuid -> new PlayerData());
            class_243 currentPos = player.method_73189();
            double distSq = currentPos.method_1025(data.lastPos);
            boolean bl = isMoving = distSq > 1.0E-4;
            if (!hasFullSet) {
                player.method_6016(ModEffects.AMETHYST_VISION);
                data.stillTicks = 0;
                data.crouchTicks = 0;
                data.lastPos = currentPos;
                continue;
            }
            data.stillTicks = !isMoving ? ++data.stillTicks : 0;
            data.crouchTicks = player.method_5715() ? ++data.crouchTicks : 0;
            if (!(data.stillTicks < 60 && data.crouchTicks < 30 || player.method_6059(ModEffects.AMETHYST_VISION))) {
                player.method_6092(new class_1293(ModEffects.AMETHYST_VISION, -1, 0, true, false, true));
                data.stillTicks = 0;
                data.crouchTicks = 0;
            }
            if (isMoving && player.method_6059(ModEffects.AMETHYST_VISION)) {
                player.method_6016(ModEffects.AMETHYST_VISION);
            }
            data.lastPos = currentPos;
        }
    }

    public static void register() {
        ServerTickEvents.END_SERVER_TICK.register((Object)new AmethystTrimEffect());
    }

    private static class PlayerData {
        class_243 lastPos = class_243.field_1353;
        int stillTicks = 0;
        int crouchTicks = 0;

        private PlayerData() {
        }
    }
}

