/*
 * Decompiled with CFR 0.152.
 */
package functional_trims.trim_effect;

import functional_trims.func.TrimHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5321;
import net.minecraft.class_8054;
import net.minecraft.class_8055;

public class ResinTrimEffect {
    private static final double STOP_THRESHOLD = 0.08;
    private static final double DECAY_RATE = 0.7;
    private static final double CONTACT_EPS = 0.06;
    private static final double NUDGE = 0.002;
    private static final int RELEASE_GRACE_TICKS = 6;
    private static final Map<UUID, GripData> GRIP = new HashMap<UUID, GripData>();

    public static void register() {
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            for (class_3222 player : server.method_3760().method_14571()) {
                ResinTrimEffect.applyResinGrip(player);
            }
        });
    }

    private static void applyResinGrip(class_3222 player) {
        boolean lostContact;
        boolean fullResin;
        class_3218 world = player.method_51469();
        if (world.method_8608()) {
            return;
        }
        GripData gd = GRIP.computeIfAbsent(player.method_5667(), u -> new GripData());
        if (gd.releaseGrace > 0) {
            player.field_6017 = 0.0;
            --gd.releaseGrace;
        }
        boolean bl = fullResin = TrimHelper.countTrim((class_1657)player, (class_5321<class_8054>)class_8055.field_55049) == 4;
        if (!fullResin || !player.method_5715()) {
            if (gd.gripping) {
                ResinTrimEffect.release(player, gd);
            }
            return;
        }
        class_2350 contact = ResinTrimEffect.findContactDirection(player);
        if (contact == class_2350.field_11033) {
            if (gd.gripping) {
                ResinTrimEffect.release(player, gd);
            }
            return;
        }
        if (!gd.gripping && contact == null) {
            return;
        }
        if (!gd.gripping) {
            gd.gripping = true;
            gd.normal = contact;
            gd.sinceGrip = 0;
            world.method_8396(null, player.method_24515(), class_3417.field_21074, class_3419.field_15248, 0.6f, 1.0f);
        } else if (contact != null) {
            gd.normal = contact;
        }
        class_243 vel = player.method_18798();
        double speed2 = vel.method_1027();
        player.field_6017 = 0.0;
        if (speed2 > 0.0064) {
            player.method_18799(vel.method_1021(0.7));
            player.method_5875(true);
        } else {
            player.method_18799(class_243.field_1353);
            player.method_5875(true);
            if (gd.normal != null) {
                class_243 n = new class_243((double)gd.normal.method_10148(), (double)gd.normal.method_10164(), (double)gd.normal.method_10165());
                player.method_5814(player.method_23317() - n.field_1352 * 0.002, player.method_23318() - n.field_1351 * 0.002, player.method_23321() - n.field_1350 * 0.002);
            }
        }
        player.field_6037 = true;
        ++gd.sinceGrip;
        boolean bl2 = lostContact = ResinTrimEffect.findContactDirection(player) == null;
        if (lostContact && gd.sinceGrip > 2) {
            ResinTrimEffect.release(player, gd);
        }
    }

    private static void release(class_3222 player, GripData gd) {
        player.method_5875(false);
        player.field_6017 = 0.0;
        gd.gripping = false;
        gd.normal = null;
        gd.sinceGrip = 0;
        gd.releaseGrace = 6;
        player.method_51469().method_8396(null, player.method_24515(), class_3417.field_14560, class_3419.field_15248, 0.4f, 1.1f);
    }

    private static class_2350 findContactDirection(class_3222 player) {
        class_3218 world = player.method_51469();
        class_238 box = player.method_5829();
        class_2350 best = null;
        class_243 v = player.method_18798();
        double bestDot = Double.NEGATIVE_INFINITY;
        boolean touchingGround = false;
        for (class_2350 d : class_2350.values()) {
            class_243 dv = new class_243((double)d.method_10148(), (double)d.method_10164(), (double)d.method_10165());
            class_238 probe = box.method_997(dv.method_1021(0.06));
            if (world.method_8587((class_1297)player, probe)) continue;
            if (d == class_2350.field_11033) {
                touchingGround = true;
                continue;
            }
            double dot = v.method_1026(dv.method_1021(-1.0));
            if (!(dot > bestDot)) continue;
            bestDot = dot;
            best = d;
        }
        if (best == null && touchingGround) {
            return class_2350.field_11033;
        }
        return best;
    }

    private static class GripData {
        boolean gripping = false;
        class_2350 normal = null;
        int sinceGrip = 0;
        int releaseGrace = 0;

        private GripData() {
        }
    }
}

