/*
 * Decompiled with CFR 0.152.
 */
package com.github.stellarwind22.shieldlib.init;

import com.github.stellarwind22.shieldlib.lib.component.ShieldDataComponents;
import com.github.stellarwind22.shieldlib.lib.component.ShieldInformation;
import com.github.stellarwind22.shieldlib.lib.config.ShieldLibConfig;
import com.github.stellarwind22.shieldlib.lib.event.ShieldEvents;
import com.github.stellarwind22.shieldlib.lib.object.ShieldLibDamage;
import com.github.stellarwind22.shieldlib.lib.object.ShieldLibTags;
import com.github.stellarwind22.shieldlib.lib.object.ShieldLibUtils;
import com.github.stellarwind22.shieldlib.lib.registry.ShieldCooldownEntry;
import com.github.stellarwind22.shieldlib.lib.registry.ShieldCooldownModifier;
import com.github.stellarwind22.shieldlib.lib.registry.ShieldMovementModifier;
import com.github.stellarwind22.shieldlib.test.ShieldLibTests;
import com.mojang.datafixers.util.Pair;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.EntityEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.BlocksAttacks;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShieldLib {
    private static final List<ShieldCooldownModifier> cooldownModifiers = new ArrayList<ShieldCooldownModifier>();
    private static final List<ShieldMovementModifier> movementModifiers = new ArrayList<ShieldMovementModifier>();
    private static final List<ShieldCooldownEntry> cooldownEntries = new ArrayList<ShieldCooldownEntry>();
    public static final String MOD_ID = "shieldlib";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"shieldlib");
    public static boolean IS_DEV;

    public static void init(boolean isDev) {
        IS_DEV = isDev;
        ShieldLibTags.init();
        ShieldDataComponents.init();
        ShieldLib.registerCooldownEntry(new ShieldCooldownEntry(ShieldLibUtils.VANILLA_SHIELD_INFORMATION_COMPONENT, ShieldLibTags.C_AXE, () -> Float.valueOf(ShieldLibConfig.vanilla_shield_cooldown_seconds)), new ShieldCooldownEntry(ShieldLibUtils.CONFIG_TOWER_SHIELD_INFORMATION_COMPONENT, ShieldLibTags.C_AXE, () -> Float.valueOf(ShieldLibConfig.tower_default_cooldown_seconds)), new ShieldCooldownEntry(ShieldLibUtils.CONFIG_BUCKLER_SHIELD_INFORMATION_COMPONENT, ShieldLibTags.C_AXE, () -> Float.valueOf(ShieldLibConfig.buckler_default_cooldown_seconds)), new ShieldCooldownEntry(ShieldLibUtils.CONFIG_HEATER_SHIELD_INFORMATION_COMPONENT, ShieldLibTags.C_AXE, () -> Float.valueOf(ShieldLibConfig.heater_default_cooldown_seconds)), new ShieldCooldownEntry(ShieldLibUtils.CONFIG_TARGE_SHIELD_INFORMATION_COMPONENT, ShieldLibTags.C_AXE, () -> Float.valueOf(ShieldLibConfig.targe_default_cooldown_seconds)));
        ShieldLib.registerMovementModifier((player, stack, blocksAttacks, movement) -> {
            float multiplier;
            if (stack.is(Items.SHIELD)) {
                return movement.scale(ShieldLibConfig.vanilla_shield_movement_multiplier * 5.0f);
            }
            if (!stack.has((DataComponentType)ShieldDataComponents.SHIELD_INFORMATION.get())) {
                return movement;
            }
            ShieldInformation shieldInfo = (ShieldInformation)stack.get((DataComponentType)ShieldDataComponents.SHIELD_INFORMATION.get());
            if (shieldInfo == null || !shieldInfo.hasFeature("config")) {
                return movement;
            }
            switch (shieldInfo.type()) {
                case "tower": {
                    float f = ShieldLibConfig.tower_movement_multiplier;
                    break;
                }
                case "buckler": {
                    float f = ShieldLibConfig.buckler_movement_multiplier;
                    break;
                }
                case "heater": {
                    float f = ShieldLibConfig.heater_movement_multiplier;
                    break;
                }
                case "targe": {
                    float f = ShieldLibConfig.targe_movement_multiplier;
                    break;
                }
                default: {
                    float f = multiplier = 0.0f;
                }
            }
            if (multiplier <= 0.0f) {
                return movement;
            }
            return movement.scale(multiplier * 5.0f);
        });
        ShieldEvents.CAN_BLOCK.register((level, defender, source, amount, hand, shield) -> {
            if (!ShieldLibConfig.buckler_blocks_arrows) {
                if (!shield.has((DataComponentType)ShieldDataComponents.SHIELD_INFORMATION.get())) {
                    return EventResult.pass();
                }
                ShieldInformation shieldInfo = (ShieldInformation)shield.get((DataComponentType)ShieldDataComponents.SHIELD_INFORMATION.get());
                assert (shieldInfo != null);
                Entity entity = source.getDirectEntity();
                if (entity instanceof AbstractArrow && shieldInfo.isType("buckler")) {
                    return EventResult.interruptFalse();
                }
            }
            return EventResult.pass();
        });
        ShieldEvents.BLOCK.register((level, defender, source, amount, hand, shield) -> {
            float damage;
            if (!shield.has((DataComponentType)ShieldDataComponents.SHIELD_INFORMATION.get())) {
                return;
            }
            ShieldInformation shieldInfo = (ShieldInformation)shield.get((DataComponentType)ShieldDataComponents.SHIELD_INFORMATION.get());
            assert (shieldInfo != null);
            if (!shieldInfo.hasFeature("spiked") || !shieldInfo.hasFeature("config")) {
                return;
            }
            Entity attacker = source.getEntity();
            if (attacker == null) {
                return;
            }
            switch (shieldInfo.type()) {
                case "tower": {
                    float f = ShieldLibConfig.tower_spiked_hit_damage;
                    break;
                }
                case "buckler": {
                    float f = ShieldLibConfig.buckler_spiked_hit_damage;
                    break;
                }
                case "heater": {
                    float f = ShieldLibConfig.heater_spiked_hit_damage;
                    break;
                }
                case "targe": {
                    float f = ShieldLibConfig.targe_spiked_hit_damage;
                    break;
                }
                default: {
                    float f = damage = 0.0f;
                }
            }
            if (damage > 0.0f) {
                attacker.hurtServer(level, ShieldLibDamage.sourceOf(level.registryAccess(), ShieldLibDamage.HIT_SPIKED_SHIELD, (Entity)defender, attacker), damage);
            }
        });
        ShieldEvents.BLOCK_FAIL.register((level, defender, source, amount, hand, shield) -> {
            if (!ShieldLibConfig.buckler_blocks_arrows) {
                if (!shield.has((DataComponentType)ShieldDataComponents.SHIELD_INFORMATION.get())) {
                    return;
                }
                if (!shield.has(DataComponents.BLOCKS_ATTACKS)) {
                    return;
                }
                ShieldInformation shieldInfo = (ShieldInformation)shield.get((DataComponentType)ShieldDataComponents.SHIELD_INFORMATION.get());
                BlocksAttacks blocksAttacks = (BlocksAttacks)shield.get(DataComponents.BLOCKS_ATTACKS);
                assert (shieldInfo != null);
                assert (blocksAttacks != null);
                Entity entity = source.getDirectEntity();
                if (entity instanceof AbstractArrow && shieldInfo.isType("buckler")) {
                    blocksAttacks.hurtBlockingItem((Level)level, shield, defender, hand, amount);
                    Entity patt0$temp = source.getEntity();
                    if (patt0$temp instanceof LivingEntity) {
                        LivingEntity attacker = (LivingEntity)patt0$temp;
                        ((ShieldEvents.ShieldDisable)ShieldEvents.DISABLE.invoker()).onDisable(level, attacker, defender, defender instanceof Player, hand, shield, 1.0f);
                    }
                    blocksAttacks.disable(level, defender, 1.0f, shield);
                }
            }
        });
        ShieldEvents.COLLIDE.register((level, player, collider, withinAngle, hand, shield) -> {
            float damage;
            boolean spiked;
            if (!shield.has((DataComponentType)ShieldDataComponents.SHIELD_INFORMATION.get())) {
                return;
            }
            if (!withinAngle) {
                return;
            }
            ShieldInformation shieldInfo = (ShieldInformation)shield.get((DataComponentType)ShieldDataComponents.SHIELD_INFORMATION.get());
            if (shieldInfo == null) {
                return;
            }
            boolean bl = spiked = shieldInfo.hasFeature("spiked") && shieldInfo.hasFeature("config");
            if (!spiked) {
                return;
            }
            switch (shieldInfo.type()) {
                case "tower": {
                    float f = ShieldLibConfig.tower_spiked_collide_damage;
                    break;
                }
                case "buckler": {
                    float f = ShieldLibConfig.buckler_spiked_collide_damage;
                    break;
                }
                case "heater": {
                    float f = ShieldLibConfig.heater_spiked_collide_damage;
                    break;
                }
                case "targe": {
                    float f = ShieldLibConfig.targe_spiked_collide_damage;
                    break;
                }
                default: {
                    float f = damage = 0.0f;
                }
            }
            if (damage > 0.0f && collider.hurtServer(level, ShieldLibDamage.sourceOf(level.registryAccess(), ShieldLibDamage.COLLIDE_SPIKED_SHIELD, collider, (Entity)player), damage)) {
                BlocksAttacks blocksAttacks = (BlocksAttacks)shield.get(DataComponents.BLOCKS_ATTACKS);
                assert (blocksAttacks != null);
                SoundEvent blockSound = (SoundEvent)blocksAttacks.blockSound().orElseGet(() -> Holder.direct((Object)SoundEvents.ANVIL_LAND)).value();
                level.playSound(null, player.getX(), player.getY(), player.getZ(), blockSound, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        });
        EntityEvent.LIVING_HURT.register((target, source, amount) -> {
            Entity patt0$temp = source.getEntity();
            if (patt0$temp instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)patt0$temp;
                Level patt1$temp = target.level();
                if (patt1$temp instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)patt1$temp;
                    ((ShieldEvents.ShieldAttack)ShieldEvents.ATTACK.invoker()).onAttack(serverLevel, source, target, amount, attacker.getWeaponItem());
                }
            }
            return EventResult.pass();
        });
        if (IS_DEV) {
            ShieldLibTests.init();
        }
    }

    public static void registerCooldownEntry(ShieldCooldownEntry entry) {
        cooldownEntries.add(entry);
    }

    public static void registerCooldownEntry(ShieldCooldownEntry ... entries) {
        cooldownEntries.addAll(List.of(entries));
    }

    public static void registerCooldownModifier(ShieldCooldownModifier cooldownModifier) {
        cooldownModifiers.add(cooldownModifier);
    }

    public static void registerMovementModifier(ShieldMovementModifier movementModifier) {
        movementModifiers.add(movementModifier);
    }

    public static float getCooldownSeconds(RegistryAccess access, ItemStack weapon) {
        for (ShieldCooldownEntry cooldownEntry : cooldownEntries) {
            if (!cooldownEntry.matchWeapon(access, weapon)) continue;
            return cooldownEntry.cooldown().get().floatValue();
        }
        return 0.0f;
    }

    public static float getCooldownSeconds(ItemStack shield, BlocksAttacks blocksAttacks) {
        for (ShieldCooldownEntry cooldownEntry : cooldownEntries) {
            if (!cooldownEntry.matchShield(shield)) continue;
            return cooldownEntry.cooldown().get().floatValue();
        }
        return blocksAttacks.disableCooldownScale() * 5.0f;
    }

    public static Vec2 getMovementWithModifiers(Player player, ItemStack stack, BlocksAttacks blocksAttacks, Vec2 movement) {
        for (ShieldMovementModifier movementModifier : movementModifiers) {
            movement = movementModifier.modify(player, stack, blocksAttacks, movement);
        }
        return movement;
    }

    public static float getCooldownSecondsWithModifiers(Player player, ItemStack stack, BlocksAttacks blocksAttacks, float cooldown) {
        for (ShieldCooldownModifier cooldownModifier : cooldownModifiers) {
            cooldown = cooldownModifier.modify(player, stack, blocksAttacks, cooldown);
        }
        return cooldown;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Set<Pair<String, Float>> getTagTranslations(ShieldInformation shieldInformation) {
        HashSet<Pair<String, Float>> set = new HashSet<Pair<String, Float>>();
        cooldownEntries.forEach(cooldownEntry -> {
            if (cooldownEntry.matchShield(shieldInformation)) {
                set.add(new Pair((Object)ShieldLibUtils.getTranslationKey(cooldownEntry.tag()), (Object)cooldownEntry.cooldown().get()));
            }
        });
        return set;
    }
}

