/*
 * Decompiled with CFR 0.152.
 */
package com.github.stellarwind22.shieldlib.init;

import com.github.stellarwind22.shieldlib.init.ShieldLib;
import com.github.stellarwind22.shieldlib.lib.client.event.ShieldClientEvents;
import com.github.stellarwind22.shieldlib.lib.client.model.BucklerShieldLibModel;
import com.github.stellarwind22.shieldlib.lib.client.model.HeaterShieldModel;
import com.github.stellarwind22.shieldlib.lib.client.model.SpikedBucklerShieldModel;
import com.github.stellarwind22.shieldlib.lib.client.model.SpikedHeaterShieldModel;
import com.github.stellarwind22.shieldlib.lib.client.model.SpikedTargeShieldModel;
import com.github.stellarwind22.shieldlib.lib.client.model.SpikedTowerShieldModel;
import com.github.stellarwind22.shieldlib.lib.client.model.TargeShieldModel;
import com.github.stellarwind22.shieldlib.lib.client.render.BucklerShieldModelRenderer;
import com.github.stellarwind22.shieldlib.lib.client.render.HeaterShieldModelRenderer;
import com.github.stellarwind22.shieldlib.lib.client.render.SpikedBucklerShieldModelRenderer;
import com.github.stellarwind22.shieldlib.lib.client.render.SpikedHeaterShieldModelRenderer;
import com.github.stellarwind22.shieldlib.lib.client.render.SpikedTargeShieldModelRenderer;
import com.github.stellarwind22.shieldlib.lib.client.render.SpikedTowerShieldModelRenderer;
import com.github.stellarwind22.shieldlib.lib.client.render.TargeShieldModelRenderer;
import com.github.stellarwind22.shieldlib.lib.client.render.TowerShieldModelRenderer;
import com.github.stellarwind22.shieldlib.lib.component.ShieldDataComponents;
import com.github.stellarwind22.shieldlib.lib.component.ShieldInformation;
import com.github.stellarwind22.shieldlib.lib.config.ShieldLibConfig;
import com.github.stellarwind22.shieldlib.lib.object.ShieldLibTags;
import com.github.stellarwind22.shieldlib.lib.object.ShieldLibUtils;
import com.github.stellarwind22.shieldlib.mixin.client.SheetsAccessor;
import com.github.stellarwind22.shieldlib.mixin.client.SpecialModelRenderersAccessor;
import com.github.stellarwind22.shieldlib.test.ShieldLibTests;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import dev.architectury.registry.client.level.entity.EntityModelLayerRegistry;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MaterialMapper;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BlocksAttacks;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.phys.Vec2;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ShieldLibClient {
    public static final ResourceLocation TOWER_SHIELD_MODEL_TYPE = ResourceLocation.fromNamespaceAndPath((String)"shieldlib", (String)"tower_shield");
    public static final ResourceLocation BUCKLER_SHIELD_MODEL_TYPE = ResourceLocation.fromNamespaceAndPath((String)"shieldlib", (String)"buckler_shield");
    public static final ResourceLocation HEATER_SHIELD_MODEL_TYPE = ResourceLocation.fromNamespaceAndPath((String)"shieldlib", (String)"heater_shield");
    public static final ResourceLocation TARGE_SHIELD_MODEL_TYPE = ResourceLocation.fromNamespaceAndPath((String)"shieldlib", (String)"targe_shield");
    public static final ResourceLocation SPIKED_TOWER_SHIELD_MODEL_TYPE = ResourceLocation.fromNamespaceAndPath((String)"shieldlib", (String)"spiked_tower_shield");
    public static final ResourceLocation SPIKED_BUCKLER_SHIELD_MODEL_TYPE = ResourceLocation.fromNamespaceAndPath((String)"shieldlib", (String)"spiked_buckler_shield");
    public static final ResourceLocation SPIKED_HEATER_SHIELD_MODEL_TYPE = ResourceLocation.fromNamespaceAndPath((String)"shieldlib", (String)"spiked_heater_shield");
    public static final ResourceLocation SPIKED_TARGE_SHIELD_MODEL_TYPE = ResourceLocation.fromNamespaceAndPath((String)"shieldlib", (String)"spiked_targe_shield");
    public static final ResourceLocation SHIELD_ATLAS_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/atlas/shield_patterns.png");
    public static final ExtraCodecs.LateBoundIdMapper<ResourceLocation, MapCodec<? extends SpecialModelRenderer.Unbaked>> ID_MAPPER = SpecialModelRenderersAccessor.getIDMapper();
    public static boolean IS_DEV;

    public static void init(boolean isDev) {
        IS_DEV = isDev;
        ID_MAPPER.put((Object)TOWER_SHIELD_MODEL_TYPE, TowerShieldModelRenderer.Unbaked.CODEC);
        ID_MAPPER.put((Object)BUCKLER_SHIELD_MODEL_TYPE, BucklerShieldModelRenderer.Unbaked.CODEC);
        ID_MAPPER.put((Object)HEATER_SHIELD_MODEL_TYPE, HeaterShieldModelRenderer.Unbaked.CODEC);
        ID_MAPPER.put((Object)TARGE_SHIELD_MODEL_TYPE, TargeShieldModelRenderer.Unbaked.CODEC);
        ID_MAPPER.put((Object)SPIKED_TOWER_SHIELD_MODEL_TYPE, SpikedTowerShieldModelRenderer.Unbaked.CODEC);
        ID_MAPPER.put((Object)SPIKED_BUCKLER_SHIELD_MODEL_TYPE, SpikedBucklerShieldModelRenderer.Unbaked.CODEC);
        ID_MAPPER.put((Object)SPIKED_HEATER_SHIELD_MODEL_TYPE, SpikedHeaterShieldModelRenderer.Unbaked.CODEC);
        ID_MAPPER.put((Object)SPIKED_TARGE_SHIELD_MODEL_TYPE, SpikedTargeShieldModelRenderer.Unbaked.CODEC);
        EntityModelLayerRegistry.register((ModelLayerLocation)BucklerShieldLibModel.LOCATION, BucklerShieldLibModel::createLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)HeaterShieldModel.LOCATION, HeaterShieldModel::createLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)TargeShieldModel.LOCATION, TargeShieldModel::createLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)SpikedTowerShieldModel.LOCATION, SpikedTowerShieldModel::createLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)SpikedBucklerShieldModel.LOCATION, SpikedBucklerShieldModel::createLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)SpikedHeaterShieldModel.LOCATION, SpikedHeaterShieldModel::createLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)SpikedTargeShieldModel.LOCATION, SpikedTargeShieldModel::createLayer);
        ShieldClientEvents.TOOLTIP.register((player, stack, context, flag, tooltip) -> {
            BlocksAttacks blocksAttacks;
            if (stack.get(DataComponents.BLOCKS_ATTACKS) == null || stack.is(ShieldLibTags.NO_TOOLTIP)) {
                return;
            }
            if (ShieldLibConfig.show_cooldown_tooltip) {
                Set<Object> translations;
                if (!stack.has(DataComponents.BLOCKS_ATTACKS)) {
                    return;
                }
                blocksAttacks = (BlocksAttacks)stack.get(DataComponents.BLOCKS_ATTACKS);
                assert (blocksAttacks != null);
                if (stack.has((DataComponentType)ShieldDataComponents.SHIELD_INFORMATION.get())) {
                    translations = ShieldLib.getTagTranslations((ShieldInformation)stack.get((DataComponentType)ShieldDataComponents.SHIELD_INFORMATION.get()));
                } else {
                    translations = new HashSet<Pair>();
                    translations.add(new Pair((Object)ShieldLibUtils.getTranslationKey(ShieldLibTags.C_AXE), (Object)Float.valueOf(5.0f)));
                }
                if (translations.size() > 1) {
                    tooltip.add(Component.literal((String)""));
                    tooltip.add(Component.translatable((String)"shieldlib.cooldown_tooltip.head").withStyle(ChatFormatting.GRAY));
                    for (Pair pair : translations) {
                        cooldownSeconds = ShieldLib.getCooldownSecondsWithModifiers(player, stack, blocksAttacks, ((Float)pair.getSecond()).floatValue());
                        String tag = Component.translatable((String)((String)pair.getFirst())).getString();
                        String cooldown = String.valueOf(cooldownSeconds).replaceAll("\\.0*$", "");
                        String bodyTranslated = String.format(Component.translatable((String)"shieldlib.cooldown_tooltip.body").getString(), tag, cooldown);
                        tooltip.add(Component.literal((String)(" " + bodyTranslated)).withStyle(ChatFormatting.DARK_GREEN));
                    }
                } else if (translations.size() == 1) {
                    Pair translation = (Pair)translations.iterator().next();
                    tooltip.add(Component.literal((String)""));
                    String string = String.format(Component.translatable((String)"shieldlib.cooldown_tooltip.head.single").getString(), Component.translatable((String)((String)translation.getFirst())).getString());
                    tooltip.add(Component.literal((String)string).withStyle(ChatFormatting.GRAY));
                    cooldownSeconds = ShieldLib.getCooldownSecondsWithModifiers(player, stack, blocksAttacks, ((Float)translation.getSecond()).floatValue());
                    String cooldown = String.valueOf(cooldownSeconds).replaceAll("\\.0*$", "");
                    String bodyTranslated = String.format(Component.translatable((String)"shieldlib.cooldown_tooltip.body.single").getString(), cooldown);
                    tooltip.add(Component.literal((String)(" " + bodyTranslated)).withStyle(ChatFormatting.DARK_GREEN));
                }
            }
            if (ShieldLibConfig.show_movement_tooltip) {
                if (!stack.has(DataComponents.BLOCKS_ATTACKS)) {
                    return;
                }
                blocksAttacks = (BlocksAttacks)stack.get(DataComponents.BLOCKS_ATTACKS);
                assert (blocksAttacks != null);
                float movementMultiplier = ShieldLib.getMovementWithModifiers((Player)player, (ItemStack)stack, (BlocksAttacks)blocksAttacks, (Vec2)new Vec2((float)1.0f, (float)1.0f)).x / 5.0f - 1.0f;
                if (movementMultiplier == 0.0f) {
                    return;
                }
                tooltip.add(Component.literal((String)""));
                tooltip.add(Component.translatable((String)"shieldlib.movement_tooltip.head").withStyle(ChatFormatting.GRAY));
                String multiplierStr = String.valueOf(movementMultiplier * 100.0f).replaceAll("\\.0*$", "");
                if (movementMultiplier > 0.0f) {
                    String string = "+" + multiplierStr;
                    String movementTranslated = String.format(Component.translatable((String)"shieldlib.movement_tooltip.body").getString(), string);
                    tooltip.add(Component.literal((String)(" " + movementTranslated)).withStyle(ChatFormatting.BLUE));
                } else if (movementMultiplier < 0.0f) {
                    String string = String.format(Component.translatable((String)"shieldlib.movement_tooltip.body").getString(), multiplierStr);
                    tooltip.add(Component.literal((String)(" " + string)).withStyle(ChatFormatting.RED));
                }
            }
        });
        if (IS_DEV) {
            ShieldLibTests.initClient();
        }
    }

    public static Material getShapedBannerMaterial(String shape, Holder<BannerPattern> bannerPattern) {
        return ShieldLibClient.getShapedBannerMaterial(shape, ((BannerPattern)bannerPattern.value()).assetId());
    }

    public static Material getShapedBannerMaterial(String shape, ResourceLocation assetId) {
        Map<ResourceLocation, Material> map = SheetsAccessor.getShieldMaterials();
        if (!Objects.equals(shape, "tower")) {
            assetId = assetId.withPrefix(shape + "_");
        }
        MaterialMapper mapper = Sheets.SHIELD_MAPPER;
        Objects.requireNonNull(mapper);
        return map.computeIfAbsent(assetId, arg_0 -> ((MaterialMapper)mapper).apply(arg_0));
    }
}

