/*
 * Decompiled with CFR 0.152.
 */
package com.github.stellarwind22.shieldlib.lib.client.render;

import com.github.stellarwind22.shieldlib.init.ShieldLibClient;
import com.github.stellarwind22.shieldlib.lib.client.model.ShieldModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public interface ShieldModelRenderer
extends SpecialModelRenderer<DataComponentMap> {
    public ResourceLocation baseModel();

    public ResourceLocation baseModelNoPat();

    public ShieldModel model();

    default public DataComponentMap extractArgument(ItemStack itemStack) {
        return itemStack.getComponents();
    }

    default public void getExtents(Set<Vector3f> set) {
        PoseStack poseStack = new PoseStack();
        poseStack.scale(1.0f, -1.0f, -1.0f);
        this.model().getRoot().getExtentsForGui(poseStack, set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void render(@Nullable DataComponentMap componentMap, ItemDisplayContext itemDisplayContext, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j, boolean bl) {
        BannerPatternLayers bannerPatternLayers = componentMap == null ? BannerPatternLayers.EMPTY : (BannerPatternLayers)componentMap.getOrDefault(DataComponents.BANNER_PATTERNS, (Object)BannerPatternLayers.EMPTY);
        DyeColor color = componentMap == null ? null : (DyeColor)componentMap.get(DataComponents.BASE_COLOR);
        boolean bl2 = !bannerPatternLayers.layers().isEmpty() || color != null;
        poseStack.pushPose();
        poseStack.scale(1.0f, -1.0f, -1.0f);
        try {
            Material spriteMat = bl2 ? new Material(ShieldLibClient.SHIELD_ATLAS_LOCATION, this.baseModel()) : new Material(ShieldLibClient.SHIELD_ATLAS_LOCATION, this.baseModelNoPat());
            VertexConsumer vertexConsumer = spriteMat.sprite().wrap(ItemRenderer.getFoilBuffer((MultiBufferSource)multiBufferSource, (RenderType)this.model().getRenderType(spriteMat.atlasLocation()), (itemDisplayContext == ItemDisplayContext.GUI ? 1 : 0) != 0, (boolean)bl));
            this.model().handle().render(poseStack, vertexConsumer, i, j);
            if (bl2) {
                this.renderPatterns(poseStack, multiBufferSource, i, j, this.model().plate(), spriteMat, Objects.requireNonNullElse(color, DyeColor.WHITE), bannerPatternLayers, bl, false);
            } else {
                this.model().plate().render(poseStack, vertexConsumer, i, j);
            }
        }
        finally {
            poseStack.popPose();
        }
    }

    default public void renderPatterns(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j, ModelPart modelPart, Material material, DyeColor dyeColor, BannerPatternLayers bannerPatternLayers, boolean bl2, boolean bl3) {
        modelPart.render(poseStack, material.buffer(multiBufferSource, RenderType::entitySolid, bl3, bl2), i, j);
        this.renderPatternLayer(poseStack, multiBufferSource, i, j, modelPart, ShieldLibClient.getShapedBannerMaterial(this.model().shape(), ResourceLocation.withDefaultNamespace((String)"base")), dyeColor);
        for (int k = 0; k < 16 && k < bannerPatternLayers.layers().size(); ++k) {
            BannerPatternLayers.Layer layer = (BannerPatternLayers.Layer)bannerPatternLayers.layers().get(k);
            Material material2 = ShieldLibClient.getShapedBannerMaterial(this.model().shape(), (Holder<BannerPattern>)layer.pattern());
            this.renderPatternLayer(poseStack, multiBufferSource, i, j, modelPart, material2, layer.color());
        }
    }

    default public void renderPatternLayer(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j, ModelPart modelPart, Material material, DyeColor dyeColor) {
        int k = dyeColor.getTextureDiffuseColor();
        modelPart.render(poseStack, material.buffer(multiBufferSource, RenderType::entityNoOutline), i, j, k);
    }
}

