/*
 * Decompiled with CFR 0.152.
 */
package com.github.stellarwind22.shieldlib.lib.client.render;

import com.github.stellarwind22.shieldlib.lib.client.model.ShieldModel;
import com.github.stellarwind22.shieldlib.lib.client.model.SpikedHeaterShieldModel;
import com.github.stellarwind22.shieldlib.lib.client.render.ShieldModelRenderer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class SpikedHeaterShieldModelRenderer
implements ShieldModelRenderer {
    private final ResourceLocation baseModel;
    private final ResourceLocation baseModelNoPat;
    private final SpikedHeaterShieldModel model;
    public static final ModelLayerLocation SPIKED_HEATER_MODEL_LAYER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"shieldlib", (String)"spiked_heater_shield"), "main");

    public SpikedHeaterShieldModelRenderer(ResourceLocation baseModel, ResourceLocation baseModelNoPat, SpikedHeaterShieldModel model) {
        this.baseModel = baseModel;
        this.baseModelNoPat = baseModelNoPat;
        this.model = model;
    }

    @Override
    public ResourceLocation baseModel() {
        return this.baseModel;
    }

    @Override
    public ResourceLocation baseModelNoPat() {
        return this.baseModelNoPat;
    }

    @Override
    public ShieldModel model() {
        return this.model;
    }

    public record Unbaked(ResourceLocation baseModel, ResourceLocation baseModelNoPat) implements SpecialModelRenderer.Unbaked
    {
        public static final MapCodec<Unbaked> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("texture_banner").forGetter(Unbaked::baseModel), (App)ResourceLocation.CODEC.fieldOf("texture_default").forGetter(Unbaked::baseModelNoPat)).apply((Applicative)instance, Unbaked::new));

        @NotNull
        public MapCodec<Unbaked> type() {
            return CODEC;
        }

        @NotNull
        public SpecialModelRenderer<?> bake(EntityModelSet entityModelSet) {
            ModelPart root = entityModelSet.bakeLayer(SPIKED_HEATER_MODEL_LAYER);
            SpikedHeaterShieldModel model = new SpikedHeaterShieldModel(root);
            return new SpikedHeaterShieldModelRenderer(this.baseModel, this.baseModelNoPat, model);
        }
    }
}

