/*
 * Decompiled with CFR 0.152.
 */
package com.github.stellarwind22.shieldlib.lib.object;

import com.github.stellarwind22.shieldlib.lib.object.ShieldLibUtils;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.enchantment.Repairable;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShieldLibItem
extends Item {
    public ShieldLibItem(Item.Properties properties, float cooldownSeconds, int enchantability, Item ... repairItems) {
        this(properties, cooldownSeconds, enchantability, (HolderSet<Item>)HolderSet.direct(Arrays.stream(repairItems).map(Item::builtInRegistryHolder).collect(Collectors.toList())));
    }

    @Deprecated
    public ShieldLibItem(Item.Properties properties, int cooldownTicks, int enchantability, Item ... repairItems) {
        this(properties, cooldownTicks, enchantability, (HolderSet<Item>)HolderSet.direct(Arrays.stream(repairItems).map(Item::builtInRegistryHolder).collect(Collectors.toList())));
    }

    public ShieldLibItem(Item.Properties properties, Item ... repairItems) {
        this(properties, (HolderSet<Item>)HolderSet.direct(Arrays.stream(repairItems).map(Item::builtInRegistryHolder).collect(Collectors.toList())));
    }

    public ShieldLibItem(Item.Properties properties, float cooldownSeconds, ToolMaterial material) {
        this(properties, cooldownSeconds, material.enchantmentValue(), (TagKey<Item>)material.repairItems());
    }

    @Deprecated
    public ShieldLibItem(Item.Properties properties, int cooldownTicks, ToolMaterial material) {
        this(properties, cooldownTicks, material.enchantmentValue(), (TagKey<Item>)material.repairItems());
    }

    public ShieldLibItem(Item.Properties properties, ToolMaterial material) {
        this(properties.enchantable(material.enchantmentValue()), (TagKey<Item>)material.repairItems());
    }

    public ShieldLibItem(Item.Properties properties, float cooldownSeconds, int enchantability, TagKey<Item> repairItemTag) {
        this(properties, cooldownSeconds, enchantability, (HolderSet<Item>)BuiltInRegistries.acquireBootstrapRegistrationLookup((Registry)BuiltInRegistries.ITEM).getOrThrow(repairItemTag));
    }

    @Deprecated
    public ShieldLibItem(Item.Properties properties, int cooldownTicks, int enchantability, TagKey<Item> repairItemTag) {
        this(properties, cooldownTicks, enchantability, (HolderSet<Item>)BuiltInRegistries.acquireBootstrapRegistrationLookup((Registry)BuiltInRegistries.ITEM).getOrThrow(repairItemTag));
    }

    public ShieldLibItem(Item.Properties properties, TagKey<Item> repairItemTag) {
        this(properties, (HolderSet<Item>)BuiltInRegistries.acquireBootstrapRegistrationLookup((Registry)BuiltInRegistries.ITEM).getOrThrow(repairItemTag));
    }

    public ShieldLibItem(Item.Properties properties, float cooldownSeconds, int enchantability, @Nullable HolderSet<Item> repairItems) {
        super(ShieldLibItem.attachRepairable(ShieldLibUtils.defaultShieldProperties(properties), repairItems).enchantable(enchantability).component(DataComponents.BLOCKS_ATTACKS, (Object)ShieldLibUtils.withCooldownSeconds(ShieldLibUtils.VANILLA_SHIELD_BLOCKS_ATTACKS_COMPONENT, cooldownSeconds)));
    }

    @Deprecated
    public ShieldLibItem(Item.Properties properties, int cooldownTicks, int enchantability, @Nullable HolderSet<Item> repairItems) {
        super(ShieldLibItem.attachRepairable(ShieldLibUtils.defaultShieldProperties(properties), repairItems).enchantable(enchantability).component(DataComponents.BLOCKS_ATTACKS, (Object)ShieldLibUtils.withCooldownTicks(ShieldLibUtils.VANILLA_SHIELD_BLOCKS_ATTACKS_COMPONENT, cooldownTicks)));
    }

    public ShieldLibItem(Item.Properties properties, @Nullable HolderSet<Item> repairItems) {
        super(ShieldLibItem.attachRepairable(properties, repairItems));
    }

    @NotNull
    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        return ItemUseAnimation.BLOCK;
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity user) {
        return 72000;
    }

    @NotNull
    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        player.startUsingItem(hand);
        return InteractionResult.CONSUME;
    }

    public static Item.Properties attachRepairable(Item.Properties properties, @Nullable HolderSet<Item> repairItems) {
        return repairItems == null ? properties : properties.component(DataComponents.REPAIRABLE, (Object)new Repairable(repairItems));
    }

    @NotNull
    public Component getName(ItemStack itemStack) {
        DyeColor color = (DyeColor)itemStack.get(DataComponents.BASE_COLOR);
        if (color != null) {
            String id = this.getDescriptionId();
            return Component.translatable((String)(id + "." + color.name()));
        }
        return super.getName(itemStack);
    }
}

