/*
 * Decompiled with CFR 0.152.
 */
package com.github.stellarwind22.shieldlib.lib.object;

import com.github.stellarwind22.shieldlib.lib.component.ShieldDataComponents;
import com.github.stellarwind22.shieldlib.lib.component.ShieldInformation;
import com.github.stellarwind22.shieldlib.lib.config.ShieldLibConfig;
import com.github.stellarwind22.shieldlib.lib.object.ShieldLibTags;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BlocksAttacks;
import net.minecraft.world.item.enchantment.ItemEnchantments;

public class ShieldLibUtils {
    public static final BlocksAttacks VANILLA_SHIELD_BLOCKS_ATTACKS_COMPONENT = new BlocksAttacks(0.25f, 1.0f, List.of(new BlocksAttacks.DamageReduction(ShieldLibConfig.vanilla_shield_blocking_angle, Optional.empty(), 0.0f, 1.0f)), new BlocksAttacks.ItemDamageFunction(3.0f, 1.0f, 1.0f), Optional.of(DamageTypeTags.BYPASSES_SHIELD), Optional.of(SoundEvents.SHIELD_BLOCK), Optional.of(SoundEvents.SHIELD_BREAK));
    public static final ShieldInformation VANILLA_SHIELD_INFORMATION_COMPONENT = new ShieldInformation("vanilla", List.of("config"));
    public static final BlocksAttacks TOWER_SHIELD_BLOCKS_ATTACKS_COMPONENT = new BlocksAttacks(0.25f, 1.0f, List.of(new BlocksAttacks.DamageReduction(ShieldLibConfig.tower_blocking_angle, Optional.empty(), 0.0f, 1.0f)), new BlocksAttacks.ItemDamageFunction(3.0f, 1.0f, 1.0f), Optional.of(DamageTypeTags.BYPASSES_SHIELD), Optional.of(SoundEvents.SHIELD_BLOCK), Optional.of(SoundEvents.SHIELD_BREAK));
    public static final ShieldInformation TOWER_SHIELD_INFORMATION_COMPONENT = new ShieldInformation("tower", List.of());
    public static final ShieldInformation CONFIG_TOWER_SHIELD_INFORMATION_COMPONENT = new ShieldInformation("tower", List.of("config"));
    public static final ShieldInformation SPIKED_TOWER_SHIELD_INFORMATION_COMPONENT = new ShieldInformation("tower", List.of("spiked"));
    public static final ShieldInformation CONFIG_SPIKED_TOWER_SHIELD_INFORMATION_COMPONENT = new ShieldInformation("tower", List.of("spiked", "config"));
    public static final BlocksAttacks BUCKLER_SHIELD_BLOCKS_ATTACKS_COMPONENT = new BlocksAttacks(0.25f, 1.0f, List.of(new BlocksAttacks.DamageReduction(ShieldLibConfig.buckler_blocking_angle, Optional.empty(), 0.0f, 1.0f)), new BlocksAttacks.ItemDamageFunction(3.0f, 1.0f, 1.0f), Optional.of(DamageTypeTags.BYPASSES_SHIELD), Optional.of(SoundEvents.SHIELD_BLOCK), Optional.of(SoundEvents.SHIELD_BREAK));
    public static final ShieldInformation BUCKLER_SHIELD_INFORMATION_COMPONENT = new ShieldInformation("buckler", List.of());
    public static final ShieldInformation CONFIG_BUCKLER_SHIELD_INFORMATION_COMPONENT = new ShieldInformation("buckler", List.of("config"));
    public static final ShieldInformation SPIKED_BUCKLER_SHIELD_INFORMATION_COMPONENT = new ShieldInformation("buckler", List.of("spiked"));
    public static final ShieldInformation CONFIG_SPIKED_BUCKLER_SHIELD_INFORMATION_COMPONENT = new ShieldInformation("buckler", List.of("spiked", "config"));
    public static final BlocksAttacks HEATER_SHIELD_BLOCKS_ATTACKS_COMPONENT = new BlocksAttacks(0.25f, 1.0f, List.of(new BlocksAttacks.DamageReduction(ShieldLibConfig.heater_blocking_angle, Optional.empty(), 0.0f, 1.0f)), new BlocksAttacks.ItemDamageFunction(3.0f, 1.0f, 1.0f), Optional.of(DamageTypeTags.BYPASSES_SHIELD), Optional.of(SoundEvents.SHIELD_BLOCK), Optional.of(SoundEvents.SHIELD_BREAK));
    public static final ShieldInformation HEATER_SHIELD_INFORMATION_COMPONENT = new ShieldInformation("heater", List.of());
    public static final ShieldInformation CONFIG_HEATER_SHIELD_INFORMATION_COMPONENT = new ShieldInformation("heater", List.of("config"));
    public static final ShieldInformation SPIKED_HEATER_SHIELD_INFORMATION_COMPONENT = new ShieldInformation("heater", List.of("spiked"));
    public static final ShieldInformation CONFIG_SPIKED_HEATER_SHIELD_INFORMATION_COMPONENT = new ShieldInformation("heater", List.of("spiked", "config"));
    public static final BlocksAttacks TARGE_SHIELD_BLOCKS_ATTACKS_COMPONENT = new BlocksAttacks(0.25f, 1.0f, List.of(new BlocksAttacks.DamageReduction(ShieldLibConfig.targe_blocking_angle, Optional.empty(), 0.0f, 1.0f)), new BlocksAttacks.ItemDamageFunction(3.0f, 1.0f, 1.0f), Optional.of(DamageTypeTags.BYPASSES_SHIELD), Optional.of(SoundEvents.SHIELD_BLOCK), Optional.of(SoundEvents.SHIELD_BREAK));
    public static final ShieldInformation TARGE_SHIELD_INFORMATION_COMPONENT = new ShieldInformation("targe", List.of());
    public static final ShieldInformation CONFIG_TARGE_SHIELD_INFORMATION_COMPONENT = new ShieldInformation("targe", List.of("config"));
    public static final ShieldInformation SPIKED_TARGE_SHIELD_INFORMATION_COMPONENT = new ShieldInformation("targe", List.of("spiked"));
    public static final ShieldInformation CONFIG_SPIKED_TARGE_SHIELD_INFORMATION_COMPONENT = new ShieldInformation("targe", List.of("spiked", "config"));

    public static boolean isShieldItem(ItemStack itemStack) {
        return itemStack.has(DataComponents.BLOCKS_ATTACKS);
    }

    public static boolean isShieldItem(Item item) {
        return item.components().has(DataComponents.BLOCKS_ATTACKS);
    }

    public static boolean supportsBanner(ItemStack itemStack) {
        return ShieldLibUtils.supportsBanner(itemStack.getItem());
    }

    public static boolean supportsBanner(Item item) {
        return item.builtInRegistryHolder().is(ShieldLibTags.SUPPORTS_BANNER);
    }

    public static Item.Properties towerShieldProperties(Item.Properties properties, float cooldownSeconds) {
        return ShieldLibUtils.defaultShieldProperties(properties.component(DataComponents.BLOCKS_ATTACKS, (Object)ShieldLibUtils.withCooldownSeconds(TOWER_SHIELD_BLOCKS_ATTACKS_COMPONENT, cooldownSeconds)).component((DataComponentType)ShieldDataComponents.SHIELD_INFORMATION.get(), (Object)TOWER_SHIELD_INFORMATION_COMPONENT));
    }

    public static Item.Properties towerShieldProperties(Item.Properties properties) {
        return ShieldLibUtils.defaultShieldProperties(properties.component(DataComponents.BLOCKS_ATTACKS, (Object)TOWER_SHIELD_BLOCKS_ATTACKS_COMPONENT).component((DataComponentType)ShieldDataComponents.SHIELD_INFORMATION.get(), (Object)CONFIG_TOWER_SHIELD_INFORMATION_COMPONENT));
    }

    public static Item.Properties bucklerShieldProperties(Item.Properties properties, float cooldownSeconds) {
        return ShieldLibUtils.defaultShieldProperties(properties.component(DataComponents.BLOCKS_ATTACKS, (Object)ShieldLibUtils.withCooldownSeconds(BUCKLER_SHIELD_BLOCKS_ATTACKS_COMPONENT, cooldownSeconds)).component((DataComponentType)ShieldDataComponents.SHIELD_INFORMATION.get(), (Object)BUCKLER_SHIELD_INFORMATION_COMPONENT));
    }

    public static Item.Properties bucklerShieldProperties(Item.Properties properties) {
        return ShieldLibUtils.defaultShieldProperties(properties.component(DataComponents.BLOCKS_ATTACKS, (Object)BUCKLER_SHIELD_BLOCKS_ATTACKS_COMPONENT).component((DataComponentType)ShieldDataComponents.SHIELD_INFORMATION.get(), (Object)CONFIG_BUCKLER_SHIELD_INFORMATION_COMPONENT));
    }

    public static Item.Properties heaterShieldProperties(Item.Properties properties, float cooldownSeconds) {
        return ShieldLibUtils.defaultShieldProperties(properties.component(DataComponents.BLOCKS_ATTACKS, (Object)ShieldLibUtils.withCooldownSeconds(HEATER_SHIELD_BLOCKS_ATTACKS_COMPONENT, cooldownSeconds)).component((DataComponentType)ShieldDataComponents.SHIELD_INFORMATION.get(), (Object)HEATER_SHIELD_INFORMATION_COMPONENT));
    }

    public static Item.Properties heaterShieldProperties(Item.Properties properties) {
        return ShieldLibUtils.defaultShieldProperties(properties.component(DataComponents.BLOCKS_ATTACKS, (Object)HEATER_SHIELD_BLOCKS_ATTACKS_COMPONENT).component((DataComponentType)ShieldDataComponents.SHIELD_INFORMATION.get(), (Object)CONFIG_HEATER_SHIELD_INFORMATION_COMPONENT));
    }

    public static Item.Properties targeShieldProperties(Item.Properties properties, float cooldownSeconds) {
        return ShieldLibUtils.defaultShieldProperties(properties.component(DataComponents.BLOCKS_ATTACKS, (Object)ShieldLibUtils.withCooldownSeconds(TARGE_SHIELD_BLOCKS_ATTACKS_COMPONENT, cooldownSeconds)).component((DataComponentType)ShieldDataComponents.SHIELD_INFORMATION.get(), (Object)TARGE_SHIELD_INFORMATION_COMPONENT));
    }

    public static Item.Properties targeShieldProperties(Item.Properties properties) {
        return ShieldLibUtils.defaultShieldProperties(properties.component(DataComponents.BLOCKS_ATTACKS, (Object)TARGE_SHIELD_BLOCKS_ATTACKS_COMPONENT).component((DataComponentType)ShieldDataComponents.SHIELD_INFORMATION.get(), (Object)CONFIG_TARGE_SHIELD_INFORMATION_COMPONENT));
    }

    public static Item.Properties spikedTowerShieldProperties(Item.Properties properties, float cooldownSeconds) {
        return ShieldLibUtils.defaultShieldProperties(properties.component(DataComponents.BLOCKS_ATTACKS, (Object)ShieldLibUtils.withCooldownSeconds(TOWER_SHIELD_BLOCKS_ATTACKS_COMPONENT, cooldownSeconds)).component((DataComponentType)ShieldDataComponents.SHIELD_INFORMATION.get(), (Object)SPIKED_TOWER_SHIELD_INFORMATION_COMPONENT));
    }

    public static Item.Properties spikedTowerShieldProperties(Item.Properties properties) {
        return ShieldLibUtils.defaultShieldProperties(properties.component(DataComponents.BLOCKS_ATTACKS, (Object)TOWER_SHIELD_BLOCKS_ATTACKS_COMPONENT).component((DataComponentType)ShieldDataComponents.SHIELD_INFORMATION.get(), (Object)CONFIG_SPIKED_TOWER_SHIELD_INFORMATION_COMPONENT));
    }

    public static Item.Properties spikedBucklerShieldProperties(Item.Properties properties, float cooldownSeconds) {
        return ShieldLibUtils.defaultShieldProperties(properties.component(DataComponents.BLOCKS_ATTACKS, (Object)ShieldLibUtils.withCooldownSeconds(BUCKLER_SHIELD_BLOCKS_ATTACKS_COMPONENT, cooldownSeconds)).component((DataComponentType)ShieldDataComponents.SHIELD_INFORMATION.get(), (Object)SPIKED_BUCKLER_SHIELD_INFORMATION_COMPONENT));
    }

    public static Item.Properties spikedBucklerShieldProperties(Item.Properties properties) {
        return ShieldLibUtils.defaultShieldProperties(properties.component(DataComponents.BLOCKS_ATTACKS, (Object)BUCKLER_SHIELD_BLOCKS_ATTACKS_COMPONENT).component((DataComponentType)ShieldDataComponents.SHIELD_INFORMATION.get(), (Object)CONFIG_SPIKED_BUCKLER_SHIELD_INFORMATION_COMPONENT));
    }

    public static Item.Properties spikedHeaterShieldProperties(Item.Properties properties, float cooldownSeconds) {
        return ShieldLibUtils.defaultShieldProperties(properties.component(DataComponents.BLOCKS_ATTACKS, (Object)ShieldLibUtils.withCooldownSeconds(HEATER_SHIELD_BLOCKS_ATTACKS_COMPONENT, cooldownSeconds)).component((DataComponentType)ShieldDataComponents.SHIELD_INFORMATION.get(), (Object)SPIKED_HEATER_SHIELD_INFORMATION_COMPONENT));
    }

    public static Item.Properties spikedHeaterShieldProperties(Item.Properties properties) {
        return ShieldLibUtils.defaultShieldProperties(properties.component(DataComponents.BLOCKS_ATTACKS, (Object)HEATER_SHIELD_BLOCKS_ATTACKS_COMPONENT).component((DataComponentType)ShieldDataComponents.SHIELD_INFORMATION.get(), (Object)CONFIG_SPIKED_HEATER_SHIELD_INFORMATION_COMPONENT));
    }

    public static Item.Properties spikedTargeShieldProperties(Item.Properties properties, float cooldownSeconds) {
        return ShieldLibUtils.defaultShieldProperties(properties.component(DataComponents.BLOCKS_ATTACKS, (Object)ShieldLibUtils.withCooldownSeconds(TARGE_SHIELD_BLOCKS_ATTACKS_COMPONENT, cooldownSeconds)).component((DataComponentType)ShieldDataComponents.SHIELD_INFORMATION.get(), (Object)SPIKED_TARGE_SHIELD_INFORMATION_COMPONENT));
    }

    public static Item.Properties spikedTargeShieldProperties(Item.Properties properties) {
        return ShieldLibUtils.defaultShieldProperties(properties.component(DataComponents.BLOCKS_ATTACKS, (Object)TARGE_SHIELD_BLOCKS_ATTACKS_COMPONENT).component((DataComponentType)ShieldDataComponents.SHIELD_INFORMATION.get(), (Object)CONFIG_SPIKED_TARGE_SHIELD_INFORMATION_COMPONENT));
    }

    public static Item.Properties buildShieldProperties(Item.Properties properties, ShieldInformation shieldInformation, BlocksAttacks blocksAttacks) {
        return ShieldLibUtils.defaultShieldProperties(properties.component((DataComponentType)ShieldDataComponents.SHIELD_INFORMATION.get(), (Object)shieldInformation).component(DataComponents.BLOCKS_ATTACKS, (Object)blocksAttacks));
    }

    public static Item.Properties defaultShieldProperties(Item.Properties properties) {
        return properties.equippableUnswappable(EquipmentSlot.OFFHAND).component(DataComponents.BREAK_SOUND, (Object)SoundEvents.SHIELD_BREAK);
    }

    public static Item.Properties withShieldComponent(Item.Properties properties, BlocksAttacks blocksAttacks) {
        return properties.equippableUnswappable(EquipmentSlot.OFFHAND).component(DataComponents.BLOCKS_ATTACKS, (Object)blocksAttacks);
    }

    public static BlocksAttacks withCooldownSeconds(BlocksAttacks in, float cooldownSeconds) {
        return new BlocksAttacks(in.blockDelaySeconds(), cooldownSeconds / 5.0f, in.damageReductions(), in.itemDamage(), in.bypassedBy(), in.blockSound(), in.disableSound());
    }

    @Deprecated
    public static BlocksAttacks withCooldownTicks(BlocksAttacks in, int cooldownTicks) {
        return new BlocksAttacks(in.blockDelaySeconds(), (float)cooldownTicks / 100.0f, in.damageReductions(), in.itemDamage(), in.bypassedBy(), in.blockSound(), in.disableSound());
    }

    public static ShieldInformation withAddedFeatures(ShieldInformation in, String ... features) {
        List<String> newFeatures = in.features();
        newFeatures.addAll(List.of(features));
        return new ShieldInformation(in.type(), newFeatures);
    }

    public static BlocksAttacks withHorizontalAngle(BlocksAttacks in, float angle) {
        ArrayList reductions = new ArrayList(in.damageReductions());
        ArrayList<BlocksAttacks.DamageReduction> newReductions = new ArrayList<BlocksAttacks.DamageReduction>();
        for (BlocksAttacks.DamageReduction reduction : reductions) {
            newReductions.add(new BlocksAttacks.DamageReduction(angle, reduction.type(), reduction.base(), reduction.factor()));
        }
        return new BlocksAttacks(in.blockDelaySeconds(), in.blockDelaySeconds(), newReductions, in.itemDamage(), in.bypassedBy(), in.blockSound(), in.disableSound());
    }

    public static int getEnchantmentLevel(ResourceLocation enchantmentId, ItemStack itemStack) {
        if (itemStack == null) {
            return 0;
        }
        ItemEnchantments enchants = itemStack.getEnchantments();
        AtomicInteger result = new AtomicInteger();
        for (Holder holder : enchants.keySet()) {
            holder.unwrapKey().ifPresent(key -> {
                if (key.location().equals((Object)enchantmentId)) {
                    result.set(enchants.getLevel(holder));
                }
            });
        }
        return result.get();
    }

    public static String getTranslationKey(TagKey<Item> key) {
        ResourceLocation location = key.location();
        return "tag.item." + location.getNamespace() + "." + location.getPath().replace('/', '.');
    }
}

