/*
 * Decompiled with CFR 0.152.
 */
package com.github.stellarwind22.shieldlib.lib.registry;

import com.github.stellarwind22.shieldlib.lib.component.ShieldDataComponents;
import com.github.stellarwind22.shieldlib.lib.component.ShieldInformation;
import com.github.stellarwind22.shieldlib.lib.object.ShieldLibUtils;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public record ShieldCooldownEntry(ShieldInformation shieldInformation, TagKey<Item> tag, Supplier<Float> cooldown) {
    public boolean matchShield(ItemStack stack) {
        ShieldInformation stackShieldInformation;
        if (stack.is(Items.SHIELD)) {
            stackShieldInformation = ShieldLibUtils.VANILLA_SHIELD_INFORMATION_COMPONENT;
        } else {
            if (!stack.has((DataComponentType)ShieldDataComponents.SHIELD_INFORMATION.get())) {
                return false;
            }
            stackShieldInformation = (ShieldInformation)stack.get((DataComponentType)ShieldDataComponents.SHIELD_INFORMATION.get());
            assert (stackShieldInformation != null);
        }
        return this.matchShield(stackShieldInformation);
    }

    public boolean matchShield(ShieldInformation stackShieldInformation) {
        return stackShieldInformation.isType(this.shieldInformation.type()) && stackShieldInformation.hasFeatures(this.shieldInformation.features());
    }

    public boolean matchWeapon(RegistryAccess access, ItemStack weapon) {
        return ((Registry)access.lookup(Registries.ITEM).orElseThrow()).getOrThrow(this.tag).stream().anyMatch(itemHolder -> ((Item)itemHolder.value()).equals(weapon.getItem()));
    }
}

