/*
 * Decompiled with CFR 0.152.
 */
package com.github.stellarwind22.shieldlib.mixin;

import com.github.stellarwind22.shieldlib.lib.event.ShieldEvents;
import com.github.stellarwind22.shieldlib.lib.object.ShieldLibUtils;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BlocksAttacks;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public class EntityMixin {
    @Inject(at={@At(value="TAIL")}, method={"push(Lnet/minecraft/world/entity/Entity;)V"})
    private void push(Entity other, CallbackInfo ci) {
        ItemStack shield;
        Player player;
        Entity self = (Entity)this;
        if (self instanceof Player && (player = (Player)self).isBlocking() && ShieldLibUtils.isShieldItem(shield = player.getUseItem())) {
            Level level;
            BlocksAttacks blocksAttacks = (BlocksAttacks)shield.get(DataComponents.BLOCKS_ATTACKS);
            if (blocksAttacks == null) {
                return;
            }
            if (!player.level().isClientSide() && (level = player.level()) instanceof ServerLevel) {
                double angle;
                ServerLevel serverLevel = (ServerLevel)level;
                Vec3 otherPos = other.position();
                if (otherPos != null) {
                    Vec3 viewVector = self.calculateViewVector(0.0f, self.getYHeadRot());
                    Vec3 difference = otherPos.subtract(self.position());
                    difference = new Vec3(difference.x, 0.0, difference.z).normalize();
                    angle = Math.acos(difference.dot(viewVector));
                } else {
                    angle = Math.PI;
                }
                float resolved = blocksAttacks.resolveBlockedDamage(player.damageSources().playerAttack(player), 100.0f, angle);
                boolean withinAngle = resolved > 0.0f;
                ((ShieldEvents.ShieldCollide)ShieldEvents.COLLIDE.invoker()).onCollide(serverLevel, player, other, withinAngle, player.getUsedItemHand(), shield);
            }
        }
    }
}

