/*
 * Decompiled with CFR 0.152.
 */
package com.github.stellarwind22.shieldlib.test;

import com.github.stellarwind22.shieldlib.init.ShieldLib;
import com.github.stellarwind22.shieldlib.lib.component.ShieldDataComponents;
import com.github.stellarwind22.shieldlib.lib.component.ShieldInformation;
import com.github.stellarwind22.shieldlib.lib.config.ShieldLibConfig;
import com.github.stellarwind22.shieldlib.lib.event.ShieldEvents;
import com.github.stellarwind22.shieldlib.lib.object.ShieldLibItem;
import com.github.stellarwind22.shieldlib.lib.object.ShieldLibTags;
import com.github.stellarwind22.shieldlib.lib.object.ShieldLibUtils;
import com.github.stellarwind22.shieldlib.lib.registry.ShieldCooldownEntry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public class ShieldLibTests {
    protected static DeferredRegister<Item> TEST_ITEMS;
    protected static RegistrySupplier<Item> SHIELD;
    protected static RegistrySupplier<Item> TOWER_SHIELD;
    protected static RegistrySupplier<Item> COMPONENT_SHIELD;
    protected static RegistrySupplier<Item> BUCKLER_SHIELD;
    protected static RegistrySupplier<Item> HEATER_SHIELD;
    protected static RegistrySupplier<Item> TARGE_SHIELD;
    protected static RegistrySupplier<Item> SPIKED_TOWER_SHIELD;
    protected static RegistrySupplier<Item> SPIKED_BUCKLER_SHIELD;
    protected static RegistrySupplier<Item> SPIKED_HEATER_SHIELD;
    protected static RegistrySupplier<Item> SPIKED_TARGE_SHIELD;
    protected static ResourceLocation REFLECT_ID;
    protected static ResourceLocation RECOVERY_ID;

    public static void init() {
        TEST_ITEMS = DeferredRegister.create((String)"shieldlib", (ResourceKey)Registries.ITEM);
        SHIELD = ShieldLibTests.registerItem("shield", props -> new ShieldLibItem(props.durability(200), 5.0f, 9, Items.OAK_PLANKS, Items.SPRUCE_PLANKS));
        TOWER_SHIELD = ShieldLibTests.registerItem("tower_shield", props -> new ShieldLibItem(ShieldLibUtils.towerShieldProperties(props).durability(336), Items.OAK_PLANKS));
        ShieldInformation COMPONENT_SHIELD_INFORMATION = new ShieldInformation("component", List.of("config"));
        COMPONENT_SHIELD = ShieldLibTests.registerItem("component_shield", props -> new Item(ShieldLibUtils.buildShieldProperties(props, COMPONENT_SHIELD_INFORMATION, ShieldLibUtils.VANILLA_SHIELD_BLOCKS_ATTACKS_COMPONENT).durability(336).repairable(Items.OAK_PLANKS).enchantable(14)));
        ShieldLib.registerCooldownEntry(new ShieldCooldownEntry(COMPONENT_SHIELD_INFORMATION, ShieldLibTags.C_AXE, () -> Float.valueOf(ShieldLibConfig.tower_default_cooldown_seconds)), new ShieldCooldownEntry(COMPONENT_SHIELD_INFORMATION, ShieldLibTags.C_SHIELD, () -> Float.valueOf(ShieldLibConfig.buckler_default_cooldown_seconds)));
        ShieldLib.registerMovementModifier((player, stack, blocksAttacks, movement) -> {
            if (!stack.has((DataComponentType)ShieldDataComponents.SHIELD_INFORMATION.get())) {
                return movement;
            }
            ShieldInformation shieldInformation = (ShieldInformation)stack.get((DataComponentType)ShieldDataComponents.SHIELD_INFORMATION.get());
            assert (shieldInformation != null);
            if (shieldInformation.isType("component")) {
                return movement.scale(ShieldLibConfig.tower_movement_multiplier * 5.0f);
            }
            return movement;
        });
        BUCKLER_SHIELD = ShieldLibTests.registerItem("buckler_shield", props -> new ShieldLibItem(ShieldLibUtils.bucklerShieldProperties(props).durability(269), Items.OAK_PLANKS));
        HEATER_SHIELD = ShieldLibTests.registerItem("heater_shield", props -> new ShieldLibItem(ShieldLibUtils.heaterShieldProperties(props).durability(302), Items.OAK_PLANKS));
        TARGE_SHIELD = ShieldLibTests.registerItem("targe_shield", props -> new ShieldLibItem(ShieldLibUtils.targeShieldProperties(props).durability(436), Items.OAK_PLANKS));
        SPIKED_TOWER_SHIELD = ShieldLibTests.registerItem("spiked_tower_shield", props -> new ShieldLibItem(ShieldLibUtils.spikedTowerShieldProperties(props).durability(336), Items.OAK_PLANKS));
        SPIKED_BUCKLER_SHIELD = ShieldLibTests.registerItem("spiked_buckler_shield", props -> new ShieldLibItem(ShieldLibUtils.spikedBucklerShieldProperties(props).durability(269), Items.OAK_PLANKS));
        SPIKED_HEATER_SHIELD = ShieldLibTests.registerItem("spiked_heater_shield", props -> new ShieldLibItem(ShieldLibUtils.spikedHeaterShieldProperties(props).durability(302), Items.OAK_PLANKS));
        SPIKED_TARGE_SHIELD = ShieldLibTests.registerItem("spiked_targe_shield", props -> new ShieldLibItem(ShieldLibUtils.spikedTargeShieldProperties(props).durability(436), Items.OAK_PLANKS));
        TEST_ITEMS.register();
        ShieldEvents.BLOCK.register((level, defender, source, amount, hand, itemStack) -> {
            ShieldLib.LOGGER.info("Shield Block Event Ran!");
            int enchantmentLevel = ShieldLibUtils.getEnchantmentLevel(REFLECT_ID, itemStack);
            if (enchantmentLevel > 0) {
                Entity attacker = source.getEntity();
                if (attacker == null) {
                    return;
                }
                if (defender instanceof Player) {
                    attacker.hurtServer(level, attacker.damageSources().playerAttack((Player)defender), amount * (0.25f * (float)enchantmentLevel));
                } else {
                    attacker.hurtServer(level, attacker.damageSources().mobAttack(defender), amount * (0.25f * (float)enchantmentLevel));
                }
            }
        });
        ShieldLib.registerCooldownModifier((player, shield, blocksAttacks, currentCooldown) -> {
            int enchantmentLevel = ShieldLibUtils.getEnchantmentLevel(RECOVERY_ID, shield);
            if (enchantmentLevel > 0) {
                return (float)Math.round((currentCooldown - currentCooldown * (0.1f * (float)enchantmentLevel)) * 100.0f) / 100.0f;
            }
            return currentCooldown;
        });
    }

    public static void initClient() {
    }

    private static <T extends Item> RegistrySupplier<T> registerItem(String name, Function<Item.Properties, T> constructor) {
        return TEST_ITEMS.register(name, () -> {
            ResourceKey key = ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"shieldlib", (String)name));
            Item.Properties properties = new Item.Properties();
            properties = properties.setId(key);
            return (Item)constructor.apply(properties);
        });
    }

    static {
        REFLECT_ID = ResourceLocation.fromNamespaceAndPath((String)"shieldlib", (String)"reflect");
        RECOVERY_ID = ResourceLocation.fromNamespaceAndPath((String)"shieldlib", (String)"recovery");
    }
}

