/*
 * Decompiled with CFR 0.152.
 */
package com.github.stellarwind22.shieldlib.init;

import com.github.stellarwind22.shieldlib.lib.component.ShieldDataComponents;
import com.github.stellarwind22.shieldlib.lib.component.ShieldInformation;
import com.github.stellarwind22.shieldlib.lib.config.ShieldLibConfig;
import com.github.stellarwind22.shieldlib.lib.event.ShieldEvents;
import com.github.stellarwind22.shieldlib.lib.object.ShieldLibDamage;
import com.github.stellarwind22.shieldlib.lib.object.ShieldLibTags;
import com.github.stellarwind22.shieldlib.lib.object.ShieldLibUtils;
import com.github.stellarwind22.shieldlib.lib.registry.ShieldCooldownEntry;
import com.github.stellarwind22.shieldlib.lib.registry.ShieldCooldownModifier;
import com.github.stellarwind22.shieldlib.lib.registry.ShieldMovementModifier;
import com.github.stellarwind22.shieldlib.test.ShieldLibTests;
import com.mojang.datafixers.util.Pair;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.EntityEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10707;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_241;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShieldLib {
    private static final List<ShieldCooldownModifier> cooldownModifiers = new ArrayList<ShieldCooldownModifier>();
    private static final List<ShieldMovementModifier> movementModifiers = new ArrayList<ShieldMovementModifier>();
    private static final List<ShieldCooldownEntry> cooldownEntries = new ArrayList<ShieldCooldownEntry>();
    public static final String MOD_ID = "shieldlib";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"shieldlib");
    public static boolean IS_DEV;

    public static void init(boolean isDev) {
        IS_DEV = isDev;
        ShieldLibTags.init();
        ShieldDataComponents.init();
        ShieldLib.registerCooldownEntry(new ShieldCooldownEntry(ShieldLibUtils.VANILLA_SHIELD_INFORMATION_COMPONENT, ShieldLibTags.C_AXE, () -> Float.valueOf(ShieldLibConfig.vanilla_shield_cooldown_seconds)), new ShieldCooldownEntry(ShieldLibUtils.CONFIG_TOWER_SHIELD_INFORMATION_COMPONENT, ShieldLibTags.C_AXE, () -> Float.valueOf(ShieldLibConfig.tower_default_cooldown_seconds)), new ShieldCooldownEntry(ShieldLibUtils.CONFIG_BUCKLER_SHIELD_INFORMATION_COMPONENT, ShieldLibTags.C_AXE, () -> Float.valueOf(ShieldLibConfig.buckler_default_cooldown_seconds)), new ShieldCooldownEntry(ShieldLibUtils.CONFIG_HEATER_SHIELD_INFORMATION_COMPONENT, ShieldLibTags.C_AXE, () -> Float.valueOf(ShieldLibConfig.heater_default_cooldown_seconds)), new ShieldCooldownEntry(ShieldLibUtils.CONFIG_TARGE_SHIELD_INFORMATION_COMPONENT, ShieldLibTags.C_AXE, () -> Float.valueOf(ShieldLibConfig.targe_default_cooldown_seconds)));
        ShieldLib.registerMovementModifier((player, stack, blocksAttacks, movement) -> {
            float multiplier;
            if (stack.method_31574(class_1802.field_8255)) {
                return movement.method_35582(ShieldLibConfig.vanilla_shield_movement_multiplier * 5.0f);
            }
            if (!stack.method_57826((class_9331)ShieldDataComponents.SHIELD_INFORMATION.get())) {
                return movement;
            }
            ShieldInformation shieldInfo = (ShieldInformation)stack.method_58694((class_9331)ShieldDataComponents.SHIELD_INFORMATION.get());
            if (shieldInfo == null || !shieldInfo.hasFeature("config")) {
                return movement;
            }
            switch (shieldInfo.type()) {
                case "tower": {
                    float f = ShieldLibConfig.tower_movement_multiplier;
                    break;
                }
                case "buckler": {
                    float f = ShieldLibConfig.buckler_movement_multiplier;
                    break;
                }
                case "heater": {
                    float f = ShieldLibConfig.heater_movement_multiplier;
                    break;
                }
                case "targe": {
                    float f = ShieldLibConfig.targe_movement_multiplier;
                    break;
                }
                default: {
                    float f = multiplier = 0.0f;
                }
            }
            if (multiplier <= 0.0f) {
                return movement;
            }
            return movement.method_35582(multiplier * 5.0f);
        });
        ShieldEvents.CAN_BLOCK.register((level, defender, source, amount, hand, shield) -> {
            if (!ShieldLibConfig.buckler_blocks_arrows) {
                if (!shield.method_57826((class_9331)ShieldDataComponents.SHIELD_INFORMATION.get())) {
                    return EventResult.pass();
                }
                ShieldInformation shieldInfo = (ShieldInformation)shield.method_58694((class_9331)ShieldDataComponents.SHIELD_INFORMATION.get());
                assert (shieldInfo != null);
                class_1297 entity = source.method_5526();
                if (entity instanceof class_1665 && shieldInfo.isType("buckler")) {
                    return EventResult.interruptFalse();
                }
            }
            return EventResult.pass();
        });
        ShieldEvents.BLOCK.register((level, defender, source, amount, hand, shield) -> {
            float damage;
            if (!shield.method_57826((class_9331)ShieldDataComponents.SHIELD_INFORMATION.get())) {
                return;
            }
            ShieldInformation shieldInfo = (ShieldInformation)shield.method_58694((class_9331)ShieldDataComponents.SHIELD_INFORMATION.get());
            assert (shieldInfo != null);
            if (!shieldInfo.hasFeature("spiked") || !shieldInfo.hasFeature("config")) {
                return;
            }
            class_1297 attacker = source.method_5529();
            if (attacker == null) {
                return;
            }
            switch (shieldInfo.type()) {
                case "tower": {
                    float f = ShieldLibConfig.tower_spiked_hit_damage;
                    break;
                }
                case "buckler": {
                    float f = ShieldLibConfig.buckler_spiked_hit_damage;
                    break;
                }
                case "heater": {
                    float f = ShieldLibConfig.heater_spiked_hit_damage;
                    break;
                }
                case "targe": {
                    float f = ShieldLibConfig.targe_spiked_hit_damage;
                    break;
                }
                default: {
                    float f = damage = 0.0f;
                }
            }
            if (damage > 0.0f) {
                attacker.method_64397(level, ShieldLibDamage.sourceOf(level.method_30349(), ShieldLibDamage.HIT_SPIKED_SHIELD, (class_1297)defender, attacker), damage);
            }
        });
        ShieldEvents.BLOCK_FAIL.register((level, defender, source, amount, hand, shield) -> {
            if (!ShieldLibConfig.buckler_blocks_arrows) {
                if (!shield.method_57826((class_9331)ShieldDataComponents.SHIELD_INFORMATION.get())) {
                    return;
                }
                if (!shield.method_57826(class_9334.field_56396)) {
                    return;
                }
                ShieldInformation shieldInfo = (ShieldInformation)shield.method_58694((class_9331)ShieldDataComponents.SHIELD_INFORMATION.get());
                class_10707 blocksAttacks = (class_10707)shield.method_58694(class_9334.field_56396);
                assert (shieldInfo != null);
                assert (blocksAttacks != null);
                class_1297 entity = source.method_5526();
                if (entity instanceof class_1665 && shieldInfo.isType("buckler")) {
                    blocksAttacks.method_67204((class_1937)level, shield, defender, hand, amount);
                    class_1297 patt0$temp = source.method_5529();
                    if (patt0$temp instanceof class_1309) {
                        class_1309 attacker = (class_1309)patt0$temp;
                        ((ShieldEvents.ShieldDisable)ShieldEvents.DISABLE.invoker()).onDisable(level, attacker, defender, defender instanceof class_1657, hand, shield, 1.0f);
                    }
                    blocksAttacks.method_67200(level, defender, 1.0f, shield);
                }
            }
        });
        ShieldEvents.COLLIDE.register((level, player, collider, withinAngle, hand, shield) -> {
            float damage;
            boolean spiked;
            if (!shield.method_57826((class_9331)ShieldDataComponents.SHIELD_INFORMATION.get())) {
                return;
            }
            if (!withinAngle) {
                return;
            }
            ShieldInformation shieldInfo = (ShieldInformation)shield.method_58694((class_9331)ShieldDataComponents.SHIELD_INFORMATION.get());
            if (shieldInfo == null) {
                return;
            }
            boolean bl = spiked = shieldInfo.hasFeature("spiked") && shieldInfo.hasFeature("config");
            if (!spiked) {
                return;
            }
            switch (shieldInfo.type()) {
                case "tower": {
                    float f = ShieldLibConfig.tower_spiked_collide_damage;
                    break;
                }
                case "buckler": {
                    float f = ShieldLibConfig.buckler_spiked_collide_damage;
                    break;
                }
                case "heater": {
                    float f = ShieldLibConfig.heater_spiked_collide_damage;
                    break;
                }
                case "targe": {
                    float f = ShieldLibConfig.targe_spiked_collide_damage;
                    break;
                }
                default: {
                    float f = damage = 0.0f;
                }
            }
            if (damage > 0.0f && collider.method_64397(level, ShieldLibDamage.sourceOf(level.method_30349(), ShieldLibDamage.COLLIDE_SPIKED_SHIELD, collider, (class_1297)player), damage)) {
                class_10707 blocksAttacks = (class_10707)shield.method_58694(class_9334.field_56396);
                assert (blocksAttacks != null);
                class_3414 blockSound = (class_3414)blocksAttacks.comp_3590().orElseGet(() -> class_6880.method_40223((Object)class_3417.field_14833)).comp_349();
                level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), blockSound, class_3419.field_15248, 1.0f, 1.0f);
            }
        });
        EntityEvent.LIVING_HURT.register((target, source, amount) -> {
            class_1297 patt0$temp = source.method_5529();
            if (patt0$temp instanceof class_1309) {
                class_1309 attacker = (class_1309)patt0$temp;
                class_1937 patt1$temp = target.method_37908();
                if (patt1$temp instanceof class_3218) {
                    class_3218 serverLevel = (class_3218)patt1$temp;
                    ((ShieldEvents.ShieldAttack)ShieldEvents.ATTACK.invoker()).onAttack(serverLevel, source, target, amount, attacker.method_59958());
                }
            }
            return EventResult.pass();
        });
        if (IS_DEV) {
            ShieldLibTests.init();
        }
    }

    public static void registerCooldownEntry(ShieldCooldownEntry entry) {
        cooldownEntries.add(entry);
    }

    public static void registerCooldownEntry(ShieldCooldownEntry ... entries) {
        cooldownEntries.addAll(List.of(entries));
    }

    public static void registerCooldownModifier(ShieldCooldownModifier cooldownModifier) {
        cooldownModifiers.add(cooldownModifier);
    }

    public static void registerMovementModifier(ShieldMovementModifier movementModifier) {
        movementModifiers.add(movementModifier);
    }

    public static float getCooldownSeconds(class_5455 access, class_1799 weapon) {
        for (ShieldCooldownEntry cooldownEntry : cooldownEntries) {
            if (!cooldownEntry.matchWeapon(access, weapon)) continue;
            return cooldownEntry.cooldown().get().floatValue();
        }
        return 0.0f;
    }

    public static float getCooldownSeconds(class_1799 shield, class_10707 blocksAttacks) {
        for (ShieldCooldownEntry cooldownEntry : cooldownEntries) {
            if (!cooldownEntry.matchShield(shield)) continue;
            return cooldownEntry.cooldown().get().floatValue();
        }
        return blocksAttacks.comp_3587() * 5.0f;
    }

    public static class_241 getMovementWithModifiers(class_1657 player, class_1799 stack, class_10707 blocksAttacks, class_241 movement) {
        for (ShieldMovementModifier movementModifier : movementModifiers) {
            movement = movementModifier.modify(player, stack, blocksAttacks, movement);
        }
        return movement;
    }

    public static float getCooldownSecondsWithModifiers(class_1657 player, class_1799 stack, class_10707 blocksAttacks, float cooldown) {
        for (ShieldCooldownModifier cooldownModifier : cooldownModifiers) {
            cooldown = cooldownModifier.modify(player, stack, blocksAttacks, cooldown);
        }
        return cooldown;
    }

    @Environment(value=EnvType.CLIENT)
    public static Set<Pair<String, Float>> getTagTranslations(ShieldInformation shieldInformation) {
        HashSet<Pair<String, Float>> set = new HashSet<Pair<String, Float>>();
        cooldownEntries.forEach(cooldownEntry -> {
            if (cooldownEntry.matchShield(shieldInformation)) {
                set.add(new Pair((Object)ShieldLibUtils.getTranslationKey(cooldownEntry.tag()), (Object)cooldownEntry.cooldown().get()));
            }
        });
        return set;
    }
}

