/*
 * Decompiled with CFR 0.152.
 */
package com.github.stellarwind22.shieldlib.init;

import com.github.stellarwind22.shieldlib.init.ShieldLib;
import com.github.stellarwind22.shieldlib.lib.client.event.ShieldClientEvents;
import com.github.stellarwind22.shieldlib.lib.client.model.BucklerShieldLibModel;
import com.github.stellarwind22.shieldlib.lib.client.model.HeaterShieldModel;
import com.github.stellarwind22.shieldlib.lib.client.model.SpikedBucklerShieldModel;
import com.github.stellarwind22.shieldlib.lib.client.model.SpikedHeaterShieldModel;
import com.github.stellarwind22.shieldlib.lib.client.model.SpikedTargeShieldModel;
import com.github.stellarwind22.shieldlib.lib.client.model.SpikedTowerShieldModel;
import com.github.stellarwind22.shieldlib.lib.client.model.TargeShieldModel;
import com.github.stellarwind22.shieldlib.lib.client.render.BucklerShieldModelRenderer;
import com.github.stellarwind22.shieldlib.lib.client.render.HeaterShieldModelRenderer;
import com.github.stellarwind22.shieldlib.lib.client.render.SpikedBucklerShieldModelRenderer;
import com.github.stellarwind22.shieldlib.lib.client.render.SpikedHeaterShieldModelRenderer;
import com.github.stellarwind22.shieldlib.lib.client.render.SpikedTargeShieldModelRenderer;
import com.github.stellarwind22.shieldlib.lib.client.render.SpikedTowerShieldModelRenderer;
import com.github.stellarwind22.shieldlib.lib.client.render.TargeShieldModelRenderer;
import com.github.stellarwind22.shieldlib.lib.client.render.TowerShieldModelRenderer;
import com.github.stellarwind22.shieldlib.lib.component.ShieldDataComponents;
import com.github.stellarwind22.shieldlib.lib.component.ShieldInformation;
import com.github.stellarwind22.shieldlib.lib.config.ShieldLibConfig;
import com.github.stellarwind22.shieldlib.lib.object.ShieldLibTags;
import com.github.stellarwind22.shieldlib.lib.object.ShieldLibUtils;
import com.github.stellarwind22.shieldlib.mixin.client.SheetsAccessor;
import com.github.stellarwind22.shieldlib.mixin.client.SpecialModelRenderersAccessor;
import com.github.stellarwind22.shieldlib.test.ShieldLibTests;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import dev.architectury.registry.client.level.entity.EntityModelLayerRegistry;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10515;
import net.minecraft.class_10707;
import net.minecraft.class_10721;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_2582;
import net.minecraft.class_2960;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_5601;
import net.minecraft.class_5699;
import net.minecraft.class_6880;
import net.minecraft.class_9331;
import net.minecraft.class_9334;

@Environment(value=EnvType.CLIENT)
public class ShieldLibClient {
    public static final class_2960 TOWER_SHIELD_MODEL_TYPE = class_2960.method_60655((String)"shieldlib", (String)"tower_shield");
    public static final class_2960 BUCKLER_SHIELD_MODEL_TYPE = class_2960.method_60655((String)"shieldlib", (String)"buckler_shield");
    public static final class_2960 HEATER_SHIELD_MODEL_TYPE = class_2960.method_60655((String)"shieldlib", (String)"heater_shield");
    public static final class_2960 TARGE_SHIELD_MODEL_TYPE = class_2960.method_60655((String)"shieldlib", (String)"targe_shield");
    public static final class_2960 SPIKED_TOWER_SHIELD_MODEL_TYPE = class_2960.method_60655((String)"shieldlib", (String)"spiked_tower_shield");
    public static final class_2960 SPIKED_BUCKLER_SHIELD_MODEL_TYPE = class_2960.method_60655((String)"shieldlib", (String)"spiked_buckler_shield");
    public static final class_2960 SPIKED_HEATER_SHIELD_MODEL_TYPE = class_2960.method_60655((String)"shieldlib", (String)"spiked_heater_shield");
    public static final class_2960 SPIKED_TARGE_SHIELD_MODEL_TYPE = class_2960.method_60655((String)"shieldlib", (String)"spiked_targe_shield");
    public static final class_2960 SHIELD_ATLAS_LOCATION = class_2960.method_60656((String)"textures/atlas/shield_patterns.png");
    public static final class_5699.class_10388<class_2960, MapCodec<? extends class_10515.class_10516>> ID_MAPPER = SpecialModelRenderersAccessor.getIDMapper();
    public static boolean IS_DEV;

    public static void init(boolean isDev) {
        IS_DEV = isDev;
        ID_MAPPER.method_65325((Object)TOWER_SHIELD_MODEL_TYPE, TowerShieldModelRenderer.Unbaked.CODEC);
        ID_MAPPER.method_65325((Object)BUCKLER_SHIELD_MODEL_TYPE, BucklerShieldModelRenderer.Unbaked.CODEC);
        ID_MAPPER.method_65325((Object)HEATER_SHIELD_MODEL_TYPE, HeaterShieldModelRenderer.Unbaked.CODEC);
        ID_MAPPER.method_65325((Object)TARGE_SHIELD_MODEL_TYPE, TargeShieldModelRenderer.Unbaked.CODEC);
        ID_MAPPER.method_65325((Object)SPIKED_TOWER_SHIELD_MODEL_TYPE, SpikedTowerShieldModelRenderer.Unbaked.CODEC);
        ID_MAPPER.method_65325((Object)SPIKED_BUCKLER_SHIELD_MODEL_TYPE, SpikedBucklerShieldModelRenderer.Unbaked.CODEC);
        ID_MAPPER.method_65325((Object)SPIKED_HEATER_SHIELD_MODEL_TYPE, SpikedHeaterShieldModelRenderer.Unbaked.CODEC);
        ID_MAPPER.method_65325((Object)SPIKED_TARGE_SHIELD_MODEL_TYPE, SpikedTargeShieldModelRenderer.Unbaked.CODEC);
        EntityModelLayerRegistry.register((class_5601)BucklerShieldLibModel.LOCATION, BucklerShieldLibModel::createLayer);
        EntityModelLayerRegistry.register((class_5601)HeaterShieldModel.LOCATION, HeaterShieldModel::createLayer);
        EntityModelLayerRegistry.register((class_5601)TargeShieldModel.LOCATION, TargeShieldModel::createLayer);
        EntityModelLayerRegistry.register((class_5601)SpikedTowerShieldModel.LOCATION, SpikedTowerShieldModel::createLayer);
        EntityModelLayerRegistry.register((class_5601)SpikedBucklerShieldModel.LOCATION, SpikedBucklerShieldModel::createLayer);
        EntityModelLayerRegistry.register((class_5601)SpikedHeaterShieldModel.LOCATION, SpikedHeaterShieldModel::createLayer);
        EntityModelLayerRegistry.register((class_5601)SpikedTargeShieldModel.LOCATION, SpikedTargeShieldModel::createLayer);
        ShieldClientEvents.TOOLTIP.register((player, stack, context, flag, tooltip) -> {
            class_10707 blocksAttacks;
            if (stack.method_58694(class_9334.field_56396) == null || stack.method_31573(ShieldLibTags.NO_TOOLTIP)) {
                return;
            }
            if (ShieldLibConfig.show_cooldown_tooltip) {
                Set<Object> translations;
                if (!stack.method_57826(class_9334.field_56396)) {
                    return;
                }
                blocksAttacks = (class_10707)stack.method_58694(class_9334.field_56396);
                assert (blocksAttacks != null);
                if (stack.method_57826((class_9331)ShieldDataComponents.SHIELD_INFORMATION.get())) {
                    translations = ShieldLib.getTagTranslations((ShieldInformation)stack.method_58694((class_9331)ShieldDataComponents.SHIELD_INFORMATION.get()));
                } else {
                    translations = new HashSet<Pair>();
                    translations.add(new Pair((Object)ShieldLibUtils.getTranslationKey(ShieldLibTags.C_AXE), (Object)Float.valueOf(5.0f)));
                }
                if (translations.size() > 1) {
                    tooltip.add(class_2561.method_43470((String)""));
                    tooltip.add(class_2561.method_43471((String)"shieldlib.cooldown_tooltip.head").method_27692(class_124.field_1080));
                    for (Pair pair : translations) {
                        cooldownSeconds = ShieldLib.getCooldownSecondsWithModifiers(player, stack, blocksAttacks, ((Float)pair.getSecond()).floatValue());
                        String tag = class_2561.method_43471((String)((String)pair.getFirst())).getString();
                        String cooldown = String.valueOf(cooldownSeconds).replaceAll("\\.0*$", "");
                        String bodyTranslated = String.format(class_2561.method_43471((String)"shieldlib.cooldown_tooltip.body").getString(), tag, cooldown);
                        tooltip.add(class_2561.method_43470((String)(" " + bodyTranslated)).method_27692(class_124.field_1077));
                    }
                } else if (translations.size() == 1) {
                    Pair translation = (Pair)translations.iterator().next();
                    tooltip.add(class_2561.method_43470((String)""));
                    String string = String.format(class_2561.method_43471((String)"shieldlib.cooldown_tooltip.head.single").getString(), class_2561.method_43471((String)((String)translation.getFirst())).getString());
                    tooltip.add(class_2561.method_43470((String)string).method_27692(class_124.field_1080));
                    cooldownSeconds = ShieldLib.getCooldownSecondsWithModifiers(player, stack, blocksAttacks, ((Float)translation.getSecond()).floatValue());
                    String cooldown = String.valueOf(cooldownSeconds).replaceAll("\\.0*$", "");
                    String bodyTranslated = String.format(class_2561.method_43471((String)"shieldlib.cooldown_tooltip.body.single").getString(), cooldown);
                    tooltip.add(class_2561.method_43470((String)(" " + bodyTranslated)).method_27692(class_124.field_1077));
                }
            }
            if (ShieldLibConfig.show_movement_tooltip) {
                if (!stack.method_57826(class_9334.field_56396)) {
                    return;
                }
                blocksAttacks = (class_10707)stack.method_58694(class_9334.field_56396);
                assert (blocksAttacks != null);
                float movementMultiplier = ShieldLib.getMovementWithModifiers((class_1657)player, (class_1799)stack, (class_10707)blocksAttacks, (class_241)new class_241((float)1.0f, (float)1.0f)).field_1343 / 5.0f - 1.0f;
                if (movementMultiplier == 0.0f) {
                    return;
                }
                tooltip.add(class_2561.method_43470((String)""));
                tooltip.add(class_2561.method_43471((String)"shieldlib.movement_tooltip.head").method_27692(class_124.field_1080));
                String multiplierStr = String.valueOf(movementMultiplier * 100.0f).replaceAll("\\.0*$", "");
                if (movementMultiplier > 0.0f) {
                    String string = "+" + multiplierStr;
                    String movementTranslated = String.format(class_2561.method_43471((String)"shieldlib.movement_tooltip.body").getString(), string);
                    tooltip.add(class_2561.method_43470((String)(" " + movementTranslated)).method_27692(class_124.field_1078));
                } else if (movementMultiplier < 0.0f) {
                    String string = String.format(class_2561.method_43471((String)"shieldlib.movement_tooltip.body").getString(), multiplierStr);
                    tooltip.add(class_2561.method_43470((String)(" " + string)).method_27692(class_124.field_1061));
                }
            }
        });
        if (IS_DEV) {
            ShieldLibTests.initClient();
        }
    }

    public static class_4730 getShapedBannerMaterial(String shape, class_6880<class_2582> bannerPattern) {
        return ShieldLibClient.getShapedBannerMaterial(shape, ((class_2582)bannerPattern.comp_349()).comp_2456());
    }

    public static class_4730 getShapedBannerMaterial(String shape, class_2960 assetId) {
        Map<class_2960, class_4730> map = SheetsAccessor.getShieldMaterials();
        if (!Objects.equals(shape, "tower")) {
            assetId = assetId.method_45138(shape + "_");
        }
        class_10721 mapper = class_4722.field_56358;
        Objects.requireNonNull(mapper);
        return map.computeIfAbsent(assetId, arg_0 -> ((class_10721)mapper).method_67273(arg_0));
    }
}

