/*
 * Decompiled with CFR 0.152.
 */
package com.github.stellarwind22.shieldlib.test;

import com.github.stellarwind22.shieldlib.init.ShieldLib;
import com.github.stellarwind22.shieldlib.lib.component.ShieldDataComponents;
import com.github.stellarwind22.shieldlib.lib.component.ShieldInformation;
import com.github.stellarwind22.shieldlib.lib.config.ShieldLibConfig;
import com.github.stellarwind22.shieldlib.lib.event.ShieldEvents;
import com.github.stellarwind22.shieldlib.lib.object.ShieldLibItem;
import com.github.stellarwind22.shieldlib.lib.object.ShieldLibTags;
import com.github.stellarwind22.shieldlib.lib.object.ShieldLibUtils;
import com.github.stellarwind22.shieldlib.lib.registry.ShieldCooldownEntry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_9331;

public class ShieldLibTests {
    protected static DeferredRegister<class_1792> TEST_ITEMS;
    protected static RegistrySupplier<class_1792> SHIELD;
    protected static RegistrySupplier<class_1792> TOWER_SHIELD;
    protected static RegistrySupplier<class_1792> COMPONENT_SHIELD;
    protected static RegistrySupplier<class_1792> BUCKLER_SHIELD;
    protected static RegistrySupplier<class_1792> HEATER_SHIELD;
    protected static RegistrySupplier<class_1792> TARGE_SHIELD;
    protected static RegistrySupplier<class_1792> SPIKED_TOWER_SHIELD;
    protected static RegistrySupplier<class_1792> SPIKED_BUCKLER_SHIELD;
    protected static RegistrySupplier<class_1792> SPIKED_HEATER_SHIELD;
    protected static RegistrySupplier<class_1792> SPIKED_TARGE_SHIELD;
    protected static class_2960 REFLECT_ID;
    protected static class_2960 RECOVERY_ID;

    public static void init() {
        TEST_ITEMS = DeferredRegister.create((String)"shieldlib", (class_5321)class_7924.field_41197);
        SHIELD = ShieldLibTests.registerItem("shield", props -> new ShieldLibItem(props.method_7895(200), 5.0f, 9, class_1802.field_8118, class_1802.field_8113));
        TOWER_SHIELD = ShieldLibTests.registerItem("tower_shield", props -> new ShieldLibItem(ShieldLibUtils.towerShieldProperties(props).method_7895(336), class_1802.field_8118));
        ShieldInformation COMPONENT_SHIELD_INFORMATION = new ShieldInformation("component", List.of("config"));
        COMPONENT_SHIELD = ShieldLibTests.registerItem("component_shield", props -> new class_1792(ShieldLibUtils.buildShieldProperties(props, COMPONENT_SHIELD_INFORMATION, ShieldLibUtils.VANILLA_SHIELD_BLOCKS_ATTACKS_COMPONENT).method_7895(336).method_61648(class_1802.field_8118).method_61649(14)));
        ShieldLib.registerCooldownEntry(new ShieldCooldownEntry(COMPONENT_SHIELD_INFORMATION, ShieldLibTags.C_AXE, () -> Float.valueOf(ShieldLibConfig.tower_default_cooldown_seconds)), new ShieldCooldownEntry(COMPONENT_SHIELD_INFORMATION, ShieldLibTags.C_SHIELD, () -> Float.valueOf(ShieldLibConfig.buckler_default_cooldown_seconds)));
        ShieldLib.registerMovementModifier((player, stack, blocksAttacks, movement) -> {
            if (!stack.method_57826((class_9331)ShieldDataComponents.SHIELD_INFORMATION.get())) {
                return movement;
            }
            ShieldInformation shieldInformation = (ShieldInformation)stack.method_58694((class_9331)ShieldDataComponents.SHIELD_INFORMATION.get());
            assert (shieldInformation != null);
            if (shieldInformation.isType("component")) {
                return movement.method_35582(ShieldLibConfig.tower_movement_multiplier * 5.0f);
            }
            return movement;
        });
        BUCKLER_SHIELD = ShieldLibTests.registerItem("buckler_shield", props -> new ShieldLibItem(ShieldLibUtils.bucklerShieldProperties(props).method_7895(269), class_1802.field_8118));
        HEATER_SHIELD = ShieldLibTests.registerItem("heater_shield", props -> new ShieldLibItem(ShieldLibUtils.heaterShieldProperties(props).method_7895(302), class_1802.field_8118));
        TARGE_SHIELD = ShieldLibTests.registerItem("targe_shield", props -> new ShieldLibItem(ShieldLibUtils.targeShieldProperties(props).method_7895(436), class_1802.field_8118));
        SPIKED_TOWER_SHIELD = ShieldLibTests.registerItem("spiked_tower_shield", props -> new ShieldLibItem(ShieldLibUtils.spikedTowerShieldProperties(props).method_7895(336), class_1802.field_8118));
        SPIKED_BUCKLER_SHIELD = ShieldLibTests.registerItem("spiked_buckler_shield", props -> new ShieldLibItem(ShieldLibUtils.spikedBucklerShieldProperties(props).method_7895(269), class_1802.field_8118));
        SPIKED_HEATER_SHIELD = ShieldLibTests.registerItem("spiked_heater_shield", props -> new ShieldLibItem(ShieldLibUtils.spikedHeaterShieldProperties(props).method_7895(302), class_1802.field_8118));
        SPIKED_TARGE_SHIELD = ShieldLibTests.registerItem("spiked_targe_shield", props -> new ShieldLibItem(ShieldLibUtils.spikedTargeShieldProperties(props).method_7895(436), class_1802.field_8118));
        TEST_ITEMS.register();
        ShieldEvents.BLOCK.register((level, defender, source, amount, hand, itemStack) -> {
            ShieldLib.LOGGER.info("Shield Block Event Ran!");
            int enchantmentLevel = ShieldLibUtils.getEnchantmentLevel(REFLECT_ID, itemStack);
            if (enchantmentLevel > 0) {
                class_1297 attacker = source.method_5529();
                if (attacker == null) {
                    return;
                }
                if (defender instanceof class_1657) {
                    attacker.method_64397(level, attacker.method_48923().method_48802((class_1657)defender), amount * (0.25f * (float)enchantmentLevel));
                } else {
                    attacker.method_64397(level, attacker.method_48923().method_48812(defender), amount * (0.25f * (float)enchantmentLevel));
                }
            }
        });
        ShieldLib.registerCooldownModifier((player, shield, blocksAttacks, currentCooldown) -> {
            int enchantmentLevel = ShieldLibUtils.getEnchantmentLevel(RECOVERY_ID, shield);
            if (enchantmentLevel > 0) {
                return (float)Math.round((currentCooldown - currentCooldown * (0.1f * (float)enchantmentLevel)) * 100.0f) / 100.0f;
            }
            return currentCooldown;
        });
    }

    public static void initClient() {
    }

    private static <T extends class_1792> RegistrySupplier<T> registerItem(String name, Function<class_1792.class_1793, T> constructor) {
        return TEST_ITEMS.register(name, () -> {
            class_5321 key = class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"shieldlib", (String)name));
            class_1792.class_1793 properties = new class_1792.class_1793();
            properties = properties.method_63686(key);
            return (class_1792)constructor.apply(properties);
        });
    }

    static {
        REFLECT_ID = class_2960.method_60655((String)"shieldlib", (String)"reflect");
        RECOVERY_ID = class_2960.method_60655((String)"shieldlib", (String)"recovery");
    }
}

