/*
 * Decompiled with CFR 0.152.
 */
package com.connectorlib;

import com.connectorlib.ModConfig;
import com.connectorlib.ModConnector;
import com.connectorlib.messages.outbound.ClientAttributes;
import com.connectorlib.messages.outbound.ClientChat;
import com.connectorlib.messages.outbound.ClientInventory;
import com.connectorlib.messages.outbound.ClientPosition;
import com.connectorlib.messages.outbound.PlayerJoin;
import com.connectorlib.messages.outbound.PlayerQuit;
import com.connectorlib.messages.outbound.PlayerRespawn;
import com.croaklib.ModUpdater;
import dev.architectury.event.CompoundEventResult;
import dev.architectury.event.events.client.ClientChatEvent;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;

public final class ConnectorLibMod {
    public static final String MOD_ID = "connectorlib";

    public static void init() {
        ModUpdater.addMod((String)MOD_ID);
        if (!ModConfig.getInstance().get("analyticsEnabled").getAsBoolean()) {
            return;
        }
        int analyticsPeriod = ModConfig.getInstance().get("analyticsPeriod").getAsInt() / 50;
        ClientLifecycleEvent.CLIENT_SETUP.register(minecraftClient -> ModConnector.setup());
        ClientPlayerEvent.CLIENT_PLAYER_JOIN.register(player -> ModConnector.getInstance().send(new PlayerJoin(ConnectorLibMod.ip())));
        ClientPlayerEvent.CLIENT_PLAYER_QUIT.register(player -> ModConnector.getInstance().send(new PlayerQuit(ConnectorLibMod.ip())));
        ClientPlayerEvent.CLIENT_PLAYER_RESPAWN.register((oldPlayer, newPlayer) -> ModConnector.getInstance().send(new PlayerRespawn(oldPlayer.m_20182_())));
        ClientChatEvent.RECEIVED.register((parameters, message) -> {
            ModConnector.getInstance().send(new ClientChat(parameters, message));
            return CompoundEventResult.pass();
        });
        AtomicInteger tickCounter = new AtomicInteger();
        ClientTickEvent.CLIENT_POST.register(minecraftClient -> {
            if (tickCounter.incrementAndGet() > analyticsPeriod) {
                tickCounter.set(0);
                if (minecraftClient.f_91074_ != null) {
                    LocalPlayer player = minecraftClient.f_91074_;
                    ModConnector.getInstance().send(new ClientPosition(player));
                    ModConnector.getInstance().send(new ClientAttributes((Minecraft)minecraftClient));
                    ModConnector.getInstance().send(new ClientInventory(player.m_150109_()));
                }
            }
        });
    }

    private static String ip() {
        Minecraft minecraftClient = Minecraft.m_91087_();
        String ip = "unknown";
        if (minecraftClient.m_91089_() != null) {
            ip = minecraftClient.m_91089_().f_105363_;
        }
        return ip;
    }
}

