/*
 * Decompiled with CFR 0.152.
 */
package com.connectorlib.messages.outbound;

import com.connectorlib.BaseOutboundMessage;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ClientAttributes
extends BaseOutboundMessage {
    public int health;
    public int hunger;
    public int breath;
    public int saturation;
    public int exhaustion;
    public int exp_level;
    public float exp_prog;
    public int protection;
    public String gamemode;
    public int fps;
    public int ping;
    public ArrayList<Object[]> effects;

    public ClientAttributes(Minecraft minecraftClient) {
        LocalPlayer player = minecraftClient.f_91074_;
        if (player == null) {
            return;
        }
        Inventory inventory = player.m_150109_();
        FoodData hungerManager = player.m_36324_();
        ClientPacketListener nh = player.f_108617_;
        PlayerInfo entry = nh.m_104949_(player.m_20148_());
        this.health = (int)player.m_21223_();
        this.hunger = hungerManager.m_38702_();
        this.breath = player.m_20146_();
        this.saturation = (int)hungerManager.m_38722_();
        this.exhaustion = (int)hungerManager.m_150380_();
        this.exp_level = player.f_36078_;
        this.exp_prog = player.f_36080_;
        this.protection = 0;
        for (int i = 0; i < 4; ++i) {
            Item item = ((ItemStack)inventory.f_35975_.get(i)).m_41720_();
            if (!(item instanceof ArmorItem)) continue;
            ArmorItem armorItem = (ArmorItem)item;
            this.protection += armorItem.m_40404_();
        }
        this.gamemode = player.m_7500_() ? "creative" : (player.m_5833_() ? "spectator" : (player.m_150110_().f_35938_ ? "survival" : "adventure"));
        this.fps = minecraftClient.m_260875_();
        this.ping = entry != null ? entry.m_105330_() : 0;
        this.effects = new ArrayList(player.m_21221_().size());
        player.m_21221_().forEach((statusEffect, effectInstance) -> this.effects.add(new EffectData((MobEffectInstance)effectInstance).ser()));
    }

    public static class EffectData {
        String name;
        String type;
        int colour;
        int duration;
        int strength;

        public EffectData(MobEffectInstance effect) {
            this.name = effect.m_19544_().m_19481_();
            this.type = effect.m_19544_().m_19483_().name();
            this.colour = effect.m_19544_().m_19484_();
            this.duration = effect.m_19557_();
            this.strength = effect.m_19564_();
        }

        public Object[] ser() {
            return new Object[]{this.name, this.type, this.colour, this.duration, this.strength};
        }
    }
}

