/*
 * Decompiled with CFR 0.152.
 */
package com.connectorlib;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.architectury.platform.Platform;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class ModConfig {
    private static final Gson GSON = new GsonBuilder().serializeNulls().create();
    private static ModConfig instance;
    private static JsonObject config;

    private ModConfig() {
        try {
            Path filePath = this.getConfigFilePath();
            config = Files.exists(filePath, new LinkOption[0]) ? JsonParser.parseString((String)Files.readString(filePath)).getAsJsonObject() : this.createDefaultConfig();
            config = this.applyRestrictions(config);
            Files.writeString(filePath, (CharSequence)GSON.toJson((JsonElement)config), new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Path getConfigFilePath() {
        String configName = "connectorlib-config.json";
        return Platform.getConfigFolder().resolve(configName).toAbsolutePath();
    }

    private JsonObject createDefaultConfig() {
        JsonObject defaultConfig = new JsonObject();
        defaultConfig.addProperty("encryptionKey", "CHANGEMECHANGEME");
        defaultConfig.addProperty("analyticsServer", "ws://localhost:3740");
        defaultConfig.addProperty("analyticsPeriod", (Number)6000);
        defaultConfig.addProperty("analyticsEnabled", Boolean.valueOf(false));
        return defaultConfig;
    }

    private JsonObject applyRestrictions(JsonObject config) {
        JsonObject restrictions = config.deepCopy();
        float analyticsPeriod = config.get("analyticsPeriod").getAsFloat();
        analyticsPeriod = Math.max(1500.0f, Math.min(6000.0f, analyticsPeriod));
        restrictions.addProperty("analyticsPeriod", (Number)Float.valueOf(analyticsPeriod));
        return restrictions;
    }

    public static ModConfig getInstance() {
        if (instance == null) {
            instance = new ModConfig();
        }
        return instance;
    }

    public JsonElement get(String property) {
        return config.get(property);
    }
}

