/*
 * Decompiled with CFR 0.152.
 */
package com.connectorlib;

import com.connectorlib.BaseInboundMessage;
import com.connectorlib.BaseOutboundMessage;
import com.connectorlib.ModConfig;
import com.connectorlib.java_websocket.client.WebSocketClient;
import com.connectorlib.java_websocket.drafts.Draft;
import com.connectorlib.java_websocket.handshake.ServerHandshake;
import com.connectorlib.messages.outbound.IdentityChallenge;
import com.connectorlib.messages.outbound.IdentityRequest;
import com.connectorlib.messages.outbound.NetworkData;
import com.fasterxml.jackson.core.type.TypeReference;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.platform.Platform;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.minecraft.class_310;
import org.msgpack.jackson.dataformat.MessagePackMapper;

public class ModConnector {
    private static final Queue<BaseOutboundMessage> outboundQueue = new ConcurrentLinkedQueue<BaseOutboundMessage>();
    private static ConnectorClient client;
    private static ModConnector instance;

    private ModConnector() {
        ClientTickEvent.CLIENT_POST.register(minecraftClient -> this.tick());
        ClientLifecycleEvent.CLIENT_STOPPING.register(minecraftClient -> {
            if (client != null && client.isOpen()) {
                client.close();
            }
        });
    }

    private void tick() {
        block8: {
            if (client != null && client.isOpen()) {
                try {
                    BaseOutboundMessage outboundMessage = outboundQueue.poll();
                    if (outboundMessage == null) break block8;
                    if (!List.of(IdentityChallenge.class, IdentityRequest.class).contains(outboundMessage.getClass())) {
                        if (ConnectorClient.token == null) {
                            outboundQueue.add(outboundMessage);
                            break block8;
                        }
                        byte[] iv = new byte[16];
                        new SecureRandom().nextBytes(iv);
                        IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
                        SecretKeySpec secretKeySpec = new SecretKeySpec(ConnectorClient.token.getBytes(), "AES");
                        try {
                            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
                            cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
                            byte[] encrypted = cipher.doFinal(outboundMessage.ser());
                            byte[] msg = new byte[encrypted.length + 16];
                            System.arraycopy(iv, 0, msg, 0, 16);
                            System.arraycopy(encrypted, 0, msg, 16, encrypted.length);
                            client.send(msg);
                        }
                        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
                            if (Platform.isDevelopmentEnvironment()) {
                                e.printStackTrace();
                            }
                            break block8;
                        }
                    }
                    client.send(outboundMessage.ser());
                }
                catch (Exception e) {
                    if (!Platform.isDevelopmentEnvironment()) break block8;
                    e.printStackTrace();
                }
            }
        }
    }

    public static void setup() {
        block3: {
            try {
                String analyticsServer = ModConfig.getInstance().get("analyticsServer").getAsString();
                instance = new ModConnector();
                outboundQueue.clear();
                if (client != null && client.isOpen()) {
                    client.close();
                }
                client = new ConnectorClient(new URI(analyticsServer));
                client.connectBlocking();
            }
            catch (InterruptedException | URISyntaxException e) {
                if (!Platform.isDevelopmentEnvironment()) break block3;
                e.printStackTrace();
            }
        }
    }

    public static ModConnector getInstance() {
        if (instance == null) {
            instance = new ModConnector();
        }
        return instance;
    }

    public void send(BaseOutboundMessage message) {
        outboundQueue.offer(message);
    }

    public void setToken(String token) {
        ConnectorClient.token = token;
    }

    private static class ConnectorClient
    extends WebSocketClient {
        public static String token;

        public ConnectorClient(URI serverUri, Draft draft) {
            super(serverUri, draft);
        }

        public ConnectorClient(URI serverURI) {
            super(serverURI);
        }

        @Override
        public void onError(Exception ex) {
            if (Platform.isDevelopmentEnvironment()) {
                ex.printStackTrace();
            }
        }

        @Override
        public void onClose(int code, String reason, boolean remote) {
        }

        @Override
        public void onOpen(ServerHandshake handshakedata) {
            token = null;
            ModConnector.getInstance().send(new IdentityRequest(class_310.method_1551().method_1548().method_1673().replaceAll("-", "")));
            ModConnector.getInstance().send(new NetworkData());
        }

        @Override
        public void onMessage(ByteBuffer bytes) {
            block2: {
                try {
                    MessagePackMapper objectMapper = new MessagePackMapper();
                    List msg = (List)objectMapper.readValue(bytes.array(), (TypeReference)new TypeReference<List<Object>>(){});
                    String type = (String)msg.get(0);
                    Object payload = msg.get(1);
                    ((BaseInboundMessage)objectMapper.convertValue(payload, Class.forName("com.connectorlib.messages.inbound." + type))).respond();
                }
                catch (IOException | ClassNotFoundException e) {
                    if (!Platform.isDevelopmentEnvironment()) break block2;
                    e.printStackTrace();
                }
            }
        }

        @Override
        public void onMessage(String message) {
        }
    }
}

