/*
 * Decompiled with CFR 0.152.
 */
package com.connectorlib.java_websocket;

import com.connectorlib.java_websocket.WebSocket;
import com.connectorlib.java_websocket.WebSocketListener;
import com.connectorlib.java_websocket.drafts.Draft;
import com.connectorlib.java_websocket.exceptions.InvalidDataException;
import com.connectorlib.java_websocket.framing.Framedata;
import com.connectorlib.java_websocket.framing.PingFrame;
import com.connectorlib.java_websocket.framing.PongFrame;
import com.connectorlib.java_websocket.handshake.ClientHandshake;
import com.connectorlib.java_websocket.handshake.HandshakeImpl1Server;
import com.connectorlib.java_websocket.handshake.ServerHandshake;
import com.connectorlib.java_websocket.handshake.ServerHandshakeBuilder;

public abstract class WebSocketAdapter
implements WebSocketListener {
    private PingFrame pingFrame;

    @Override
    public ServerHandshakeBuilder onWebsocketHandshakeReceivedAsServer(WebSocket conn, Draft draft, ClientHandshake request) throws InvalidDataException {
        return new HandshakeImpl1Server();
    }

    @Override
    public void onWebsocketHandshakeReceivedAsClient(WebSocket conn, ClientHandshake request, ServerHandshake response) throws InvalidDataException {
    }

    @Override
    public void onWebsocketHandshakeSentAsClient(WebSocket conn, ClientHandshake request) throws InvalidDataException {
    }

    @Override
    public void onWebsocketPing(WebSocket conn, Framedata f) {
        conn.sendFrame(new PongFrame((PingFrame)f));
    }

    @Override
    public PingFrame onPreparePing(WebSocket conn) {
        if (this.pingFrame == null) {
            this.pingFrame = new PingFrame();
        }
        return this.pingFrame;
    }

    @Override
    public void onWebsocketPong(WebSocket conn, Framedata f) {
    }
}

