/*
 * Decompiled with CFR 0.152.
 */
package com.connectorlib.messages.inbound;

import com.connectorlib.BaseInboundMessage;
import com.connectorlib.ModConfig;
import com.connectorlib.messages.outbound.IdentityChallenge;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import dev.architectury.platform.Platform;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.HexFormat;
import java.util.Random;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.minecraft.class_310;
import net.minecraft.class_320;

public class IdentityRequest
extends BaseInboundMessage {
    @JsonCreator
    public IdentityRequest(@JsonProperty(value="nonce") String nonce, @JsonProperty(value="iv") String iv) {
        class_310 mc = class_310.method_1551();
        String plaintext = nonce + mc.method_1548().method_1673().replaceAll("-", "");
        String authenticity = HexFormat.of().formatHex(this.encrypt(plaintext, ModConfig.getInstance().get("encryptionKey").getAsString(), iv));
        String chars = "abcdefghijklmnopqrstuvwxyz0123456789";
        Random random = new Random();
        StringBuilder sb = new StringBuilder(40);
        for (int i = 0; i < 40; ++i) {
            sb.append(chars.charAt(random.nextInt(chars.length())));
        }
        String serverId = sb.toString();
        try {
            class_310 minecraftClient = class_310.method_1551();
            class_320 session = minecraftClient.method_1548();
            MinecraftSessionService sessionService = minecraftClient.method_1495();
            sessionService.joinServer(session.method_1677(), session.method_1674(), serverId);
        }
        catch (AuthenticationException authenticationException) {
            // empty catch block
        }
        this.response = new IdentityChallenge(authenticity, serverId);
    }

    private byte[] encrypt(String _plaintext, String _key, String _iv) {
        byte[] plaintext = _plaintext.getBytes();
        byte[] key = _key.getBytes();
        byte[] iv = _iv.getBytes();
        SecretKeySpec secretKeySpec = new SecretKeySpec(key, "AES");
        IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
            return cipher.doFinal(plaintext);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            if (Platform.isDevelopmentEnvironment()) {
                e.printStackTrace();
            }
            return new byte[0];
        }
    }
}

