/*
 * Decompiled with CFR 0.152.
 */
package net.marshlaw.complicatedbackpacks.item.inventory;

import javax.annotation.Nonnull;
import net.marshlaw.complicatedbackpacks.client.gui.IronBackpackGUIScreen;
import net.marshlaw.complicatedbackpacks.init.ComplicatedBackpacksModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.event.entity.item.ItemTossEvent;
import net.neoforged.neoforge.items.ComponentItemHandler;

@EventBusSubscriber(value={Dist.CLIENT})
public class IronBackpackInventoryCapability
extends ComponentItemHandler {
    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onItemDropped(ItemTossEvent event) {
        if (event.getEntity().getItem().getItem() == ComplicatedBackpacksModItems.IRON_BACKPACK.get() && Minecraft.getInstance().screen instanceof IronBackpackGUIScreen) {
            Minecraft.getInstance().player.closeContainer();
        }
    }

    public IronBackpackInventoryCapability(MutableDataComponentHolder parent) {
        super(parent, DataComponents.CONTAINER, 18);
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return stack.getItem() != ComplicatedBackpacksModItems.IRON_BACKPACK.get();
    }

    public ItemStack getStackInSlot(int slot) {
        return super.getStackInSlot(slot).copy();
    }
}

