/*
 * Decompiled with CFR 0.152.
 */
package com.spygstudios.chestshop;

import com.spygstudios.chestshop.commands.handlers.CommandHandler;
import com.spygstudios.chestshop.config.Config;
import com.spygstudios.chestshop.config.GuiConfig;
import com.spygstudios.chestshop.config.Message;
import com.spygstudios.chestshop.config.MessageConfig;
import com.spygstudios.chestshop.gui.DashboardGui;
import com.spygstudios.chestshop.gui.PlayersGui;
import com.spygstudios.chestshop.gui.ShopGui;
import com.spygstudios.chestshop.listeners.BreakListener;
import com.spygstudios.chestshop.listeners.BuildListener;
import com.spygstudios.chestshop.listeners.ChatListener;
import com.spygstudios.chestshop.listeners.ExplosionListener;
import com.spygstudios.chestshop.listeners.HopperListener;
import com.spygstudios.chestshop.listeners.InteractListener;
import com.spygstudios.chestshop.listeners.PlayerJoinListener;
import com.spygstudios.chestshop.listeners.gui.DashboardGuiHandler;
import com.spygstudios.chestshop.listeners.gui.InventoryCloseListener;
import com.spygstudios.chestshop.listeners.gui.PlayerGuiHandler;
import com.spygstudios.chestshop.listeners.gui.ShopGuiHandler;
import com.spygstudios.chestshop.shop.ShopFile;
import com.spygstudios.spyglib.hologram.HologramManager;
import com.spygstudios.spyglib.version.VersionChecker;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import lombok.Generated;
import net.milkbowl.vault.economy.Economy;
import org.bstats.bukkit.Metrics;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class ChestShop
extends JavaPlugin {
    private static ChestShop instance;
    private Economy economy;
    private Config conf;
    private GuiConfig guiConfig;
    private HologramManager hologramManager;
    private CommandHandler commandHandler;
    private MessageConfig messageConfig;
    private static final String API_URL = "https://hangar.papermc.io/api/v1/projects/Spyg-ChestShop/latestrelease";

    public ChestShop() {
        instance = this;
    }

    public void onEnable() {
        this.conf = new Config(this);
        this.guiConfig = new GuiConfig(this);
        this.messageConfig = new MessageConfig(this, this.conf.getString("locale"));
        Message.init(this.messageConfig);
        this.hologramManager = HologramManager.getManager((JavaPlugin)instance);
        this.commandHandler = new CommandHandler(instance);
        new InteractListener(this);
        new BreakListener(this);
        new BuildListener(this);
        new DashboardGuiHandler(instance);
        new PlayerGuiHandler(instance);
        new ShopGuiHandler(instance);
        new InventoryCloseListener(instance);
        new ExplosionListener(instance);
        new ChatListener(instance);
        new HopperListener(instance);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)instance, () -> {
            Map.Entry versionInfo = VersionChecker.isLatestVersion((String)API_URL, (String)this.getPluginMeta().getVersion());
            new PlayerJoinListener(instance, (String)versionInfo.getKey(), (Boolean)versionInfo.getValue());
        });
        this.loadLocalizations();
        try {
            new Metrics((Plugin)this, 24462);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getLogger().info("Loading economy plugin...");
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            this.getLogger().severe("Vault or economy plugin (e.g. Essentials) not found! Disabling plugin...");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.economy = (Economy)rsp.getProvider();
        this.getLogger().info("Loaded economy plugin: " + this.economy.getName());
        ShopFile.loadShopFiles(instance);
        ShopFile.startSaveScheduler(instance);
        String info = String.format("%s v. %s plugin has been enabled!", this.getName(), this.getPluginMeta().getVersion());
        this.getLogger().info(info);
    }

    public void onDisable() {
        if (this.commandHandler != null) {
            this.commandHandler.unregister();
        }
        ShopFile.saveShops();
        List<Object> guis = Arrays.asList(DashboardGui.DashboardHolder.class, PlayersGui.PlayersHolder.class, ShopGui.ShopHolder.class);
        for (Player player : Bukkit.getOnlinePlayers()) {
            InventoryHolder holder = player.getOpenInventory().getTopInventory().getHolder();
            if (!guis.contains(holder.getClass())) continue;
            player.closeInventory();
        }
        String info = String.format("%s v. %s plugin has been disabled!", this.getName(), this.getPluginMeta().getVersion());
        this.getLogger().info(info);
    }

    private void loadLocalizations() {
        File localeDirectory = new File(this.getDataFolder(), "locale");
        if (!localeDirectory.exists()) {
            localeDirectory.mkdirs();
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (JarFile jarFile = new JarFile(this.getFile());){
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    String fileName;
                    File targetFile;
                    JarEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (!name.startsWith("locale/") || entry.isDirectory() || (targetFile = new File(localeDirectory, fileName = name.substring("locale/".length()))).exists()) continue;
                    Throwable throwable2 = null;
                    Object var11_15 = null;
                    try (InputStream inputStream = this.getResource(name);){
                        if (inputStream == null) continue;
                        Files.copy(inputStream, targetFile.toPath(), new CopyOption[0]);
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Generated
    public static ChestShop getInstance() {
        return instance;
    }

    @Generated
    public Economy getEconomy() {
        return this.economy;
    }

    @Generated
    public Config getConf() {
        return this.conf;
    }

    @Generated
    public GuiConfig getGuiConfig() {
        return this.guiConfig;
    }

    @Generated
    public HologramManager getHologramManager() {
        return this.hologramManager;
    }

    @Generated
    public CommandHandler getCommandHandler() {
        return this.commandHandler;
    }

    @Generated
    public MessageConfig getMessageConfig() {
        return this.messageConfig;
    }

    @Generated
    public void setMessageConfig(MessageConfig messageConfig) {
        this.messageConfig = messageConfig;
    }
}

